/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.workflow.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTimeUtilities {
    public static final String YMD_DATE_FORMAT = "yyyy-MM-dd";
    public static final String YMDHMS_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String HHMMSS_DATE_FORMAT = "HH:mm:ss";
    public static final String BASE_HHMMSS = "00:00:00";

    private DateTimeUtilities() {
    }

    public static String getYesterdayDate(String aDateFormat) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat(aDateFormat);
        cal.add(5, -1);
        return dateFormat.format(cal.getTime());
    }

    public static String setDateFormat(String aDate, String aDateFormat) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(aDateFormat);
        return dateFormat.format(aDate);
    }

    public static String setDateFormat(Date aDate, String aDateFormat) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(aDateFormat);
        return dateFormat.format(aDate);
    }

    public static String getCurrentTime(String aDateFormat) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(aDateFormat);
        Date date = new Date();
        return dateFormat.format(date);
    }

    public static Boolean ValidLicenseWindow(String aDate) throws ParseException {
        Boolean status = null;
        Date currentDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(YMD_DATE_FORMAT);
        Calendar date = Calendar.getInstance();
        date.setTime(dateFormat.parse(aDate));
        date.add(10, 23);
        date.add(12, 59);
        date.add(13, 59);
        status = date.getTime().compareTo(currentDate) <= 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        return status;
    }

    public static String TimeInMilliseconds(String aTime) {
        Date myTime;
        Date baseTime;
        SimpleDateFormat df = new SimpleDateFormat(HHMMSS_DATE_FORMAT);
        try {
            baseTime = df.parse(BASE_HHMMSS);
            myTime = df.parse(aTime);
        }
        catch (ParseException pe1) {
            return "";
        }
        Long baseTimeInMillis = baseTime.getTime();
        Long myTimeInMillis = myTime.getTime();
        return Long.toString(myTimeInMillis - baseTimeInMillis);
    }

    public static String CurrentTimeInMilliseconds() {
        Long milliseconds = System.currentTimeMillis();
        return Long.toString(milliseconds);
    }
}

