/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.workflow.utils;

import com.ericsson.scac.cms.workflow.utils.ActionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class IO {
    private static final Logger logger = Logger.getLogger(IO.class);

    public static long calculateMaxUntarTime(long fileSize) {
        logger.info((Object)("called for: " + fileSize));
        long maxUntarTime = 1800L + (long)(2.2E-4 * (double)fileSize / 1024.0);
        return maxUntarTime;
    }

    public static String convertFileArrayToStringList(File[] files) {
        if (null == files || 0 == files.length) {
            logger.error((Object)"Null or empty array argument!");
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (File file : files) {
            sb.append(file.getAbsolutePath());
            sb.append(',');
        }
        String commaDelimitedString = sb.toString().substring(0, sb.length() - 1);
        return commaDelimitedString;
    }

    public static void copyfile(String srFile, String dtFile) throws IOException {
        int len;
        logger.info((Object)("Copying file [" + srFile + "] to [" + dtFile + "]."));
        File f1 = new File(srFile);
        File f2 = new File(dtFile);
        FileInputStream in = new FileInputStream(f1);
        FileOutputStream out = new FileOutputStream(f2);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
        logger.info((Object)"File copied.");
    }

    public static void createDir(File directory) {
        logger.debug((Object)("called for: " + directory.getAbsolutePath()));
        String filePath = directory.getAbsolutePath();
        if (!directory.exists() && !directory.mkdirs()) {
            throw new ActionException(String.format("The configured directory {%s} does not exist and cannot be created.", filePath));
        }
        if (!directory.isDirectory()) {
            throw new ActionException(String.format("The configured directory {%s} is not a directory.", filePath));
        }
    }

    public static void deleteDir(File dir) {
        logger.debug((Object)("called for: " + dir.getAbsolutePath()));
        if (!dir.delete()) {
            logger.info((Object)("Failed to delete directory: " + dir.getAbsolutePath()));
        }
    }

    public static boolean deleteDirectory(File directory) {
        logger.debug((Object)("called for: " + directory.getAbsolutePath()));
        if (directory.isDirectory()) {
            String[] children;
            for (String element : children = directory.list()) {
                boolean success = IO.deleteDirectory(new File(directory, element));
                if (success) continue;
                return false;
            }
        }
        return directory.delete();
    }

    public static void deleteParentDirsRecursively(File dir) {
        logger.debug((Object)("called for: " + dir.getAbsolutePath()));
        File parentDir = dir.getParentFile();
        if (null == dir || !dir.isDirectory() || dir.list().length > 0) {
            return;
        }
        logger.debug((Object)String.format("Deleting dir {%s}", dir.getAbsolutePath()));
        dir.delete();
        IO.deleteParentDirsRecursively(parentDir);
    }

    public static String getFileExtension(String fileName) {
        int lastDotIndex = fileName.lastIndexOf(".");
        String fileExtension = "";
        if (lastDotIndex != -1) {
            fileExtension = fileName.substring(lastDotIndex).toLowerCase();
        }
        return fileExtension;
    }

    public static File getSafeDirForPath(String path) throws ActionException {
        File file = IO.getSafeFileForPath(path);
        if (!file.isDirectory()) {
            throw new ActionException(String.format("The configured content folder {%s} is not a directory.", path));
        }
        return file;
    }

    public static File getSafeFileForPath(String path) throws ActionException {
        if (null == path || "".equals(path.trim())) {
            throw new ActionException(String.format("The configured content folder {%s} does not have a value specified.", path));
        }
        File file = new File(path);
        if (!file.exists() && !file.mkdirs()) {
            throw new ActionException(String.format("The configured content folder {%s} does not exist and cannot be created.", path));
        }
        return file;
    }

    public static File move(File dir, File assetFile) {
        logger.debug((Object)("called for dir: " + dir.getAbsolutePath() + "; file: " + assetFile.getAbsolutePath()));
        File movedFile = new File(dir, assetFile.getName());
        logger.info((Object)String.format("Moving %s to %s", assetFile.getPath(), movedFile.getPath()));
        boolean success = assetFile.renameTo(movedFile);
        if (!success) {
            IO.safeMove(dir, assetFile);
        }
        return movedFile;
    }

    private static void safeMove(File dir, File assetFile) {
        logger.debug((Object)("called for dir: " + dir.getAbsolutePath() + "; file: " + assetFile.getAbsolutePath()));
        String srcFile = assetFile.getAbsolutePath();
        String destFile = new File(dir, assetFile.getName()).getAbsolutePath();
        try {
            IO.copyfile(srcFile, destFile);
            assetFile.delete();
        }
        catch (IOException e) {
            throw new ActionException("Unable to move file", e);
        }
    }
}

