/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.workflow.utils;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ImageWatermark {
    public static final int MARK_LEFT_TOP = 1;
    public static final int MARK_RIGHT_TOP = 2;
    public static final int MARK_CENTER = 3;
    public static final int MARK_LEFT_BOTTOM = 4;
    public static final int MARK_RIGHT_BOTTOM = 5;

    public static final void markImage(String srcImg, String dstImg, String markImg, float alpha, int mark_position, int offset_X, int OFFSET_Y) throws ImageFormatException, IOException {
        File _file = new File(srcImg);
        if (!_file.exists()) {
            throw new FileNotFoundException(_file.getAbsolutePath());
        }
        BufferedImage src = ImageIO.read(_file);
        int width = ((Image)src).getWidth(null);
        int height = ((Image)src).getHeight(null);
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g = image.createGraphics();
        g.drawImage(src, 0, 0, width, height, null);
        File markFile = new File(markImg);
        if (!markFile.exists()) {
            throw new FileNotFoundException(markFile.getAbsolutePath());
        }
        BufferedImage mark_img = ImageIO.read(markFile);
        int mark_img_width = ((Image)mark_img).getWidth(null);
        int mark_img_height = ((Image)mark_img).getHeight(null);
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        switch (mark_position) {
            case 1: {
                g.drawImage(mark_img, offset_X, OFFSET_Y, mark_img_width, mark_img_height, null);
                break;
            }
            case 4: {
                g.drawImage(mark_img, offset_X, height - mark_img_height - OFFSET_Y, mark_img_width, mark_img_height, null);
                break;
            }
            case 3: {
                g.drawImage(mark_img, (width - mark_img_width - offset_X) / 2, (height - mark_img_height - OFFSET_Y) / 2, mark_img_width, mark_img_height, null);
                break;
            }
            case 2: {
                g.drawImage(mark_img, width - mark_img_width - offset_X, OFFSET_Y, mark_img_width, mark_img_height, null);
                break;
            }
            default: {
                g.drawImage(mark_img, width - mark_img_width - offset_X, height - mark_img_height - OFFSET_Y, mark_img_width, mark_img_height, null);
            }
        }
        g.dispose();
        FileOutputStream out = new FileOutputStream(dstImg);
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        encoder.encode(image);
        out.close();
    }
}

