/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.workflow.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class LoopUtil {
    private static final Logger logger = Logger.getLogger(LoopUtil.class);

    public static List<String> convertCommaSepListToList(String commaSepList) {
        return Arrays.asList(commaSepList.split(","));
    }

    public static List<String> convertCommaSepListToListSafely(String commaSepList) {
        String[] parts;
        ArrayList<String> list = new ArrayList<String>();
        if (commaSepList != null && !"".equals(commaSepList) && (parts = commaSepList.split(",")) != null) {
            for (String s : parts) {
                list.add(s);
            }
        }
        return list;
    }

    public static int updateCounter(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value + 1;
        }
        if ("".equals(value.toString())) {
            return 0;
        }
        try {
            return Integer.parseInt(value.toString()) + 1;
        }
        catch (NumberFormatException e) {
            logger.warn((Object)("Failed to parse value: " + value + " to an integer when getting Asset Mapping Loop Index, " + "using default value: 0"), (Throwable)e);
            return 0;
        }
    }

    public static String convertToCommaDelimitedList(List<String> list) {
        StringBuilder sb = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            int len = list.size() - 1;
            for (int i = 0; i < len; ++i) {
                sb.append(list.get(i)).append(",");
            }
            sb.append(list.get(len));
        } else {
            logger.debug((Object)"List was empty or null");
        }
        return sb.toString();
    }
}

