/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.workflow.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ManipulateFile {
    public static final String EXTENSION_PHY = "phy";
    public static final String EXTENSION_SEPARATOR = ".";
    private static final Logger logger = Logger.getLogger(ManipulateFile.class);
    public static final String SUFFIX_CLIP = "_clip";
    public static final String SUFFIX_ENCRYPTED = "_encrypted";
    public static final String SUFFIX_FLASH = "_flv";
    public static final String SUFFIX_LB_TRANSCODED = "_lb_transcoded";
    public static final String SUFFIX_OUTDATED = "_outdated";
    public static final String SUFFIX_TRANSCODED = "_transcoded";
    public static final String SUFFIX_WINDOWS_MEDIA = "_wmv";
    private static final String UNC_PATH_SEPARATOR = "\\\\";
    public static final String UNDERSCORE = "_";
    private static final String UNIX_PATH_SEPARATOR = "/";
    private Map<String, String> mountMap = new HashMap<String, String>();
    private Map<String, String> uncPathMap = new HashMap<String, String>();

    public ManipulateFile() {
        this.uncPathMap.clear();
        this.mountMap.clear();
    }

    public String appendOutdatedSuffix(String aFilePath) {
        String path = this.getPath(aFilePath);
        String newFileName = "";
        newFileName = path != "" ? path + File.separator + this.getFilename(aFilePath) + SUFFIX_OUTDATED + EXTENSION_SEPARATOR + this.getExtension(aFilePath) : this.getFilename(aFilePath) + SUFFIX_OUTDATED + EXTENSION_SEPARATOR + this.getExtension(aFilePath);
        return newFileName;
    }

    public String convertUNCToUnix(String uncPath) {
        if (uncPath == null) {
            return null;
        }
        String unixPath = this.replacePath(uncPath, true);
        return unixPath.replaceAll(UNC_PATH_SEPARATOR, UNIX_PATH_SEPARATOR);
    }

    public String convertUnixToUNC(String unixPath) {
        if (unixPath == null) {
            return null;
        }
        String uncPath = this.replacePath(unixPath, false);
        return uncPath.replaceAll(UNIX_PATH_SEPARATOR, UNC_PATH_SEPARATOR);
    }

    public byte[] createChecksum(String aFilePath) throws Exception {
        int numRead;
        FileInputStream fis = new FileInputStream(aFilePath);
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("MD5");
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
        return complete.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContents(File aFile) {
        StringBuilder contents = new StringBuilder();
        try {
            BufferedReader input = new BufferedReader(new FileReader(aFile));
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append(System.getProperty("line.separator"));
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return contents.toString();
    }

    public Boolean fileExists(String aFilePath) {
        Boolean exists = false;
        try {
            exists = new File(aFilePath).exists();
        }
        catch (NullPointerException npe) {
            exists = false;
            logger.debug((Object)("############### The file '" + aFilePath + "' does not exist."));
            npe.printStackTrace();
        }
        catch (SecurityException se) {
            exists = false;
            logger.debug((Object)("############### The file '" + aFilePath + "' cannot be read."));
            se.printStackTrace();
        }
        return exists;
    }

    public String getExtension(String aFilePath) {
        int extensionIndex = aFilePath.lastIndexOf(EXTENSION_SEPARATOR);
        String fileExtension = "";
        if (extensionIndex != -1) {
            fileExtension = aFilePath.substring(extensionIndex + 1);
        }
        return fileExtension;
    }

    public String getFilename(String aFilePath) {
        int extensionIndex = aFilePath.contains(EXTENSION_SEPARATOR) ? aFilePath.lastIndexOf(EXTENSION_SEPARATOR) : aFilePath.length();
        int filenameIndex = aFilePath.contains(File.separator) ? aFilePath.lastIndexOf(File.separator) : -1;
        return aFilePath.substring(filenameIndex + 1, extensionIndex);
    }

    public String getLastModified(String aFilePath) {
        String formatedDate = "";
        try {
            File file = new File(aFilePath);
            Long lastModified = file.lastModified();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            formatedDate = format.format(lastModified);
        }
        catch (NullPointerException ne) {
            ne.printStackTrace();
        }
        return formatedDate;
    }

    public String getMD5Checksum(String aFilePath) throws Exception {
        logger.debug((Object)("called for: " + aFilePath));
        byte[] b = this.createChecksum(aFilePath);
        String result = "";
        for (byte element : b) {
            result = result + Integer.toString((element & 0xFF) + 256, 16).substring(1);
        }
        logger.debug((Object)("returning: " + result));
        return result;
    }

    public String getMD5ChecksumSafely(String aFilePath) throws Exception {
        String result = "";
        try {
            byte[] b;
            int numRead;
            File file = new File(aFilePath);
            FileInputStream fis = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance("MD5");
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            ((InputStream)fis).close();
            for (byte element : b = complete.digest()) {
                result = result + Integer.toString((element & 0xFF) + 256, 16).substring(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return result;
    }

    public String getPath(String aFilePath) {
        int filenameIndex = 0;
        String path = "";
        filenameIndex = aFilePath.lastIndexOf(File.separator);
        if (filenameIndex != -1) {
            path = aFilePath.substring(0, filenameIndex);
        }
        return path;
    }

    public String getSize(String aFilePath) {
        logger.debug((Object)("called for: " + aFilePath));
        Long fileSize = null;
        String fileSizeStr = "";
        try {
            File file = new File(aFilePath);
            fileSize = file.length();
            fileSizeStr = fileSize.toString();
        }
        catch (NullPointerException ne) {
            fileSizeStr = "";
            logger.error((Object)ne);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        logger.debug((Object)("fileSizeStr: " + fileSizeStr));
        return fileSizeStr;
    }

    private String replacePath(String path, boolean isUNCPath) {
        String convertedPath = path.trim();
        Map<String, String> pathMap = isUNCPath ? this.uncPathMap : this.mountMap;
        for (String mappedPath : pathMap.keySet()) {
            if (!convertedPath.startsWith(mappedPath)) continue;
            convertedPath = pathMap.get(mappedPath) + convertedPath.substring(mappedPath.length());
            break;
        }
        return convertedPath;
    }

    public String getFileNameWithExtension(String aFilePath) {
        int filenameIndex = aFilePath.lastIndexOf(File.separator);
        String fileNamePlusExtension = "";
        if (filenameIndex != -1) {
            try {
                fileNamePlusExtension = aFilePath.substring(filenameIndex + 1);
                if (!fileNamePlusExtension.contains(EXTENSION_SEPARATOR)) {
                    fileNamePlusExtension = "";
                }
            }
            catch (IndexOutOfBoundsException iobe) {
                fileNamePlusExtension = "";
                iobe.printStackTrace();
            }
        }
        return fileNamePlusExtension;
    }

    public static void setPermissions(File file) {
        try {
            String path = file.getAbsolutePath();
            ProcessBuilder builder = new ProcessBuilder("chmod", "-R", "777", path);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            process.waitFor();
        }
        catch (SecurityException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    public static void setPermissions(String path) {
        try {
            ProcessBuilder builder = new ProcessBuilder("chmod", "-R", "777", path);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            process.waitFor();
        }
        catch (SecurityException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }
}

