/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.workflow.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ManipulateXML {
    Document xmlDoc;
    private static final Logger logger = Logger.getLogger(ManipulateXML.class);

    public ManipulateXML(String anXmlFile) throws Exception {
        logger.debug((Object)("instantiated for file: " + anXmlFile));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.xmlDoc = builder.parse(anXmlFile);
    }

    public void updateAsset(String anXPath, String anAttribute, String aValue) throws XPathExpressionException {
        logger.debug((Object)("xpath: " + anXPath));
        logger.debug((Object)(" attr: " + anAttribute));
        logger.debug((Object)("value: " + aValue));
        NodeList nodelist = this.getXMLNodes(anXPath, this.xmlDoc);
        logger.debug((Object)("nodelist-size: " + nodelist.getLength()));
        logger.debug((Object)"------");
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node node = nodelist.item(i);
            node.getAttributes().getNamedItem(anAttribute).setNodeValue(aValue);
        }
    }

    public void updateAssetSafely(String anXPath, String anAttribute, String aValue) throws XPathExpressionException {
        String[] unsafeValues;
        logger.debug((Object)("xpath: " + anXPath));
        logger.debug((Object)(" attr: " + anAttribute));
        logger.debug((Object)("value: " + aValue));
        logger.debug((Object)"------");
        if (aValue == null) {
            logger.error((Object)"A NULL value was detected, the metadata will NOT be updated");
            return;
        }
        for (String s : unsafeValues = new String[]{"null", "0", ""}) {
            if (!s.equalsIgnoreCase(aValue)) continue;
            logger.error((Object)"An unsafe value was detected, the metadata will NOT be updated");
            return;
        }
        NodeList nodelist = this.getXMLNodes(anXPath, this.xmlDoc);
        if (nodelist.getLength() > 1) {
            for (int i = 0; i < nodelist.getLength(); ++i) {
                Node node = nodelist.item(i);
                node.getAttributes().getNamedItem(anAttribute).setNodeValue(aValue);
            }
        } else {
            Node node = nodelist.item(0);
            if (nodelist != null && node != null) {
                node.getAttributes().getNamedItem(anAttribute).setNodeValue(aValue);
            }
        }
    }

    public void removeElement(String anXPath) throws XPathExpressionException {
        logger.debug((Object)("xpath: " + anXPath));
        NodeList nodelist = this.getXMLNodes(anXPath, this.xmlDoc);
        Node node = nodelist.item(0);
        if (nodelist != null && node != null) {
            Node theParentNode = node.getParentNode();
            theParentNode.removeChild(node);
        }
    }

    public void removeLastElement(String anXPath) throws XPathExpressionException {
        Node node;
        logger.debug((Object)("xpath: " + anXPath));
        NodeList nodelist = this.getXMLNodes(anXPath, this.xmlDoc);
        logger.debug((Object)("nodelist.size: " + Integer.toString(nodelist.getLength())));
        if (nodelist != null && (node = nodelist.item(nodelist.getLength() - 1)) != null) {
            Node theParentNode = node.getParentNode();
            Node lastNode = theParentNode.removeChild(node);
        }
    }

    public void addEncryptedAsset() throws XPathExpressionException {
        logger.debug((Object)"called");
        Element asset = this.xmlDoc.createElement("Asset");
        Element metadata = this.xmlDoc.createElement("Metadata");
        Element ams = this.xmlDoc.createElement("AMS");
        ams.setAttribute("Asset_Class", "encrypted");
        ams.setAttribute("Asset_ID", "");
        ams.setAttribute("Asset_Name", "");
        ams.setAttribute("Creation_Date", "");
        ams.setAttribute("Description", "");
        ams.setAttribute("Product", "");
        ams.setAttribute("Provider", "");
        ams.setAttribute("Provider_ID", "");
        ams.setAttribute("Verb", "");
        ams.setAttribute("Version_Major", "1");
        ams.setAttribute("Version_Minor", "0");
        Element appdata1 = this.xmlDoc.createElement("App_Data");
        appdata1.setAttribute("App", "MOD");
        appdata1.setAttribute("Name", "Asset_Encrypted");
        appdata1.setAttribute("Value", "");
        Element appdata2 = this.xmlDoc.createElement("App_Data");
        appdata2.setAttribute("App", "MOD");
        appdata2.setAttribute("Name", "Receiver_Type");
        appdata2.setAttribute("Value", "nds");
        Element appdata3 = this.xmlDoc.createElement("App_Data");
        appdata3.setAttribute("App", "MOD");
        appdata3.setAttribute("Name", "Encrypting_System_Info");
        appdata3.setAttribute("Value", "");
        Element appdata4 = this.xmlDoc.createElement("App_Data");
        appdata4.setAttribute("App", "MOD");
        appdata4.setAttribute("Name", "Encryption_Key_Block");
        appdata4.setAttribute("Value", "");
        Element appdata5 = this.xmlDoc.createElement("App_Data");
        appdata5.setAttribute("App", "MOD");
        appdata5.setAttribute("Name", "Content_FileSize");
        appdata5.setAttribute("Value", "");
        Element appdata6 = this.xmlDoc.createElement("App_Data");
        appdata6.setAttribute("App", "MOD");
        appdata6.setAttribute("Name", "Content_CheckSum");
        appdata6.setAttribute("Value", "");
        Element content = this.xmlDoc.createElement("Content");
        content.setAttribute("Value", "");
        metadata.appendChild(ams);
        metadata.appendChild(appdata1);
        metadata.appendChild(appdata2);
        metadata.appendChild(appdata3);
        metadata.appendChild(appdata4);
        metadata.appendChild(appdata5);
        metadata.appendChild(appdata6);
        asset.appendChild(metadata);
        asset.appendChild(content);
        NodeList nodelist = this.getXMLNodes("//ADI/Asset", this.xmlDoc);
        Node node = nodelist.item(0);
        if (nodelist != null && node != null) {
            node.appendChild(asset);
        }
    }

    public void addPosterAsset() throws XPathExpressionException {
        logger.debug((Object)"called");
        Element asset = this.xmlDoc.createElement("Asset");
        Element metadata = this.xmlDoc.createElement("Metadata");
        Element ams = this.xmlDoc.createElement("AMS");
        ams.setAttribute("Asset_Class", "poster");
        ams.setAttribute("Asset_ID", "");
        ams.setAttribute("Asset_Name", "");
        ams.setAttribute("Creation_Date", "");
        ams.setAttribute("Description", "");
        ams.setAttribute("Product", "");
        ams.setAttribute("Provider", "");
        ams.setAttribute("Provider_ID", "");
        ams.setAttribute("Verb", "");
        ams.setAttribute("Version_Major", "1");
        ams.setAttribute("Version_Minor", "0");
        Element appdata1 = this.xmlDoc.createElement("App_Data");
        appdata1.setAttribute("App", "MOD");
        appdata1.setAttribute("Name", "Type");
        appdata1.setAttribute("Value", "poster");
        Element appdata2 = this.xmlDoc.createElement("App_Data");
        appdata2.setAttribute("App", "MOD");
        appdata2.setAttribute("Name", "Content_FileSize");
        appdata2.setAttribute("Value", "");
        Element appdata3 = this.xmlDoc.createElement("App_Data");
        appdata3.setAttribute("App", "MOD");
        appdata3.setAttribute("Name", "Content_CheckSum");
        appdata3.setAttribute("Value", "");
        Element content = this.xmlDoc.createElement("Content");
        content.setAttribute("Value", "");
        metadata.appendChild(ams);
        metadata.appendChild(appdata1);
        metadata.appendChild(appdata2);
        metadata.appendChild(appdata3);
        asset.appendChild(metadata);
        asset.appendChild(content);
        NodeList nodelist = this.getXMLNodes("//ADI/Asset", this.xmlDoc);
        Node node = nodelist.item(0);
        if (nodelist != null && node != null) {
            node.appendChild(asset);
        }
    }

    public void addAsset(String xmlFragment) throws XPathExpressionException, SAXException, IOException, ParserConfigurationException {
        logger.debug((Object)("xmlFragment: " + xmlFragment));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Element asset = this.xmlDoc.createElement("Asset");
        Element metadata = this.xmlDoc.createElement("Metadata");
        Node ams = builder.parse(new InputSource(new StringReader(xmlFragment))).getDocumentElement();
        ams = this.xmlDoc.importNode(ams, true);
        metadata.appendChild(ams);
        asset.appendChild(metadata);
        NodeList nodelist = this.getXMLNodes("//ADI/Asset", this.xmlDoc);
        Node node = nodelist.item(0);
        if (nodelist != null && node != null) {
            node.appendChild(asset);
        }
    }

    public String getNodeValue(String anXPath, String anAttribute) throws XPathExpressionException {
        logger.debug((Object)("xpath: " + anXPath));
        logger.debug((Object)("attr: " + anAttribute));
        NodeList nodelist = this.getXMLNodes(anXPath, this.xmlDoc);
        Node node = nodelist.item(0);
        String nodeValue = "";
        if (nodelist != null && node != null) {
            nodeValue = node.getAttributes().getNamedItem(anAttribute).getNodeValue();
        }
        return nodeValue;
    }

    public String getNodeText(String anXPath) throws XPathExpressionException {
        logger.debug((Object)("xpath: " + anXPath));
        NodeList nodelist = this.getXMLNodes(anXPath, this.xmlDoc);
        Node node = nodelist.item(0);
        String nodeValue = "";
        if (nodelist != null && node != null) {
            nodeValue = node.getTextContent();
        }
        return nodeValue;
    }

    public String setAssetName(String aPackageAssetName, String aAssetClass) {
        return aPackageAssetName + "_" + aAssetClass;
    }

    public String setAssetId(String aPackageAssetId, String aAssetClass) {
        String assetId = "";
        if (aAssetClass == "title") {
            assetId = "CMTL" + aPackageAssetId.substring(4);
        } else if (aAssetClass == "movie") {
            assetId = "CMMV" + aPackageAssetId.substring(4);
        } else if (aAssetClass == "preview") {
            assetId = "CMPV" + aPackageAssetId.substring(4);
        } else if (aAssetClass == "poster") {
            assetId = "CMPO" + aPackageAssetId.substring(4);
        } else if (aAssetClass == "encrypted") {
            assetId = "NDSX" + aPackageAssetId.substring(4);
        }
        return assetId;
    }

    public void writeDoc(OutputStream outputStream) throws TransformerException {
        logger.debug((Object)"called");
        TransformerFactory transformerfactory = TransformerFactory.newInstance();
        Transformer transformer = transformerfactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        DOMSource domSource = new DOMSource(this.xmlDoc);
        transformer.transform(domSource, new StreamResult(outputStream));
    }

    public void addTitleAssetCategory(String aCategory) throws XPathExpressionException {
        logger.debug((Object)("category: " + aCategory));
        Element category = this.xmlDoc.createElement("App_Data");
        category.setAttribute("App", "MOD");
        category.setAttribute("Name", "Category");
        category.setAttribute("Value", aCategory);
        NodeList nodelist = this.getXMLNodes("//ADI/Asset/Metadata", this.xmlDoc);
        Node node = nodelist.item(0);
        if (nodelist != null && node != null) {
            node.appendChild(category);
        }
    }

    public void addAppDataElement(String anXPath, String anAppType, String aName, String aValue) throws XPathExpressionException {
        logger.debug((Object)("xpath: " + anXPath));
        logger.debug((Object)("apptype: " + anAppType));
        logger.debug((Object)("name: " + aName));
        logger.debug((Object)("value: " + aValue));
        Element appDataElement = this.xmlDoc.createElement("App_Data");
        appDataElement.setAttribute("App", anAppType);
        appDataElement.setAttribute("Name", aName);
        appDataElement.setAttribute("Value", aValue);
        NodeList nodelist = this.getXMLNodes(anXPath, this.xmlDoc);
        Node node = nodelist.item(0);
        if (nodelist != null && node != null) {
            node.appendChild(appDataElement);
        }
    }

    public void removeTitleAssetCategory(String aCategory) throws XPathExpressionException {
        logger.debug((Object)"called");
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xPath = xpf.newXPath();
        String category = "//ADI/Asset/Metadata/AMS[@Asset_Class='title']/../App_Data[@Name='Category' and @Value='" + aCategory + "']";
        Node theNode = (Node)xPath.evaluate(category, this.xmlDoc, XPathConstants.NODE);
        if (theNode == null) {
            return;
        }
        Node theParentNode = theNode.getParentNode();
        theParentNode.removeChild(theNode);
    }

    public void addAttribute(String anXPath, String anAttribute, String anAttributeValue) throws XPathExpressionException {
        logger.debug((Object)("xpath: " + anXPath));
        logger.debug((Object)(" attr: " + anAttribute));
        logger.debug((Object)("value: " + anAttributeValue));
        NodeList node = this.getXMLNodes(anXPath, this.xmlDoc);
        if (node != null && node.item(0) != null) {
            Element element = (Element)node.item(0);
            element.setAttribute(anAttribute, anAttributeValue);
        }
    }

    public String getAssetAMSNode(String anXPath) throws XPathExpressionException, TransformerException {
        logger.debug((Object)("xpath: " + anXPath));
        TransformerFactory transformerfactory = TransformerFactory.newInstance();
        Transformer transformer = transformerfactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource source = null;
        StringWriter outputSW = new StringWriter();
        StreamResult outputSR = new StreamResult(outputSW);
        NodeList nodes = this.getXMLNodes(anXPath, this.xmlDoc);
        if (nodes != null) {
            Node node = nodes.item(0);
            source = new DOMSource(node);
            transformer.transform(source, outputSR);
        }
        return outputSR.getWriter().toString();
    }

    private NodeList getXMLNodes(String anXPath, Document aFile) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xpath.evaluate(anXPath, aFile, XPathConstants.NODESET);
        return nodes;
    }

    public void addAsset(Element assetElem) throws XPathExpressionException, SAXException, IOException, ParserConfigurationException {
        logger.debug((Object)("assetElem: " + assetElem));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        NodeList nodelist = this.getXMLNodes("//ADI/Asset", this.xmlDoc);
        Node assetNode = this.xmlDoc.importNode(assetElem, true);
        Node node = nodelist.item(0);
        if (nodelist != null && node != null) {
            node.appendChild(assetNode);
        }
    }

    public String toString() {
        return ManipulateXML.toString(this.xmlDoc);
    }

    public static String toString(Document document) {
        String s = "";
        try {
            DOMSource source = new DOMSource(document);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
            writer.flush();
            s = writer.toString();
        }
        catch (TransformerException e) {
            logger.error((Object)e);
        }
        return s;
    }

    public Document getDocument() {
        return this.xmlDoc;
    }

    public static Element createAsset(Document doc, String id, String assetClass, String name, String provider, String providerId, String product, String description, String createDate, String versMajor, String versMinor, String verb) {
        Element assetElem = doc.createElement("Asset");
        Element metaElem = doc.createElement("Metadata");
        Element amsElem = doc.createElement("AMS");
        amsElem.setAttribute("Asset_Class", assetClass);
        amsElem.setAttribute("Asset_Name", name);
        amsElem.setAttribute("Provider", provider);
        amsElem.setAttribute("Product", product);
        amsElem.setAttribute("Version_Major", versMajor);
        amsElem.setAttribute("Version_Minor", versMinor);
        amsElem.setAttribute("Description", description);
        amsElem.setAttribute("Creation_Date", createDate);
        amsElem.setAttribute("Provider_ID", providerId);
        amsElem.setAttribute("Asset_ID", id);
        amsElem.setAttribute("Verb", verb);
        metaElem.appendChild(amsElem);
        metaElem.appendChild(ManipulateXML.createAppData(doc, "MOD", "Type", "blah"));
        metaElem.appendChild(ManipulateXML.createAppData(doc, "MOD", "ZZZZ", "asdfasdfasdf"));
        assetElem.appendChild(metaElem);
        return assetElem;
    }

    public static Element createAppData(Document doc, String app, String name, String value) {
        Element elem = doc.createElement("App_Data");
        elem.setAttribute("App", app);
        elem.setAttribute("Name", name);
        elem.setAttribute("Value", value);
        return elem;
    }

    public String toString(Element elem) throws TransformerException {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        StringWriter buffer = new StringWriter();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(new DOMSource(elem), new StreamResult(buffer));
        return buffer.toString();
    }

    public static void main(String[] args) throws Exception {
        String filepath = "C:\\Users\\EMASTJO\\Desktop\\vodplaylist_simple.xml";
        ManipulateXML xml = new ManipulateXML(filepath);
        String POSTER_ASSET_CL_XPATH = "//ADI/Asset/Asset/Metadata/AMS[@Asset_Class='poster']/../../.";
        String MOVIE_ASSET_METADATA_CL_XPATH = "//ADI/Asset/Asset/Metadata/AMS[@Asset_Class='movie']/../.";
        String TITLE_ASSET_METADATA_CL_XPATH = "//ADI/Asset/Metadata";
        xml.addAppDataElement(MOVIE_ASSET_METADATA_CL_XPATH, "MOD", "this", "that");
        logger.info((Object)xml);
    }
}

