/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.workflow.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbpm.graph.exe.ExecutionContext;

public class MaskParser {
    private static final String CLOSE_STR = "}";
    private static final String OPEN_STR = "{";
    private static final String TIMESTAMP = "timestamp";

    public static String parse(final ExecutionContext context, String mask) {
        IVariableCollection variableCollection = new IVariableCollection(){

            @Override
            public Object getVariable(String name) {
                return context.getVariable(name);
            }
        };
        return MaskParser.parse(variableCollection, mask);
    }

    public static String parse(IVariableCollection variableCollection, String mask) {
        String[] variables = MaskParser.extractVariables(mask);
        String parsed = mask;
        for (int i = 0; i < variables.length; ++i) {
            String variable = variables[i];
            Object value = null;
            value = TIMESTAMP.equals(variable) ? new SimpleDateFormat("yyyyMMddhhmmss").format(new Date()) : variableCollection.getVariable(variable);
            if (value == null) continue;
            parsed = parsed.replace(OPEN_STR + variable + CLOSE_STR, value.toString());
        }
        return parsed;
    }

    private static String[] extractVariables(String mask) {
        Matcher m = Pattern.compile("\\{([a-zA-Z0-9_]*)\\}").matcher(mask);
        ArrayList<String> result = new ArrayList<String>();
        while (m.find()) {
            result.add(m.group(1));
        }
        return result.toArray(new String[result.size()]);
    }

    public static void main(String[] args) throws Exception {
        IVariableCollection variableCollection = new IVariableCollection(){

            @Override
            public Object getVariable(String name) {
                if ("sourceId".equals(name)) {
                    return "source";
                }
                if ("partnerId".equals(name)) {
                    return "partner";
                }
                return null;
            }
        };
        String mask = "/{sourceId}/{partnerId}/test.txt";
        String parsed = MaskParser.parse(variableCollection, mask);
        System.out.println(parsed);
        if (!"/source/partner/test.txt".equals(parsed)) {
            throw new Exception("Parse failed");
        }
    }

    public static interface IVariableCollection {
        public Object getVariable(String var1);
    }
}

