/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.workflow.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbpm.graph.exe.ExecutionContext;

public final class PathConverter {
    private static final String FILE_NAME = "/opt/tandbergtv/cms/workflow/conf/ta-workflows/pathConversion.properties";
    private static PathConverter INSTANCE = null;
    private static final String UNC_PATH_SEPARATOR_PATTERN = "\\\\";
    private static final String UNIX_PATH_SEPARATOR_PATTERN = "/";
    private static final Pattern PATTERN_CONTEXT_VARIABLE = Pattern.compile("\\$\\{(.*?)\\}");
    private Map<String, String> mountMap = new HashMap<String, String>();
    private Map<String, String> uncPathMap = new HashMap<String, String>();

    public static synchronized PathConverter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PathConverter();
        }
        return INSTANCE;
    }

    private PathConverter() {
        this.loadPathConfiguration();
    }

    public String convertUNCToUnix(String uncPath) {
        if (uncPath == null) {
            return null;
        }
        String unixPath = this.replacePath(uncPath, true);
        return unixPath.replaceAll(UNC_PATH_SEPARATOR_PATTERN, UNIX_PATH_SEPARATOR_PATTERN);
    }

    public String convertUnixToUNC(String unixPath) {
        if (unixPath == null) {
            return null;
        }
        String uncPath = this.replacePath(unixPath, false);
        return uncPath.replaceAll(UNIX_PATH_SEPARATOR_PATTERN, UNC_PATH_SEPARATOR_PATTERN);
    }

    private synchronized void loadPathConfiguration() {
        this.mountMap.clear();
        this.uncPathMap.clear();
        try {
            FileInputStream stream = new FileInputStream(new File(FILE_NAME));
            Properties _config = new Properties();
            _config.load(stream);
            for (Object keyObject : _config.keySet()) {
                String mountPath = ((String)keyObject).trim();
                String uncPath = _config.getProperty(mountPath).trim();
                this.mountMap.put(mountPath, uncPath);
                this.uncPathMap.put(uncPath, mountPath);
            }
        }
        catch (IOException e) {
            String msg = "Failed to load the Path configuration file: /opt/tandbergtv/cms/workflow/conf/ta-workflows/pathConversion.properties";
            throw new RuntimeException("Failed to load the Path configuration file: /opt/tandbergtv/cms/workflow/conf/ta-workflows/pathConversion.properties", e);
        }
    }

    private String replacePath(String path, boolean isUNCPath) {
        String convertedPath = path.trim();
        Map<String, String> pathMap = isUNCPath ? this.uncPathMap : this.mountMap;
        for (String mappedPath : pathMap.keySet()) {
            if (!convertedPath.startsWith(mappedPath)) continue;
            convertedPath = pathMap.get(mappedPath) + convertedPath.substring(mappedPath.length());
            break;
        }
        return convertedPath;
    }

    public static String createPathFromProperty(ExecutionContext aContext, String property) {
        Matcher m = PATTERN_CONTEXT_VARIABLE.matcher(property);
        StringBuffer path = new StringBuffer();
        while (m.find()) {
            String varName = m.group(1);
            m.appendReplacement(path, PathConverter.getContextVariable(aContext, varName));
        }
        m.appendTail(path);
        return path.toString();
    }

    private static String getContextVariable(ExecutionContext aContext, String aVariable) {
        Object value = aContext.getVariable(aVariable);
        return value == null ? "" : value.toString();
    }
}

