/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.workflow.utils;

import com.ericsson.scac.cms.workflow.utils.ActionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public final class PathProperties {
    private static Properties _config;
    public static final String CONTENT_PATH = "contentPath";
    private static final String FILE_NAME = "/opt/tandbergtv/cms/conf/ta-workflow/path.properties";
    public static final String INGEST_ASSET_PATH = "provider.ingest.asset";
    public static final String INGEST_CONTENT_PATH = "provider.ingest";
    public static final String INGEST_PITCH_SCHEDULE_PATH = "provider.ingest.pitchSchedule";
    public static final String INGEST_PLANNER_PATH = "provider.ingest.planner";
    public static final String INGEST_PROGRAM_LIST_PATH = "provider.original.programList";
    public static final String ORIGINAL_ASSET_PATH = "provider.original.asset";
    public static final String ORIGINAL_CONTENT_PATH = "provider.original";
    public static final String ORIGINAL_PITCH_SCHEDULE_PATH = "provider.original.pitchSchedule";
    public static final String ORIGINAL_PLANNER_PATH = "provider.original.planner";
    public static final String ORIGINAL_PROGRAM_LIST_PATH = "provider.original.programList";
    public static final String PROCESSED_CONTENT_PATH = "provider.processed";
    public static final String PROCESSED_PITCH_SCHEDULE_PATH = "provider.processed.pitchSchedule";
    public static final String PROCESSED_PLANNER_PATH = "provider.processed.planner";
    public static final String PROCESSED_PROGRAM_LIST_PATH = "provider.processed.programList";
    public static final String PROCESSED_TITLE_ASSET = "title.processed.asset";
    public static final String PROCESSED_TITLE_PACKAGE = "title.processed.package";
    public static final String PROCESSED_TITLES_PATH = "provider.processed.title";
    public static final String TEMP_CONTENT_PATH = "tempContentPath";
    public static final String UNMAPPED_CONTENT_PATH = "unmappedContentPath";

    public static String getProperty(String key) {
        if (null == _config) {
            PathProperties.init();
        }
        return _config.getProperty(key);
    }

    private static File getProviderFolder(String providerId) {
        String contentPath = PathProperties.getProperty(CONTENT_PATH);
        return new File(contentPath, providerId);
    }

    public static String getProviderPath(String providerId) {
        return PathProperties.getProviderFolder(providerId).getAbsolutePath();
    }

    public static String getProviderPath(String providerId, String key) {
        File providerFolder = PathProperties.getProviderFolder(providerId);
        String relativePath = PathProperties.getProperty(key);
        return new File(providerFolder, relativePath).getAbsolutePath();
    }

    private static File getTitleFolder(String providerId, String titleId) {
        String titlesPath = PathProperties.getProviderPath(providerId, PROCESSED_TITLES_PATH);
        return new File(titlesPath, titleId);
    }

    public static String getTitlePath(String providerId, String titleId) {
        return PathProperties.getTitleFolder(providerId, titleId).getAbsolutePath();
    }

    public static String getTitlePath(String providerId, String titleId, String key) {
        File titleFolder = PathProperties.getTitleFolder(providerId, titleId);
        String relativePath = PathProperties.getProperty(key);
        return new File(titleFolder, relativePath).getAbsolutePath();
    }

    public static final File getUnmappedProviderFolder(String providerId) {
        String unmappedContentPath = PathProperties.getProperty(UNMAPPED_CONTENT_PATH);
        return new File(unmappedContentPath, providerId);
    }

    private static void init() {
        FileInputStream inputStream;
        _config = new Properties();
        try {
            inputStream = new FileInputStream(new File(FILE_NAME));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            throw new ActionException("Cannot load config file.");
        }
        try {
            _config.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private PathProperties() {
    }
}

