/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.workflow.utils;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.List;

public class TitleExplorer {
    private final Title title;

    public TitleExplorer(Long titleId) throws Exception {
        this.title = TitleExplorer.getTitle(titleId);
    }

    private static Title getTitle(Long titleId) throws Exception {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ITitleManager service = (ITitleManager)registry.lookup(ITitleManager.class);
        Title title = null;
        try {
            title = service.get(titleId);
        }
        catch (Exception e) {
            String msg = "Failed to read the Title from the persistence service, error: " + e.getMessage();
            throw new Exception(msg);
        }
        return title;
    }

    private Asset getGlobalAsset() throws Exception {
        Asset groupAsset = this.title.getAsset();
        if (groupAsset == null) {
            String msg = "Did not get a group object for title " + this.title.getId();
            throw new Exception(msg);
        }
        return groupAsset;
    }

    private Group getMovie() throws Exception {
        Asset groupAsset = this.getGlobalAsset();
        Group movie = null;
        for (Asset asset : groupAsset.getAllAssets(false)) {
            Group group;
            if (!(asset instanceof Group) || !(group = (Group)asset).getType().equals(Group.GroupType.MOVIE.name())) continue;
            movie = group;
            break;
        }
        if (movie == null) {
            String msg = "Did not get a MOVIE object for title " + this.title.getId();
            throw new Exception(msg);
        }
        return movie;
    }

    private Long getMovieRelationId() throws Exception {
        Group movie = this.getMovie();
        List relations = movie.getRelations();
        if (relations == null || relations.size() == 0) {
            String msg = "Did not get a PARENT_CHILD Id of MOVIE for title " + this.title.getId();
            throw new Exception(msg);
        }
        Long fileId = ((Relation)relations.get(0)).getTargetAsset().getId();
        return fileId;
    }

    private Group getPackage() throws Exception {
        Asset groupAsset = this.getGlobalAsset();
        Group pack = null;
        for (Asset asset : groupAsset.getAllAssets(false)) {
            Group group;
            if (!(asset instanceof Group) || !(group = (Group)asset).getType().equals(Group.GroupType.PACKAGE.name())) continue;
            pack = group;
            break;
        }
        if (pack == null) {
            String msg = "Did not get a PACKAGE object for title " + this.title.getId();
            throw new Exception(msg);
        }
        return pack;
    }

    public String getPackageUri() throws Exception {
        Asset groupAsset = this.getGlobalAsset();
        File fileADI = null;
        for (Asset asset : groupAsset.getAllAssets(true)) {
            Item item;
            if (!(asset instanceof File) || !(item = (Item)asset).getType().equals(Item.ItemType.FILE.name()) || !((File)item).getURL().toLowerCase().endsWith(".xml")) continue;
            fileADI = (File)item;
            break;
        }
        if (fileADI == null) {
            String msg = "Did not get an ADI file for title " + this.title.getId();
            throw new Exception(msg);
        }
        return fileADI.getURL();
    }

    public Long getPackageAssetId() throws Exception {
        Group pack = this.getPackage();
        return pack.getId();
    }

    public Long getMovieAssetId() throws Exception {
        Group movie = this.getMovie();
        return movie.getId();
    }

    public String getMovieUri() throws Exception {
        Asset groupAsset = this.getGlobalAsset();
        Long fileId = this.getMovieRelationId();
        File fileMovie = null;
        for (Asset asset : groupAsset.getAllAssets(true)) {
            Item item;
            if (!(asset instanceof File) || !(item = (Item)asset).getType().equals(Item.ItemType.FILE.name()) || item.getId() != fileId.longValue()) continue;
            fileMovie = (File)item;
            break;
        }
        if (fileMovie == null) {
            String msg = "Did not get a file movie object for title " + this.title.getId();
            throw new Exception(msg);
        }
        return fileMovie.getURL();
    }

    private Item getPoster() throws Exception {
        Asset groupAsset = this.getGlobalAsset();
        Item poster = null;
        for (Asset asset : groupAsset.getAllAssets(false)) {
            Item item;
            if (!(asset instanceof Item) || !(item = (Item)asset).getType().equals(Item.ItemType.POSTER.name())) continue;
            poster = item;
            break;
        }
        return poster;
    }

    private Long getPosterRelationId() throws Exception {
        Item poster = this.getPoster();
        if (poster == null) {
            return null;
        }
        List relations = poster.getRelations();
        if (relations == null || relations.size() == 0) {
            return null;
        }
        Long fileId = ((Relation)relations.get(0)).getTargetAsset().getId();
        return fileId;
    }

    public Long getPosterAssetId() throws Exception {
        Item poster = this.getPoster();
        if (poster == null) {
            String msg = "Did not get a file poster object for title " + this.title.getId();
            throw new Exception(msg);
        }
        return poster.getId();
    }

    public String getPosterUri() throws Exception {
        Asset groupAsset = this.getGlobalAsset();
        Long fileId = this.getPosterRelationId();
        if (fileId == null) {
            return null;
        }
        File filePoster = null;
        for (Asset asset : groupAsset.getAllAssets(true)) {
            Item item;
            if (!(asset instanceof File) || !(item = (Item)asset).getType().equals(Item.ItemType.FILE.name()) || item.getId() != fileId.longValue()) continue;
            filePoster = (File)item;
            break;
        }
        return filePoster == null ? null : filePoster.getURL();
    }

    public String getSeriesId() {
        return "";
    }

    public String getPreviewUri() throws Exception {
        Asset groupAsset = this.getGlobalAsset();
        Long fileId = this.getPreviewRelationId();
        File filePreview = null;
        for (Asset asset : groupAsset.getAllAssets(true)) {
            Item item;
            if (!(asset instanceof File) || !(item = (Item)asset).getType().equals(Item.ItemType.FILE.name()) || item.getId() != fileId.longValue()) continue;
            filePreview = (File)item;
            break;
        }
        if (filePreview == null) {
            String msg = "Did not get a file preview object for title " + this.title.getId();
            throw new Exception(msg);
        }
        return filePreview.getURL();
    }

    private Long getPreviewRelationId() throws Exception {
        Group preview = this.getPreview();
        List relations = preview.getRelations();
        if (relations == null || relations.size() == 0) {
            String msg = "Did not get a PARENT_CHILD Id of PREVIEW for title " + this.title.getId();
            throw new Exception(msg);
        }
        Long fileId = ((Relation)relations.get(0)).getTargetAsset().getId();
        return fileId;
    }

    public Group getPreview() throws Exception {
        Asset groupAsset = this.getGlobalAsset();
        Group preview = null;
        for (Asset asset : groupAsset.getAllAssets(false)) {
            Group group;
            if (!(asset instanceof Group) || !(group = (Group)asset).getType().equals(Group.GroupType.PREVIEW.name())) continue;
            preview = group;
            break;
        }
        return preview;
    }

    public Long getPreviewAssetId() throws Exception {
        Group preview = this.getPreview();
        return preview.getId();
    }
}

