/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.xml;

import com.ericsson.scac.cms.io.IO;
import com.ericsson.scac.cms.xml.XML;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ADI
extends XML {
    public static String DTD = "<!-- DTD for Package-->\n<!--CableLabs Asset Distribution Interface version 1.1 --> \n<!-- \n<!ENTITY amp \"&#38;#38;\"> -->\n<!ELEMENT ADI (Metadata, Asset* )>\n<!ELEMENT Asset ( Metadata, Asset*, Content?)>\n<!ELEMENT Metadata (AMS, App_Data*)> \n<!ELEMENT AMS (#PCDATA)> \n<!ATTLIST AMS \n  Asset_Name CDATA #REQUIRED\n  Asset_ID CDATA #REQUIRED\n  Asset_Class CDATA #REQUIRED\n  Provider CDATA #REQUIRED\n  Provider_ID CDATA #REQUIRED\n  Product CDATA #REQUIRED\n  Version_Minor CDATA #REQUIRED\n  Version_Major CDATA #REQUIRED\n  Description CDATA #REQUIRED\n  Creation_Date CDATA #REQUIRED\n  Verb CDATA #IMPLIED > \n<!ELEMENT App_Data (#PCDATA)>\n<!ATTLIST App_Data App CDATA #REQUIRED\n  Name CDATA #REQUIRED\n  Value CDATA #REQUIRED\n> \n<!ELEMENT Content (#PCDATA)>\n<!ATTLIST Content Value CDATA #REQUIRED\n>\n";
    static final Logger log = Logger.getLogger(IO.class);

    public static Collection<String> contentValues(Document document) throws Exception {
        ArrayList<String> values = new ArrayList<String>();
        try {
            List<Node> result = XML.evalToList(document, "//Content/attribute::Value");
            for (int i = 0; i < result.size(); ++i) {
                Attr ctntAttr = (Attr)result.get(i);
                values.add(ctntAttr.getValue());
            }
        }
        catch (Exception e) {
            throw new Exception("Error retrieving Content Values", e);
        }
        return values;
    }

    public static Set<String> duplicateAssetIds(Document document) throws Exception {
        return ADI.duplicates(document, "//AMS/attribute::Asset_ID");
    }

    public static Set<String> duplicates(Document document, String xpath) throws Exception {
        HashSet<String> values = new HashSet<String>();
        HashSet<String> dups = new HashSet<String>();
        try {
            List<Node> result = XML.evalToList(document, xpath);
            for (Node attr : result) {
                String attrValue = ((Attr)attr).getValue();
                if (values.contains(attrValue)) {
                    dups.add(attrValue);
                    continue;
                }
                values.add(attrValue);
            }
        }
        catch (Exception e) {
            throw new Exception("Error retrieving Duplicate Values", e);
        }
        return dups;
    }

    public static String[] getAssetFileNames(Object context) throws XPathExpressionException {
        List<Node> nodelist = XML.evalToList(context, "//Asset/Content/attribute::Value");
        ArrayList<String> assetFiles = new ArrayList<String>();
        for (Node node : nodelist) {
            assetFiles.add(node.getTextContent());
        }
        return assetFiles.toArray(new String[0]);
    }

    public static String getAssetId(Object context) throws XPathExpressionException {
        return XML.evalToString(context, "/ADI/Metadata/AMS/attribute::Asset_ID");
    }

    public static String getBoxCover(Object context) throws XPathExpressionException {
        String result = new XML("//AMS[(attribute::Asset_Class=\"boxcover\")]/../../Content/attribute::Value").evalToString(context);
        return result == null || result == "" ? null : result;
    }

    public static String getBoxcoverMd5(Object context) throws XPathExpressionException {
        String result = new XML("//AMS[(attribute::Asset_Class=\"boxcover\")]/..//App_Data[(attribute::Name=\"Content_CheckSum\")]/attribute::Value").evalToString(context);
        return result == null ? "" : result;
    }

    public static String getBoxcoverSize(Object context) throws XPathExpressionException {
        String result = new XML("//AMS[(attribute::Asset_Class=\"boxcover\")]/..//App_Data[(attribute::Name=\"Content_FileSize\")]/attribute::Value").evalToString(context);
        return result == null ? "" : result;
    }

    protected static DocumentBuilder getBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId.contains("ADI.DTD")) {
                    return new InputSource(new StringReader(DTD));
                }
                return null;
            }
        });
        return builder;
    }

    public static String getCategories(Object context, String listDelim) throws XPathExpressionException {
        String cats = "";
        try {
            List<Node> nodes = XML.evalToList(context, "//App_Data[attribute::Name ='Category']/attribute::Value");
            for (Node node : nodes) {
                cats = cats + (cats.equals("") ? "" : listDelim) + ((Attr)node).getValue();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error retrieving categories" + e), (Throwable)e);
        }
        return cats;
    }

    public static String getDisplayActors(Object context) throws XPathExpressionException {
        return XML.evalToString(context, "//App_Data[attribute::Name ='Title_Brief']/attribute::Value");
    }

    public static Document getDocument(File xmlFile) throws SAXException, IOException, ParserConfigurationException {
        return ADI.getBuilder().parse(xmlFile.toURI().toString());
    }

    protected static Document getDocument(InputSource in) throws SAXException, IOException, ParserConfigurationException {
        return ADI.getBuilder().parse(in);
    }

    public static Document getDocument(String xmlStr) throws SAXException, IOException, ParserConfigurationException {
        InputSource s = new InputSource(new StringReader(xmlStr));
        return ADI.getDocument(s);
    }

    public static String getEpisodeName(Object context) throws XPathExpressionException {
        return XML.evalToString(context, "//App_Data[attribute::Name ='Title']/attribute::Value");
    }

    public static String getGenres(Object context, String listDelim) throws XPathExpressionException {
        String cats = "";
        try {
            List<Node> nodes = XML.evalToList(context, "//App_Data[attribute::Name ='Genre']/attribute::Value");
            for (Node node : nodes) {
                cats = cats + (cats.equals("") ? "" : listDelim) + ((Attr)node).getValue();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error retrieving categories" + e), (Throwable)e);
        }
        return cats;
    }

    public static String getHdContent(Object context) throws XPathExpressionException {
        return XML.evalToString(context, "//App_Data[attribute::Name='Licensing_Window_End']/attribute::Value");
    }

    public static String getLicenseWindowEnd(Object context) throws XPathExpressionException {
        return XML.evalToString(context, "//App_Data[attribute::Name='Licensing_Window_End']/attribute::Value");
    }

    public static String getLicenseWindowStart(Object context) throws XPathExpressionException {
        return XML.evalToString(context, "//App_Data[attribute::Name='Licensing_Window_Start']/attribute::Value");
    }

    public static String getMovie(Object context) throws XPathExpressionException {
        String result = new XML("//AMS[(attribute::Asset_Class=\"movie\")]/../../Content/attribute::Value").evalToString(context);
        return result == null || result == "" ? null : result;
    }

    public static String getMovieMd5(Object context) throws XPathExpressionException {
        String result = new XML("//AMS[(attribute::Asset_Class=\"movie\")]/..//App_Data[(attribute::Name=\"Content_CheckSum\")]/attribute::Value").evalToString(context);
        return result == null ? "" : result;
    }

    public static String getMovieSize(Object context) throws XPathExpressionException {
        String result = new XML("//AMS[(attribute::Asset_Class=\"movie\")]/..//App_Data[(attribute::Name=\"Content_FileSize\")]/attribute::Value").evalToString(context);
        return result == null ? "" : result;
    }

    public static String getPackageName(Object context) throws XPathExpressionException {
        return XML.evalToString(context, "/ADI/Metadata/AMS/attribute::Asset_Name");
    }

    public static String getPoster(Object context) throws XPathExpressionException {
        String result = new XML("//AMS[(attribute::Asset_Class=\"poster\")]/../../Content/attribute::Value").evalToString(context);
        return result == null || result == "" ? null : result;
    }

    public static String getPosterMd5(Object context) throws XPathExpressionException {
        String result = new XML("//AMS[(attribute::Asset_Class=\"poster\")]/..//App_Data[(attribute::Name=\"Content_CheckSum\")]/attribute::Value").evalToString(context);
        return result == null ? "" : result;
    }

    public static String getPosterSize(Object context) throws XPathExpressionException {
        String result = new XML("//AMS[(attribute::Asset_Class=\"poster\")]/..//App_Data[(attribute::Name=\"Content_FileSize\")]/attribute::Value").evalToString(context);
        return result == null ? "" : result;
    }

    public static String getPreview(Object context) throws XPathExpressionException {
        String result = new XML("//AMS[(attribute::Asset_Class=\"preview\")]/../../Content/attribute::Value").evalToString(context);
        return result == null || result == "" ? null : result;
    }

    public static String getPreviewMd5(Object context) throws XPathExpressionException {
        String result = new XML("//AMS[(attribute::Asset_Class=\"preview\")]/..//App_Data[(attribute::Name=\"Content_CheckSum\")]/attribute::Value").evalToString(context);
        return result == null ? "" : result;
    }

    public static String getPreviewSize(Object context) throws XPathExpressionException {
        String result = new XML("//AMS[(attribute::Asset_Class=\"preview\")]/..//App_Data[(attribute::Name=\"Content_FileSize\")]/attribute::Value").evalToString(context);
        return result == null ? "" : result;
    }

    public static String getProduct(Object context) throws XPathExpressionException {
        return XML.evalToString(context, "/ADI/Metadata/AMS/attribute::Product");
    }

    public static String getProvider(Object context) throws XPathExpressionException {
        return XML.evalToString(context, "/ADI/Metadata/AMS/attribute::Provider");
    }

    public static String getProviderId(Object context) throws XPathExpressionException {
        return XML.evalToString(context, "/ADI/Metadata/AMS/attribute::Provider_ID");
    }

    public static String getRating(Object context) throws XPathExpressionException {
        return XML.evalToString(context, "//App_Data[attribute::Name='Licensing_Window_Start']/attribute::Value");
    }

    public static String getTitle(Object context) throws XPathExpressionException {
        return XML.evalToString(context, "//App_Data[attribute::Name ='Title']/attribute::Value");
    }

    public static String getTitleBrief(Object context) throws XPathExpressionException {
        return XML.evalToString(context, "//App_Data[attribute::Name ='Title_Brief']/attribute::Value");
    }

    private ADI(String setPattern) {
        super(setPattern);
    }
}

