/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.xml;

import com.ericsson.scac.cms.io.IO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XML {
    public static String DTD = "<!-- DTD for Package-->\n<!--CableLabs Asset Distribution Interface version 1.1 --> \n<!-- \n<!ENTITY amp \"&#38;#38;\"> -->\n<!ELEMENT ADI (Metadata, Asset* )>\n<!ELEMENT Asset ( Metadata, Asset*, Content?)>\n<!ELEMENT Metadata (AMS, App_Data*)> \n<!ELEMENT AMS (#PCDATA)> \n<!ATTLIST AMS \n  Asset_Name CDATA #REQUIRED\n  Asset_ID CDATA #REQUIRED\n  Asset_Class CDATA #REQUIRED\n  Provider CDATA #REQUIRED\n  Provider_ID CDATA #REQUIRED\n  Product CDATA #REQUIRED\n  Version_Minor CDATA #REQUIRED\n  Version_Major CDATA #REQUIRED\n  Description CDATA #REQUIRED\n  Creation_Date CDATA #REQUIRED\n  Verb CDATA #IMPLIED > \n<!ELEMENT App_Data (#PCDATA)>\n<!ATTLIST App_Data App CDATA #REQUIRED\n  Name CDATA #REQUIRED\n  Value CDATA #REQUIRED\n> \n<!ELEMENT Content (#PCDATA)>\n<!ATTLIST Content Value CDATA #REQUIRED\n>\n";
    public static final String ENCODING_DEFAULT = "ISO-8859-1";
    static final boolean isValidating = false;
    private static final Logger log = Logger.getLogger(XML.class);
    private XPathExpression expression;
    private final String pattern;

    public static String evalAttrValue(Object context, String pattern) {
        XML xPath = new XML(pattern);
        return xPath.evalAttrValue(context);
    }

    public static List<Node> evalToList(Object context, String pattern) throws XPathExpressionException {
        NodeList nList = XML.evalToNodeList(context, pattern);
        int length = nList.getLength();
        if (length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Node> list = new ArrayList<Node>(length);
        for (int i = 0; i < length; ++i) {
            list.add(nList.item(i));
        }
        return list;
    }

    public static Node evalToNode(Object context, String pattern) throws XPathExpressionException {
        XML xPath = new XML(pattern);
        Node node = xPath.evalToNode(context);
        return node;
    }

    public static NodeList evalToNodeList(Object context, String pattern) throws XPathExpressionException {
        XML xPath = new XML(pattern);
        return xPath.evalToNodeList(context);
    }

    public static Double evalToNumber(Object context, String pattern) throws XPathExpressionException {
        return new XML(pattern).evalToNumber(context);
    }

    public static String evalToString(Object context, String pattern) throws XPathExpressionException {
        return new XML(pattern).evalToString(context);
    }

    public static void format(File xmlFile, File targetFile, String encoding) throws IOException {
        try {
            Document doc = XML.getDocument(xmlFile);
            XML.format(targetFile, doc, encoding);
        }
        catch (Exception e) {
            throw new IOException("ERROR in PrettyXML.format - failed to format/write document! e=" + e + ":" + e.getMessage());
        }
    }

    public static void format(File targetFile, Document domDocument) throws Exception {
        XML.format(targetFile, domDocument, ENCODING_DEFAULT);
    }

    public static void format(File targetFile, Document doc, String encoding) throws IOException, TransformerException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(targetFile);
            XML.format(fos, doc, encoding);
        }
        catch (TransformerConfigurationException ex) {
            try {
                throw new TransformerException("Unexpected TransformerConfigurationException: " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                IO.close(fos);
                throw throwable;
            }
        }
        IO.close(fos);
    }

    public static void format(File xmlFile, String encoding) throws IOException {
        try {
            XML.format(xmlFile, XML.getDocument(xmlFile), encoding);
        }
        catch (Exception e) {
            throw new IOException("ERROR in PrettyXML.format - failed to format/write document! e=" + e + ":" + e.getMessage());
        }
    }

    public static OutputStream format(OutputStream out, Document doc, String encoding) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        if (doc.getDoctype() != null) {
            if (doc.getDoctype().getPublicId() != null) {
                transformer.setOutputProperty("doctype-public", doc.getDoctype().getPublicId());
            }
            if (doc.getDoctype().getSystemId() != null) {
                transformer.setOutputProperty("doctype-system", doc.getDoctype().getSystemId());
            }
        }
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", encoding);
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(out);
        transformer.transform(source, result);
        return out;
    }

    protected static DocumentBuilder getBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        return factory.newDocumentBuilder();
    }

    public static String getDocType(Document document) {
        DocumentType dtd = document.getDoctype();
        if (dtd == null) {
            throw new NullPointerException("DOCUMENT HAS NO DTD DECLARATION!");
        }
        return dtd.getSystemId();
    }

    public static Document getDocument(File xmlFile) throws SAXException, IOException, ParserConfigurationException {
        return XML.getBuilder().parse(xmlFile.toURI().toString());
    }

    protected static Document getDocument(InputSource in) throws SAXException, IOException, ParserConfigurationException {
        return XML.getBuilder().parse(in);
    }

    public static Document getDocument(String xmlStr) throws SAXException, IOException, ParserConfigurationException {
        InputSource s = new InputSource(new StringReader(xmlStr));
        return XML.getDocument(s);
    }

    public static boolean hasDocType(Document document) {
        return document.getDoctype() != null;
    }

    public static InputStream toInStream(Document doc) throws Exception {
        ByteArrayOutputStream baos = (ByteArrayOutputStream)XML.toOutStream(doc, (OutputStream)new ByteArrayOutputStream());
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static OutputStream toOutStream(Document doc, OutputStream outStream) throws Exception {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(outStream);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, result);
        xformer.setOutputProperty("encoding", ENCODING_DEFAULT);
        xformer.setOutputProperty("method", "XML");
        return outStream;
    }

    public static OutputStream toOutStream(String path, OutputStream outStream) throws Exception {
        return XML.toOutStream(XML.getDocument(path), outStream);
    }

    public static void toStdOut(Document doc) throws Exception {
    }

    public static OutputStream toStdOut(String path) throws Exception {
        return XML.toOutStream(XML.getDocument(path), (OutputStream)System.out);
    }

    public static String toString(Document doc) {
        return XML.toString(doc, ENCODING_DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Document doc, String encoding) {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            XML.format(baos, doc, encoding);
            String string = baos.toString();
            return string;
        }
        catch (Exception ex) {
            log.error((Object)("ERROR formatting XML! e=" + ex), (Throwable)ex);
            if (baos == null) {
                String string = "<ERROR>" + ex + "</ERROR>";
                return string;
            }
            String string = baos.toString();
            return string;
        }
        finally {
            IO.close(baos);
        }
    }

    public static void xForm(String srcPath, String destPath, String xslPath) throws SAXException, IOException, TransformerException, ParserConfigurationException {
        Document doc = XML.getDocument(new File(srcPath));
        DOMSource src = new DOMSource(doc);
        StreamResult res = destPath == null ? new StreamResult(System.out) : new StreamResult(new File(destPath));
        Transformer xFormer = xslPath != null ? TransformerFactory.newInstance().newTransformer(new StreamSource(xslPath)) : TransformerFactory.newInstance().newTransformer();
        xFormer.setOutputProperty("encoding", ENCODING_DEFAULT);
        xFormer.setOutputProperty("method", "XML");
        xFormer.transform(src, res);
    }

    public XML(String setPattern) {
        this.pattern = setPattern;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof XML) {
            return this.getPattern().equalsIgnoreCase(((XML)obj).getPattern());
        }
        return false;
    }

    public String evalAttrValue(Object context) {
        try {
            Node node = this.evalToNode(context);
            if (node != null && node instanceof Attr) {
                log.debug((Object)("\"" + node.getNodeValue() + "\"" + ((Attr)node).getValue()));
                return ((Attr)node).getValue();
            }
            return null;
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException("Error evaluating pattern '" + this.getPattern() + "' for Attribute Value! e=" + ex, ex);
        }
    }

    public Node evalToNode(Object context) throws XPathExpressionException {
        return (Node)this.getXpath().evaluate(context, XPathConstants.NODE);
    }

    public NodeList evalToNodeList(Object context) throws XPathExpressionException {
        return (NodeList)this.getXpath().evaluate(context, XPathConstants.NODESET);
    }

    public Double evalToNumber(Object context) throws XPathExpressionException {
        return (Double)this.getXpath().evaluate(context, XPathConstants.NUMBER);
    }

    public String evalToString(Object context) throws XPathExpressionException {
        return (String)this.getXpath().evaluate(context, XPathConstants.STRING);
    }

    public String getPattern() {
        return this.pattern;
    }

    private XPathExpression getXpath() throws XPathExpressionException {
        return this.expression == null ? (this.expression = XPathFactory.newInstance().newXPath().compile(this.getPattern())) : this.expression;
    }

    public int hashCode() {
        return this.getPattern().hashCode();
    }

    public String toString() {
        return this.getPattern();
    }
}

