/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadatamanager.specimpl.osvod;

import com.ericsson.metadatamanager.specimpl.osvod.OpenStreamVODIdentifier;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.specimpl.SingleTitleSpecHandler;
import java.util.HashMap;
import java.util.Map;

public class OpenStreamVODSpecHandler
extends SingleTitleSpecHandler {
    private static final String DUMMY_ROOTELEMENT_NAME = "VOD";

    public OpenStreamVODSpecHandler() {
        this.alias = "OpenStreamVOD";
        this.rootElementName = DUMMY_ROOTELEMENT_NAME;
    }

    public IIdentifier extractId(Asset asset) {
        OpenStreamVODIdentifier id = new OpenStreamVODIdentifier();
        id.setSearchService(this.getSearchService());
        id.setMappingResourceUrl(this.getMappingResourceUrl());
        Map<String, String> idXPaths = id.getTTVPaths();
        HashMap<String, String> idValues = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : idXPaths.entrySet()) {
            Field f = asset.getFirstField(entry.getValue());
            if (f == null) continue;
            idValues.put(entry.getKey(), f.getValue());
        }
        id.setSpecIdentifiers(idValues);
        return id;
    }

    public IdentifierBase getIdentifier() {
        OpenStreamVODIdentifier identifier = new OpenStreamVODIdentifier();
        identifier.setSearchService(this.searchService);
        identifier.setMappingResourceUrl(this.mappingResourceUrl);
        return identifier;
    }

    protected boolean isXPathPartOfSpec(String assetType, String ttvXPath) {
        boolean supperResult = super.isXPathPartOfSpec(assetType, ttvXPath);
        if (!supperResult && ttvXPath != null && ttvXPath.contains("tns:CustomField")) {
            return true;
        }
        return supperResult;
    }

    public String getSpecDisplayName() {
        return "OpenStreamVOD";
    }
}

