/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content;

import com.tandbergtv.content.metadata.IMetadataService;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.AbstractDispatcher;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.adaptor.util.XMLDocumentUtility;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class ContentMessageDispatcher
extends AbstractDispatcher {
    private static final Logger logger = Logger.getLogger(ContentMessageDispatcher.class);
    private static final String TITLE_MANAGER_SERVICE = "cms/TitleManagerProxy/local";
    private static final String METADATA_SERVICE = "cms/MetadataService/local";
    private static final String COMPONENT_NAME = "WatchPoint";
    private static final String ENTITY_NAME = "Workflow";
    protected static final int DEFAULT_MAXIMUM_MESSAGE_LENGTH = 2048;

    public ContentMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    public IMessage send(IMessage msg) throws DispatcherException {
        WorkflowMessage message = null;
        try {
            message = this.getWorkflowMessage(msg);
        }
        catch (Exception e) {
            String errMsg = "Failed to parse the workflow message, error: " + e.getMessage();
            throw new DispatcherException(errMsg, (Throwable)e);
        }
        WorkflowMessage response = null;
        try {
            response = this.generateResponse(message);
        }
        catch (RuntimeException e) {
            Throwable error = this.getError(e);
            String errorMessage = "Failed to perform operation, error: " + error.getMessage();
            response = this.generateNackMessage(message, errorMessage);
            logger.error((Object)errorMessage, (Throwable)e);
        }
        try {
            Document responseDocument = Marshaller.newMarshaller().marshal(response);
            String responseValue = XMLDocumentUtility.convertToString((Node)responseDocument);
            HTTPPayload httpPayload = new HTTPPayload(responseValue);
            HTTPMessage responseMsg = new HTTPMessage(httpPayload);
            logger.debug((Object)("Generated message: " + responseMsg));
            return responseMsg;
        }
        catch (Exception e) {
            String errMsg = "Could not serialize the workflow message response to XML, error: " + e.getMessage();
            throw new DispatcherException(errMsg, (Throwable)e);
        }
    }

    protected abstract WorkflowMessage generateResponse(WorkflowMessage var1);

    private WorkflowMessage getWorkflowMessage(IMessage message) throws Exception {
        Document doc = XMLDocumentUtility.loadXml((String)message.getPayload().getContent());
        return Unmarshaller.unmarshal((Document)doc);
    }

    protected WorkflowMessage generateNackMessage(WorkflowMessage request, String errorMessage) {
        WorkflowMessage response = WorkflowMessageFactory.createNackMessage((WorkflowMessage)request);
        response.putValue("error-message", errorMessage);
        return response;
    }

    protected String getIndexedParameterName(String parameterNamePrefix, int index) {
        return parameterNamePrefix + Integer.toString(index);
    }

    protected ITitleActionSource getActionSource(WorkflowMessage message) {
        return new TitleActionSource(COMPONENT_NAME, ENTITY_NAME, message.getKey().toString());
    }

    protected ITitleManager getTitleManager() {
        ITitleManager service = null;
        try {
            service = (ITitleManager)InitialContext.doLookup(TITLE_MANAGER_SERVICE);
        }
        catch (NamingException e) {
            String msg = "Failed to lookup the Title Manager service(cms/TitleManagerProxy/local).";
            throw new RuntimeException(msg);
        }
        return service;
    }

    protected IMetadataService getMetadataService() {
        IMetadataService service = null;
        try {
            service = (IMetadataService)ServiceRegistry.getDefault().lookup(IMetadataService.class);
        }
        catch (Exception e) {
            String msg = "Failed to lookup the Metadata service(cms/MetadataService/local).";
            throw new RuntimeException(msg);
        }
        return service;
    }

    protected String getPropertyValue(String property) {
        return this.getConfiguration().getParameterValue(property);
    }

    protected void saveXMLDocument(Document document, File xmlFile) {
        OutputStream outputStream = null;
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            String xmlEncoding = document.getXmlEncoding();
            if (xmlEncoding != null) {
                transformer.setOutputProperty("encoding", xmlEncoding);
            }
            outputStream = new FileOutputStream(xmlFile);
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (Exception e) {
            String message = "Failed to write XML document to file: " + xmlFile;
            throw new RuntimeException(message, e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception ex) {
                    String message = "Failed to close the output stream for the file: " + xmlFile;
                    logger.warn((Object)message, (Throwable)ex);
                }
            }
        }
    }

    private Throwable getError(RuntimeException e) {
        Exception error = e;
        while (error instanceof EJBException) {
            error = ((EJBException)error).getCausedByException();
        }
        return error;
    }

    protected Title getTitleForUpdate(long titleId) {
        Title title = null;
        try {
            title = this.getTitleManager().getForUpdate(Long.valueOf(titleId));
        }
        catch (RuntimeException e) {
            throw new RuntimeException("The title[" + titleId + "] does not exist.", e);
        }
        if (title == null) {
            throw new RuntimeException("The title[" + titleId + "] does not exist.");
        }
        if (!title.getIsActive().booleanValue()) {
            throw new RuntimeException("The title[" + title.getId() + "] has been deleted.");
        }
        return title;
    }

    protected Title getTitle(long titleId) {
        Title title = null;
        try {
            title = this.getTitleManager().get(Long.valueOf(titleId));
        }
        catch (RuntimeException e) {
            throw new RuntimeException("The title[" + titleId + "] does not exist.", e);
        }
        if (title == null) {
            throw new RuntimeException("The title[" + titleId + "] does not exist.");
        }
        return title;
    }

    protected Asset getAsset(Title title, long assetId) {
        return this.getAsset(title, assetId, true);
    }

    protected Asset getAsset(Title title, long assetId, boolean failOnNoMatch) {
        Asset asset = title.getAsset(assetId);
        if (asset == null && failOnNoMatch) {
            throw new RuntimeException("The title[" + title.getId() + "] does not contain asset[" + assetId + "]");
        }
        return asset;
    }

    protected com.tandbergtv.metadatamanager.model.File getFileAsset(Title title, long fileAssetId) {
        return this.getFileAsset(title, fileAssetId, true);
    }

    protected com.tandbergtv.metadatamanager.model.File getFileAsset(Title title, long fileAssetId, boolean failOnNoMatch) {
        com.tandbergtv.metadatamanager.model.File file = title.getFile(Long.valueOf(fileAssetId));
        if (file == null && failOnNoMatch) {
            throw new RuntimeException("The title[" + title.getId() + "] does not contain file asset[" + fileAssetId + "]");
        }
        return file;
    }

    protected String getFileSize(String fileURI) {
        try {
            File file = new File(fileURI);
            long length = file.length();
            return Long.toString(length);
        }
        catch (Exception ignore) {
            logger.debug((Object)("Failed to get file size for file: " + fileURI + ", ignoring error: " + ignore.getLocalizedMessage()), (Throwable)ignore);
            return null;
        }
    }

    protected String getCSVString(Collection<?> list) {
        StringBuilder buf = new StringBuilder();
        for (Object value : list) {
            if (buf.length() != 0) {
                buf.append(",");
            }
            buf.append(value);
        }
        return buf.toString();
    }

    protected String trimMessage(String message) {
        return this.trimMessage(message, 2048);
    }

    protected String trimMessage(String message, int maxLength) {
        if (message == null) {
            return "";
        }
        if (message.length() > maxLength) {
            message = message.substring(0, maxLength - 3) + "...";
        }
        return message;
    }

    protected String getCount(Collection<?> collection) {
        int size = collection != null ? collection.size() : 0;
        return Integer.toString(size);
    }

    protected String getOutputValue(Object value) {
        return value == null ? "" : value.toString();
    }
}

