/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.action;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.PagingInfo;
import com.ericsson.cms.devices.content.ContentMessageDispatcher;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.title.search.ITitleSearchPersistenceService;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.TitleSearchPropertiesProvider;
import com.tandbergtv.cms.title.search.entities.TitleSearch;
import com.tandbergtv.cms.title.search.entities.TitleSearchResultColumn;
import com.tandbergtv.cms.title.search.entities.UnathorizedUserException;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.search.XpathNodeCardinality;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.title.TitleSearchNotFoundException;
import com.tandbergtv.watchpoint.pmm.title.search.ExportHelper;
import com.tandbergtv.watchpoint.pmm.title.search.SearchPartnerProvider;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.Table;
import com.tandbergtv.workflow.web.table.TableConfig;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.hibernate.ScrollableResults;

public class ExecuteSavedSearchMessageHandler
extends ContentMessageDispatcher {
    private static String SAVED_SEARCH_ID = "searchId";
    private static String EXPORT_FILE_NAME = "resultsFilename";
    private static String SUCCESS = "success";
    private static int MAX_TITLES_AT_ONCE = 5000;
    private static String QUICK_INFO = "quickInfo";
    private static String SEARCH_RESULTS_TABLE = "SearchResultsColumns";
    private static String QUICK_SEARCH_TABLE = "quickInfoSearchColumns";
    private static String THUMBNAIL_COLUMN = "thumbnail";
    private static String ASSET_TYPE_IN_TABLE_COLUMN = "TitleSection";
    private static String TITLE_ID = "id";
    private static final String PMM_FOLDER_NAME = "pmm";
    private static final String TABLE_CONFIG_FILE_NAME = "table-config.xml";
    private static final Logger logger = Logger.getLogger(ExecuteSavedSearchMessageHandler.class);
    private IConfigurationService configurationService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);

    public ExecuteSavedSearchMessageHandler(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
        try {
            MAX_TITLES_AT_ONCE = TitleSearchPropertiesProvider.getInstance().getMaxTitlesFetchSize();
        }
        catch (Exception e) {
            logger.error((Object)"Error while getting titleFetchSize so using default: ", (Throwable)e);
        }
    }

    @Override
    @Transactional
    protected WorkflowMessage generateResponse(WorkflowMessage request) {
        WorkflowMessage workflowMessage = request;
        return (WorkflowMessage)ExecuteSavedSearchMessageHandler.generateResponse_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), ExecuteSavedSearchMessageHandler.class.getDeclaredMethod("generateResponse", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    private List<String> replaceQuickInfoColumnName(List<String> selectedColDisplayNames, List<ExportHelper.ColumnInfo> qcolInfo) {
        ArrayList<String> replacedNames = new ArrayList<String>();
        for (int i = 0; i < selectedColDisplayNames.size(); ++i) {
            if (selectedColDisplayNames.get(i).equals("Quick Info")) {
                for (int j = 0; j < qcolInfo.size(); ++j) {
                    replacedNames.add(qcolInfo.get(j).getDisplayName());
                }
                continue;
            }
            replacedNames.add(selectedColDisplayNames.get(i));
        }
        return replacedNames;
    }

    private List<TitleSearchResultColumn> removeThumbnail(List<TitleSearchResultColumn> displayCols) {
        ArrayList<TitleSearchResultColumn> withoutThumnail = new ArrayList<TitleSearchResultColumn>();
        for (int i = 0; i < displayCols.size(); ++i) {
            if (displayCols.get(i).getName().equals(THUMBNAIL_COLUMN)) continue;
            TitleSearchResultColumn dc = displayCols.get(i);
            TitleSearchResultColumn c = new TitleSearchResultColumn(dc.getId(), dc.getName(), dc.getOrder(), dc.getTs());
            withoutThumnail.add(c);
        }
        return withoutThumnail;
    }

    private List<String> getDisplayNamesForSelectedColumns(List<TitleSearchResultColumn> displayCols, List<ExportHelper.ColumnInfo> allDisplayColInfo) {
        ArrayList<String> selectedDisplayColNames = new ArrayList<String>();
        for (int i = 0; i < displayCols.size(); ++i) {
            for (int j = 0; j < allDisplayColInfo.size(); ++j) {
                if (!displayCols.get(i).getName().equals(allDisplayColInfo.get(j).getInternalName())) continue;
                selectedDisplayColNames.add(allDisplayColInfo.get(j).getDisplayName());
            }
        }
        return selectedDisplayColNames;
    }

    private List<ExportHelper.ColumnInfo> convertSelectedColumnToColumnInfo(List<TitleSearchResultColumn> displayCols, List<String> selectedColDisplayNames) {
        ArrayList<ExportHelper.ColumnInfo> displayColInfo = new ArrayList<ExportHelper.ColumnInfo>();
        for (int i = 0; i < displayCols.size(); ++i) {
            TitleSearchResultColumn sc = displayCols.get(i);
            displayColInfo.add(new ExportHelper.ColumnInfo(selectedColDisplayNames.get(i), sc.getName(), false));
        }
        return displayColInfo;
    }

    private boolean searchContainsQuickInfo(List<TitleSearchResultColumn> displayCols) {
        for (TitleSearchResultColumn dc : displayCols) {
            if (!dc.getName().equals(QUICK_INFO)) continue;
            return true;
        }
        return false;
    }

    private List<ExportHelper.ColumnInfo> convertColumnToColumnInfo(List<Column> columns, boolean isQuickInfoCols) {
        ArrayList<ExportHelper.ColumnInfo> infos = new ArrayList<ExportHelper.ColumnInfo>();
        for (int i = 0; i < columns.size(); ++i) {
            Column c = columns.get(i);
            String displayName = c.getColumnName();
            String assetType = "";
            String internalName = "";
            if (c.getColumnAttribute(ASSET_TYPE_IN_TABLE_COLUMN) != null) {
                assetType = c.getColumnAttribute(ASSET_TYPE_IN_TABLE_COLUMN);
                internalName = assetType + ExportHelper.ColumnInfo.INTERNAL_NAME_DELIMITER + c.getParameter();
            } else {
                internalName = c.getMethodName();
            }
            infos.add(new ExportHelper.ColumnInfo(displayName, internalName, isQuickInfoCols));
        }
        return infos;
    }

    private List<ExportHelper.ColumnInfo> replaceQuickInfoColumn(List<ExportHelper.ColumnInfo> displayCols, List<ExportHelper.ColumnInfo> qInfoCols) {
        ArrayList<ExportHelper.ColumnInfo> allColumns = new ArrayList<ExportHelper.ColumnInfo>();
        for (int i = 0; i < displayCols.size(); ++i) {
            ExportHelper.ColumnInfo c = displayCols.get(i);
            if (c.getInternalName().equals(QUICK_INFO)) {
                for (int j = 0; j < qInfoCols.size(); ++j) {
                    ExportHelper.ColumnInfo info = qInfoCols.get(j);
                    allColumns.add(new ExportHelper.ColumnInfo(info.getDisplayName(), info.getInternalName(), true));
                }
                continue;
            }
            allColumns.add(c);
        }
        return allColumns;
    }

    public List<SearchColumn> convertToSearchColumns(List<ExportHelper.ColumnInfo> selectedColumns, List<Column> allColumns) {
        ArrayList<SearchColumn> result = new ArrayList<SearchColumn>();
        for (int i = 0; i < selectedColumns.size(); ++i) {
            ExportHelper.ColumnInfo col = selectedColumns.get(i);
            String sectionType = col.isMetadataField() ? col.getSectionType() : null;
            String fieldName = col.isMetadataField() ? col.getMetadataFieldName() : col.getInternalName();
            FieldType fieldType = sectionType != null ? FieldType.ASSET : FieldType.PMM_TITLE;
            String datatype = "";
            boolean isMultiValued = false;
            if (col.isMetadataField()) {
                for (Column c : allColumns) {
                    if (c.getParameter() == null || !c.getParameter().equals(fieldName) || !c.getColumnAttribute(ASSET_TYPE_IN_TABLE_COLUMN).equals(sectionType)) continue;
                    datatype = DataTypeMappingReader.getInstance().determineDataType(fieldName);
                    List nodes = new SearchSchemaHelper().getXpathCardinality(sectionType.replace(ExportHelper.ColumnInfo.INTERNAL_NAME_DELIMITER, "/"), fieldName);
                    if (nodes.size() > 0) {
                        isMultiValued = ((XpathNodeCardinality)nodes.get(0)).getCardinality() > 1;
                    }
                    break;
                }
            } else {
                datatype = fieldName.equals(TITLE_ID) ? "integer" : "string";
            }
            SearchColumn sc = new SearchColumn(sectionType, fieldName, fieldType, datatype, isMultiValued);
            sc.setQuickInfoField(col.isQuickInfoColumn());
            result.add(sc);
        }
        return result;
    }

    private Table getTable(String tableName) {
        TableConfig configuration = TableConfig.getInstance();
        HashMap<String, String> runtimeProperties = new HashMap<String, String>();
        runtimeProperties.put("specificationName", "UI");
        File tableFile = this.configurationService.getFile(PMM_FOLDER_NAME, TABLE_CONFIG_FILE_NAME);
        return configuration.getTable(tableName, tableFile, runtimeProperties);
    }

    private static final /* synthetic */ WorkflowMessage generateResponse_aroundBody0(ExecuteSavedSearchMessageHandler this_, WorkflowMessage request) {
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{SAVED_SEARCH_ID, EXPORT_FILE_NAME});
        Integer searchId = Integer.valueOf(Util.getStringValueTrimmed((WorkflowMessage)request, (String)SAVED_SEARCH_ID));
        String resultsFileName = Util.getStringValueTrimmed((WorkflowMessage)request, (String)EXPORT_FILE_NAME);
        ITitleSearchPersistenceService tsps = (ITitleSearchPersistenceService)ServiceRegistry.getDefault().lookup(ITitleSearchPersistenceService.class);
        File output = new File(resultsFileName);
        FileOutputStream fs = null;
        OutputStreamWriter osw = null;
        try {
            List<ExportHelper.ColumnInfo> selectedDisplayColumns;
            fs = new FileOutputStream(output);
            osw = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fs), "UTF-8");
            TitleSearch ts = tsps.getTitleSearch((Serializable)searchId);
            List allDisplayColumns = this_.getTable(SEARCH_RESULTS_TABLE).getColumns();
            List<ExportHelper.ColumnInfo> allDisplayColInfo = this_.convertColumnToColumnInfo(allDisplayColumns, false);
            List<TitleSearchResultColumn> savedSearchColumns = this_.removeThumbnail(ts.getDisplayCols());
            List<String> selectedColDisplayNames = this_.getDisplayNamesForSelectedColumns(savedSearchColumns, allDisplayColInfo);
            List<ExportHelper.ColumnInfo> allSelectedDisplayCols = selectedDisplayColumns = this_.convertSelectedColumnToColumnInfo(savedSearchColumns, selectedColDisplayNames);
            if (this_.searchContainsQuickInfo(ts.getDisplayCols())) {
                List quickInfoColumns = this_.getTable(QUICK_SEARCH_TABLE).getColumns();
                List<ExportHelper.ColumnInfo> qColInfo = this_.convertColumnToColumnInfo(quickInfoColumns, true);
                allSelectedDisplayCols = this_.replaceQuickInfoColumn(selectedDisplayColumns, qColInfo);
                allDisplayColInfo = this_.replaceQuickInfoColumn(allDisplayColInfo, qColInfo);
                selectedColDisplayNames = this_.replaceQuickInfoColumnName(selectedColDisplayNames, qColInfo);
            }
            String header = new ExportHelper().buildHeader(allSelectedDisplayCols);
            osw.write(header);
            osw.write(System.getProperty("line.separator"));
            List partnerIds = SearchPartnerProvider.getParnterIds((String)ts.getUserName());
            ITitleSearchService searchService = (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);
            List<SearchColumn> scs = this_.convertToSearchColumns(allSelectedDisplayCols, allDisplayColumns);
            ts.getFilter().setPageInfo(new PagingInfo(0, 0));
            ScrollableResults sr = searchService.getTitleScrollable(ts.getFilter(), partnerIds, scs, MAX_TITLES_AT_ONCE);
            String rowStr = new ExportHelper().scrollHelper(selectedColDisplayNames, scs, sr);
            osw.write(rowStr);
            WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)request);
            response.putValue(SUCCESS, "true");
            WorkflowMessage workflowMessage = response;
            return workflowMessage;
        }
        catch (TitleSearchNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (UnathorizedUserException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (osw != null) {
                try {
                    osw.flush();
                    osw.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static final /* synthetic */ Object generateResponse_aroundBody1$advice(ExecuteSavedSearchMessageHandler this_, WorkflowMessage request, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ExecuteSavedSearchMessageHandler.generateResponse_aroundBody0(this_, request);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            WorkflowMessage object = ExecuteSavedSearchMessageHandler.generateResponse_aroundBody0(this_, request);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }
}

