/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.action;

import com.ericsson.cms.devices.content.ContentMessageDispatcher;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import java.io.File;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;
import org.w3c.dom.Document;

public class GetTitleMetadataMessageDispatcher
extends ContentMessageDispatcher {
    private static final String TITLE_ID = "titleId";
    private static final String FILE_PATH = "outputFilePath";
    private static final String SPECIFICATION = "specification";
    private static final String IS_CURRENT_VERSION = "isCurrentVersion";
    private static final String VERSION = "version";

    public GetTitleMetadataMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    @Transactional
    protected WorkflowMessage generateResponse(WorkflowMessage request) {
        WorkflowMessage workflowMessage = request;
        return (WorkflowMessage)GetTitleMetadataMessageDispatcher.generateResponse_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), GetTitleMetadataMessageDispatcher.class.getDeclaredMethod("generateResponse", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    @Override
    protected Title getTitle(long titleId) {
        Title title = super.getTitle(titleId);
        if (title.getStatus().equals((Object)TitleStatus.DRAFT)) {
            int revisionNumber = title.getAsset().getLatestRevisionNumber() - 1;
            if (revisionNumber <= 0) {
                String message = "Metadata for title[" + titleId + "] has never been committed, cannot get metadata.";
                throw new RuntimeException(message);
            }
            String version = Integer.toString(revisionNumber);
            try {
                title = this.getTitleManager().get(Long.valueOf(titleId), version);
            }
            catch (TitlePersistenceException e) {
                throw new RuntimeException("Failed to get last committed version(" + version + ") of title[" + titleId + "], error: " + e.getLocalizedMessage(), e);
            }
        }
        return title;
    }

    private Document getDocumentBySpecification(String specificationAlias, Title title) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ISpecificationManager manager = (ISpecificationManager)registry.lookup(ISpecificationManager.class);
        Specification specification = manager.getSpecificationByAlias(specificationAlias);
        if (specification == null) {
            String message = "The specification[" + specificationAlias + "] does not exist.";
            throw new RuntimeException(message);
        }
        return this.getTitleManager().getDocument(title, specification);
    }

    private static final /* synthetic */ WorkflowMessage generateResponse_aroundBody0(GetTitleMetadataMessageDispatcher this_, WorkflowMessage request) {
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{TITLE_ID, FILE_PATH, SPECIFICATION});
        long titleId = Util.getLongValue((WorkflowMessage)request, (String)TITLE_ID);
        String specification = Util.getStringValueTrimmed((WorkflowMessage)request, (String)SPECIFICATION);
        String outputFilePath = Util.getStringValueTrimmed((WorkflowMessage)request, (String)FILE_PATH);
        Title title = this_.getTitle(titleId);
        Document document = this_.getDocumentBySpecification(specification, title);
        this_.saveXMLDocument(document, new File(outputFilePath));
        WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)request);
        String version = title.getVersion();
        boolean isCurrentVersion = !title.getStatus().equals((Object)TitleStatus.DRAFT);
        response.putValue(VERSION, this_.getOutputValue(version));
        response.putValue(IS_CURRENT_VERSION, this_.getOutputValue(isCurrentVersion));
        return response;
    }

    private static final /* synthetic */ Object generateResponse_aroundBody1$advice(GetTitleMetadataMessageDispatcher this_, WorkflowMessage request, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return GetTitleMetadataMessageDispatcher.generateResponse_aroundBody0(this_, request);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            WorkflowMessage object = GetTitleMetadataMessageDispatcher.generateResponse_aroundBody0(this_, request);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }
}

