/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.action;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.devices.content.ContentMessageDispatcher;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class SearchMessageDispatcher
extends ContentMessageDispatcher {
    private static String FIELD_1_XPATH = "field1Xpath";
    private static String FIELD_1_ASSET_TYPE = "field1AssetType";
    private static String FIELD_1_VALUE = "field1Value";
    private static String FIELD_2_XPATH = "field2Xpath";
    private static String FIELD_2_ASSET_TYPE = "field2AssetType";
    private static String FIELD_2_VALUE = "field2Value";
    private static String FIELD_3_XPATH = "field3Xpath";
    private static String FIELD_3_ASSET_TYPE = "field3AssetType";
    private static String FIELD_3_VALUE = "field3Value";
    private static String FIELD_4_XPATH = "field4Xpath";
    private static String FIELD_4_ASSET_TYPE = "field4AssetType";
    private static String FIELD_4_VALUE = "field4Value";
    private static String FIELD_5_XPATH = "field5Xpath";
    private static String FIELD_5_ASSET_TYPE = "field5AssetType";
    private static String FIELD_5_VALUE = "field5Value";
    private static String MATCHING_TITLE_IDS = "titleIds";
    private static String MATCHING_TITLE_IDS_COUNT = "matchingTitleCount";

    public SearchMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    @Transactional
    protected WorkflowMessage generateResponse(WorkflowMessage message) {
        WorkflowMessage workflowMessage = message;
        return (WorkflowMessage)SearchMessageDispatcher.generateResponse_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), SearchMessageDispatcher.class.getDeclaredMethod("generateResponse", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    private WorkflowMessage buildResponse(WorkflowMessage message, List<Long> titleIds) {
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        StringBuffer sb = new StringBuffer();
        int matchingTitleCount = 0;
        for (long id : titleIds) {
            ++matchingTitleCount;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(id);
        }
        response.putValue(MATCHING_TITLE_IDS, sb.toString());
        response.putValue(MATCHING_TITLE_IDS_COUNT, String.valueOf(matchingTitleCount));
        return response;
    }

    private ExpNode buildSearchFields(WorkflowMessage message) {
        String field5Value;
        String field5AssetType;
        String field5EcmfXPath;
        ExpValue field5;
        String field5Xpath;
        String field4Value;
        String field4AssetType;
        String field4EcmfXPath;
        ExpValue field4;
        String field4Xpath;
        String field3Value;
        String field3AssetType;
        String field3EcmfXPath;
        ExpValue field3;
        String field3Xpath;
        String field2Value;
        String field2AssetType;
        String field2EcmfXPath;
        ExpValue field2;
        String field2Xpath;
        String field1Value;
        String field1AssetType;
        String field1EcmfXPath;
        ExpValue field1;
        ExpList searchFields = new ExpList();
        String field1Xpath = this.getMessageParameter(message, FIELD_1_XPATH);
        if (field1Xpath != null && !field1Xpath.isEmpty() && (field1 = this.getSearchField(field1EcmfXPath = this.getXPath(field1Xpath), field1AssetType = this.getMessageParameter(message, FIELD_1_ASSET_TYPE), field1Value = this.getMessageParameter(message, FIELD_1_VALUE))) != null) {
            searchFields.addItem((ExpNode)field1);
        }
        if ((field2Xpath = this.getMessageParameter(message, FIELD_2_XPATH)) != null && !field2Xpath.isEmpty() && (field2 = this.getSearchField(field2EcmfXPath = this.getXPath(field2Xpath), field2AssetType = this.getMessageParameter(message, FIELD_2_ASSET_TYPE), field2Value = this.getMessageParameter(message, FIELD_2_VALUE))) != null) {
            searchFields.addItem((ExpNode)field2);
        }
        if ((field3Xpath = this.getMessageParameter(message, FIELD_3_XPATH)) != null && !field3Xpath.isEmpty() && (field3 = this.getSearchField(field3EcmfXPath = this.getXPath(field3Xpath), field3AssetType = this.getMessageParameter(message, FIELD_3_ASSET_TYPE), field3Value = this.getMessageParameter(message, FIELD_3_VALUE))) != null) {
            searchFields.addItem((ExpNode)field3);
        }
        if ((field4Xpath = this.getMessageParameter(message, FIELD_4_XPATH)) != null && !field4Xpath.isEmpty() && (field4 = this.getSearchField(field4EcmfXPath = this.getXPath(field4Xpath), field4AssetType = this.getMessageParameter(message, FIELD_4_ASSET_TYPE), field4Value = this.getMessageParameter(message, FIELD_4_VALUE))) != null) {
            searchFields.addItem((ExpNode)field4);
        }
        if ((field5Xpath = this.getMessageParameter(message, FIELD_5_XPATH)) != null && !field5Xpath.isEmpty() && (field5 = this.getSearchField(field5EcmfXPath = this.getXPath(field5Xpath), field5AssetType = this.getMessageParameter(message, FIELD_5_ASSET_TYPE), field5Value = this.getMessageParameter(message, FIELD_5_VALUE))) != null) {
            searchFields.addItem((ExpNode)field5);
        }
        return searchFields;
    }

    private ExpValue getSearchField(String fieldXpath, String fieldAssetType, String value) {
        if (fieldXpath == null || fieldXpath.trim().isEmpty()) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        PredicateRightValue prv = new PredicateRightValue(fieldXpath, fieldAssetType, FieldType.ASSET, values, LogicalOperator.EQUAL, Boolean.valueOf(false));
        return new ExpValue((Predicate)prv);
    }

    protected String getXPath(String field) {
        return this.getMetadataService().translateXPath(field);
    }

    private String getMessageParameter(WorkflowMessage message, String name) {
        return (String)message.getPayload().getParameterValue(name);
    }

    private static final /* synthetic */ WorkflowMessage generateResponse_aroundBody0(SearchMessageDispatcher this_, WorkflowMessage message) {
        try {
            Util.validateRequired((WorkflowMessage)message, (String[])new String[]{FIELD_1_XPATH, FIELD_1_ASSET_TYPE, FIELD_1_VALUE});
        }
        catch (Exception e) {
            throw new RuntimeException("At least 1 search field must be provided.");
        }
        ExpNode searchFields = this_.buildSearchFields(message);
        ITitleSearchService service = (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);
        ArrayList<Long> titleIds = new ArrayList();
        try {
            titleIds = service.getTitleIds(searchFields);
        }
        catch (Exception e) {
            String msg = "Failed to search for titles: " + e.getMessage();
            throw new RuntimeException(msg, e);
        }
        return this_.buildResponse(message, titleIds);
    }

    private static final /* synthetic */ Object generateResponse_aroundBody1$advice(SearchMessageDispatcher this_, WorkflowMessage message, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SearchMessageDispatcher.generateResponse_aroundBody0(this_, message);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            WorkflowMessage object = SearchMessageDispatcher.generateResponse_aroundBody0(this_, message);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }
}

