/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.communication;

import com.ericsson.cms.devices.content.communication.CMDeprecatedDispatcher;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListAssetMap;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListElementMetadata;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListManager;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.util.Binder;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.communication.config.MessageHandlerException;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.aspectj.runtime.internal.AroundClosure;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
public class GenerateMetadataMessageHandler
extends CMDeprecatedDispatcher {
    private static final String RESULT = "result";
    private static final String SUCCESS = "SUCCESS";
    private static final String OUTPUT_METADATA_FILE_PATH = "outputMetadataFilePath";
    private static final String SPEC = "spec";
    private static final String TITLE_ID = "titleId";
    private static final String FIELDS_VOD_PLAYLIST_ID = "/Fields/VodPlaylistId";
    static final String ASSETLIST_MANAGER_SERVICE = "cms/AssetListManager/local";
    private static final String PROVIDER_ID_XPATH = "/Fields/ProviderInfo/Identifier/Id";
    private static final String ASSET_ID_XPATH = "/Fields/Identifier/Id";

    public GenerateMetadataMessageHandler(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination, "01CM23", "Get Title Metadata");
    }

    @Override
    @Transactional
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        WorkflowMessage workflowMessage = message;
        return (WorkflowMessage)GenerateMetadataMessageHandler.handleMessage_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), GenerateMetadataMessageHandler.class.getDeclaredMethod("handleMessage", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    private ISpecHandler getSpecificationByAlias(String alias) {
        return SpecHandlerFactory.getInstance((String)alias);
    }

    private IAssetListManager getAssetListManagerService() {
        IAssetListManager service = null;
        try {
            service = (IAssetListManager)InitialContext.doLookup(ASSETLIST_MANAGER_SERVICE);
        }
        catch (NamingException e) {
            String msg = "Failed to lookup the Asset List Manager service(cms/AssetListManager/local).";
            throw new RuntimeException(msg);
        }
        return service;
    }

    private static final /* synthetic */ WorkflowMessage handleMessage_aroundBody0(GenerateMetadataMessageHandler this_, WorkflowMessage message) {
        Util.validateRequired((WorkflowMessage)message, (String[])new String[]{TITLE_ID, SPEC, OUTPUT_METADATA_FILE_PATH});
        Long titleId = Util.getLongValue((WorkflowMessage)message, (String)TITLE_ID);
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ITitleManager service = (ITitleManager)registry.lookup(ITitleManager.class);
        Title title = null;
        try {
            title = service.get(titleId);
        }
        catch (Exception e) {
            String msg = "Failed to read the Title from the persistence service, error: " + e.getMessage();
            throw new MessageHandlerException("ERR-003", msg, (Throwable)e);
        }
        if (title == null) {
            String msg = "Did not get a Title from the persistence service.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        String spec = Util.getStringValueTrimmed((WorkflowMessage)message, (String)SPEC);
        ISpecHandler specHandler = this_.getSpecificationByAlias(spec);
        if (specHandler == null) {
            String msg = "Could not find specification with matching alias: " + spec;
            throw new MessageHandlerException("ERR-003", msg);
        }
        Asset root = title.getAsset();
        List assets = root.getAllAssets(false);
        boolean hasTitleList = false;
        for (Asset asset : assets) {
            Field field = asset.getFirstField(FIELDS_VOD_PLAYLIST_ID);
            if (field == null) continue;
            try {
                Long.parseLong(field.getValue());
            }
            catch (NumberFormatException nfe) {
                continue;
            }
            hasTitleList = true;
            break;
        }
        String outputMetadataFilePath = Util.getStringValueTrimmed((WorkflowMessage)message, (String)OUTPUT_METADATA_FILE_PATH);
        if (title.getStatus().equals((Object)TitleStatus.DRAFT)) {
            String msg;
            try {
                int revision = title.getAsset().getLatestRevisionNumber() - 1;
                if (revision <= 0) {
                    msg = "Title metadata has yet to be committed.";
                    throw new MessageHandlerException("ERR-003", msg);
                }
                title = service.get(titleId, Integer.toString(revision));
            }
            catch (TitlePersistenceException tpe) {
                msg = "Title metadata has yet to be committed.";
                throw new MessageHandlerException("ERR-003", msg);
            }
        }
        Document doc = null;
        if (spec.equals("OpenStreamVOD") && hasTitleList) {
            doc = specHandler.convertAssetToXMLDocument(title.getAsset());
            ArrayList<String> titleListIds = new ArrayList<String>();
            for (Asset asset : assets) {
                Field field = asset.getFirstField(FIELDS_VOD_PLAYLIST_ID);
                if (field == null) continue;
                titleListIds.add(field.getValue());
            }
            ArrayList<AssetList> assetLists = new ArrayList<AssetList>();
            for (String idStr : titleListIds) {
                long id = 0L;
                try {
                    id = Long.parseLong(idStr);
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
                assetLists.add(this_.getAssetListManagerService().get(id));
            }
            XPathFactory xfactory = XPathFactory.newInstance();
            XPath xpath = xfactory.newXPath();
            NodeList segmentNodes = null;
            try {
                XPathExpression expr = xpath.compile("//ADI/Asset/Asset/Metadata/App_Data[@Name='Segment']");
                segmentNodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException("It was not possible to retrieve the document for the title " + titleId + " given the specification " + outputMetadataFilePath + ".");
            }
            for (int i = 0; i < segmentNodes.getLength(); ++i) {
                Node appDataNode = segmentNodes.item(i);
                String idStr = appDataNode.getAttributes().getNamedItem("Value").getTextContent();
                String appStr = appDataNode.getAttributes().getNamedItem("App").getTextContent();
                Node parent = appDataNode.getParentNode();
                parent.removeChild(appDataNode);
                long id = Long.parseLong(idStr);
                AssetList list = null;
                for (AssetList al : assetLists) {
                    if (id != al.getId()) continue;
                    list = al;
                }
                if (list == null) continue;
                int position = 1;
                List listAssets = list.getAssetsMap();
                for (AssetListAssetMap alam : listAssets) {
                    AssetListElementMetadata contentRestricted;
                    AssetListElementMetadata rollsRestricted;
                    AssetListElementMetadata segmentName;
                    AssetListElementMetadata displayRestricted;
                    AssetListElementMetadata trickModeRestricted;
                    AssetListElementMetadata usage;
                    AssetListElementMetadata endNpt;
                    Element newAppData = doc.createElement("App_Data");
                    newAppData.setAttribute("App", appStr);
                    newAppData.setAttribute("Name", "Segment");
                    newAppData.setAttribute("Value", "Patience");
                    parent.appendChild(newAppData);
                    long assetId = alam.getAssetId();
                    Asset asset = alam.getTitle().getAsset(assetId);
                    String assetType = asset.getAssetType();
                    ArrayList<String> assetTypeList = new ArrayList<String>();
                    assetTypeList.add(assetType);
                    List providerIdList = asset.getAllFieldsForXpath(assetTypeList, PROVIDER_ID_XPATH);
                    if (providerIdList == null || providerIdList.size() == 0) {
                        throw new Exception("Provider ID metadata field not present for asset:" + assetId);
                    }
                    String providerIdValue = ((Field)providerIdList.get(0)).getValue();
                    List assetIdList = asset.getAllFieldsForXpath(assetTypeList, ASSET_ID_XPATH);
                    if (assetIdList == null || assetIdList.size() == 0) {
                        throw new Exception("Asset ID metadata field not present for asset:" + assetId);
                    }
                    String assetIdValue = ((Field)assetIdList.get(0)).getValue();
                    Element segment = doc.createElement("segment");
                    segment.setAttribute("segmentID", alam.getId() + "");
                    segment.setAttribute("providerID", providerIdValue);
                    segment.setAttribute("assetID", assetIdValue);
                    segment.setAttribute("position", Integer.toString(position));
                    ++position;
                    AssetListElementMetadata startNpt = alam.getAssetListElementMetadata("startNPT");
                    if (startNpt != null && startNpt.getIntegerValue() != null) {
                        segment.setAttribute("startNPT", startNpt.getIntegerValue() + "");
                    }
                    if ((endNpt = alam.getAssetListElementMetadata("endNPT")) != null && endNpt.getIntegerValue() != null) {
                        segment.setAttribute("endNPT", endNpt.getIntegerValue() + "");
                    }
                    if ((usage = alam.getAssetListElementMetadata("usage")) != null && usage.getStringValue() != null && !usage.getStringValue().equals("")) {
                        segment.setAttribute("usage", usage.getStringValue());
                    }
                    if ((trickModeRestricted = alam.getAssetListElementMetadata("trickModeRestricted")) != null && trickModeRestricted.getStringValue() != null && !trickModeRestricted.getStringValue().equals("")) {
                        segment.setAttribute("trickModeRestricted", trickModeRestricted.getStringValue());
                    }
                    if ((displayRestricted = alam.getAssetListElementMetadata("displayRestricted")) != null && displayRestricted.getStringValue() != null && !displayRestricted.getStringValue().equals("")) {
                        segment.setAttribute("displayRestricted", displayRestricted.getStringValue());
                    }
                    if ((segmentName = alam.getAssetListElementMetadata("segmentName")) != null && segmentName.getStringValue() != null && !segmentName.getStringValue().equals("")) {
                        segment.setAttribute("segmentName", segmentName.getStringValue());
                    }
                    if ((rollsRestricted = alam.getAssetListElementMetadata("rollsRestricted")) != null && rollsRestricted.getStringValue() != null && !rollsRestricted.getStringValue().equals("")) {
                        segment.setAttribute("rollsRestricted", rollsRestricted.getStringValue());
                    }
                    if ((contentRestricted = alam.getAssetListElementMetadata("contentRestricted")) != null && contentRestricted.getStringValue() != null && !contentRestricted.getStringValue().equals("")) {
                        segment.setAttribute("contentRestricted", contentRestricted.getStringValue());
                    }
                    StringWriter buffer = new StringWriter();
                    try {
                        TransformerFactory transFactory = TransformerFactory.newInstance();
                        Transformer transformer = transFactory.newTransformer();
                        transformer.setOutputProperty("omit-xml-declaration", "yes");
                        transformer.transform(new DOMSource(segment), new StreamResult(buffer));
                    }
                    catch (TransformerConfigurationException e) {
                        throw new RuntimeException("It was not possible to retrieve the document for the title " + titleId + " given the specification " + outputMetadataFilePath + ".");
                    }
                    catch (TransformerException e) {
                        throw new RuntimeException("It was not possible to retrieve the document for the title " + titleId + " given the specification " + outputMetadataFilePath + ".");
                    }
                    String str = buffer.toString();
                    newAppData.setAttribute("Value", str);
                }
            }
        } else {
            doc = spec.trim().equalsIgnoreCase("ttv") ? new Binder().bind(title.getAsset()) : specHandler.convertAssetToXMLDocument(title.getAsset());
        }
        File outputFile = new File(outputMetadataFilePath);
        this_.saveXMLDocument(doc, outputFile);
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        response.putValue(RESULT, SUCCESS);
        return response;
    }

    private static final /* synthetic */ Object handleMessage_aroundBody1$advice(GenerateMetadataMessageHandler this_, WorkflowMessage message, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return GenerateMetadataMessageHandler.handleMessage_aroundBody0(this_, message);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            WorkflowMessage object = GenerateMetadataMessageHandler.handleMessage_aroundBody0(this_, message);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }
}

