/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.custom;

import com.ericsson.cms.devices.content.ContentMessageDispatcher;
import com.ericsson.cms.devices.content.custom.DateUtils;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.hibernate.SQLQuery;
import org.hibernate.Session;

public class GetSumOfDurationByProviderIdAndDateMessageDispatcher
extends ContentMessageDispatcher {
    private static final String PROVIDER_ID_PARAM = "providerId";
    private static final String START_DATE_PARAM = "startDate";
    private static final String END_DATE_PARAM = "endDate";
    private static final String TOTAL_DURATION_VARIABLE = "totalDurationInSeconds";
    private String queryStr;
    private String queryStrWithNoEndDate;

    public GetSumOfDurationByProviderIdAndDateMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
        this.queryStr = conf.getParameterValue("SQL_QUERY");
        this.queryStrWithNoEndDate = conf.getParameterValue("SQL_QUERY_NO_ENDDATE");
    }

    @Override
    protected WorkflowMessage generateResponse(WorkflowMessage request) {
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{PROVIDER_ID_PARAM, START_DATE_PARAM});
        String providerId = Util.getStringValueTrimmed((WorkflowMessage)request, (String)PROVIDER_ID_PARAM);
        String startDateValue = Util.getStringValueTrimmed((WorkflowMessage)request, (String)START_DATE_PARAM);
        String endDateValue = Util.getStringValueTrimmed((WorkflowMessage)request, (String)END_DATE_PARAM);
        Date startDate = DateUtils.validateAndGetDate(START_DATE_PARAM, startDateValue);
        Date endDate = null;
        if (endDateValue != null) {
            endDate = DateUtils.validateAndGetDate(END_DATE_PARAM, endDateValue);
            DateUtils.validateDateRange(startDate, endDate);
        }
        String totalDuration = this.getSumOfDuration(providerId, startDate, endDate);
        WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)request);
        response.putValue(TOTAL_DURATION_VARIABLE, totalDuration);
        return response;
    }

    public String getSumOfDuration(String providerId, Date startDate, Date endDate) {
        BigDecimal val;
        Session session = HibernateContext.getContext().openSession();
        if (endDate == null) {
            this.queryStr = this.queryStrWithNoEndDate;
        }
        SQLQuery query = session.createSQLQuery(this.queryStr);
        query.setString(PROVIDER_ID_PARAM, providerId);
        query.setDate(START_DATE_PARAM, startDate);
        if (endDate != null) {
            query.setDate(END_DATE_PARAM, endDate);
        }
        String totalDuration = "";
        List values = query.list();
        if (values.size() > 0 && (val = (BigDecimal)values.get(0)) != null) {
            totalDuration = val.toString();
        }
        session.close();
        return totalDuration;
    }
}

