/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.file;

import com.ericsson.cms.devices.content.file.AbstractSetFilePropertiesMessageDispatcher;
import com.ericsson.cms.devices.content.file.FileFieldNames;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.HashSet;
import java.util.Set;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class RegisterDerivedFileMessageDispatcher
extends AbstractSetFilePropertiesMessageDispatcher {
    private static final String TITLE_ID = "titleId";
    private static final String FILE_URI = "fileURI";
    private static final String ORIGINAL_FILE_ID = "originalFileId";
    private static final String DERIVED_FILE_ID = "derivedFileId";
    private static final String RESULT = "result";
    private static final String SUCCESS = "SUCCESS";
    private Set<Long> fileAssetIds = null;

    public RegisterDerivedFileMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected void validateRequiredParameters(WorkflowMessage request) {
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{TITLE_ID, FILE_URI, ORIGINAL_FILE_ID});
    }

    @Override
    protected long getTitleId(WorkflowMessage request) {
        return Util.getLongValue((WorkflowMessage)request, (String)TITLE_ID);
    }

    @Override
    protected File getFile(WorkflowMessage request, Title title) {
        long parentFileAssetId = Util.getLongValue((WorkflowMessage)request, (String)ORIGINAL_FILE_ID);
        String fileURI = Util.getStringValueTrimmed((WorkflowMessage)request, (String)FILE_URI);
        File parentFile = this.getFileAsset(title, parentFileAssetId);
        File derivedFile = this.getTitleManager().createDerivedFile();
        this.setField(derivedFile, FileFieldNames.FILE_URI_XPATH, fileURI);
        String fileSize = Util.getStringValueTrimmed((WorkflowMessage)request, (String)"fileSize");
        if (fileSize == null) {
            fileSize = this.getFileSize(fileURI);
            this.setField(derivedFile, FileFieldNames.FILE_SIZE_XPATH, fileSize);
        }
        this.fileAssetIds = this.getFileAssetIds(title);
        title.addFile((Asset)parentFile, derivedFile);
        return derivedFile;
    }

    @Override
    protected void updateResponseParameters(WorkflowMessage response, WorkflowMessage request, Title title, File file, ISavedTitle savedTitle) {
        Set<Long> newFileAssetIds = this.getFileAssetIds(savedTitle.getTitle());
        newFileAssetIds.removeAll(this.fileAssetIds);
        if (newFileAssetIds.size() != 1) {
            String msg = "Failed to determine the new derived file asset ID in title[" + savedTitle.getTitle().getId() + "].";
            throw new RuntimeException(msg);
        }
        long derivedFileId = newFileAssetIds.iterator().next();
        response.putValue(DERIVED_FILE_ID, Long.toString(derivedFileId));
        response.putValue(RESULT, SUCCESS);
    }

    private Set<Long> getFileAssetIds(Title title) {
        HashSet<Long> fileAssetIds = new HashSet<Long>();
        for (File file : title.getAllFiles()) {
            fileAssetIds.add(file.getId());
        }
        return fileAssetIds;
    }

    @Override
    @Transactional
    public WorkflowMessage generateResponse(WorkflowMessage request) {
        WorkflowMessage workflowMessage = request;
        return (WorkflowMessage)RegisterDerivedFileMessageDispatcher.generateResponse_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), RegisterDerivedFileMessageDispatcher.class.getDeclaredMethod("generateResponse", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ WorkflowMessage generateResponse_aroundBody0(RegisterDerivedFileMessageDispatcher this_, WorkflowMessage request) {
        this_.fileAssetIds = null;
        try {
            WorkflowMessage workflowMessage = super.generateResponse(request);
            return workflowMessage;
        }
        finally {
            this_.fileAssetIds = null;
        }
    }

    private static final /* synthetic */ Object generateResponse_aroundBody1$advice(RegisterDerivedFileMessageDispatcher this_, WorkflowMessage request, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return RegisterDerivedFileMessageDispatcher.generateResponse_aroundBody0(this_, request);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            WorkflowMessage object = RegisterDerivedFileMessageDispatcher.generateResponse_aroundBody0(this_, request);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }
}

