/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.ingest;

import com.ericsson.cms.devices.content.ingest.TitleIngestMessageDispatcher;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.ingest.FileMapResult;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestResult;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public abstract class AbstractIngestMessageDispatcher
extends TitleIngestMessageDispatcher {
    protected static final String CONTENT_CLASS_NAME = "contentClassName";
    protected static final String PLANNER_ID = "plannerId";
    protected static final String METADATA_ASSET_ID = "metadataAssetId";
    protected static final String METADATA_FILE_ID = "metadataFileId";
    protected static final String CONTENT_ASSET_ID = "assetId";
    protected static final String CONTENT_FILE_ID = "fileId";
    protected static final String CONTENT_ASSET_TYPE = "assetType";
    protected static final String CONTENT_ASSET_MAPPING_COUNT = "contentAssetMappingCount";
    protected static final String CONTENT_ASSET_IDS = "contentAssetIds";
    protected static final String UNMAPPED_FILE_COUNT = "unmappedFileCount";
    protected static final String UNMAPPED_FILE_PATHS = "unmappedFilePaths";
    protected static final String VALIDATION_STATUS = "validationStatus";
    protected boolean writeTitleId = false;
    protected boolean writePlannerId = false;

    public AbstractIngestMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    @Transactional
    protected WorkflowMessage generateResponse(WorkflowMessage request) {
        WorkflowMessage workflowMessage = request;
        return (WorkflowMessage)AbstractIngestMessageDispatcher.generateResponse_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), AbstractIngestMessageDispatcher.class.getDeclaredMethod("generateResponse", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    protected abstract void validateRequiredParameters(WorkflowMessage var1);

    protected abstract TitleIngestResult performIngest(WorkflowMessage var1);

    protected void updateResponseParameters(WorkflowMessage response, WorkflowMessage request, TitleIngestResult result) {
        if (this.writeTitleId) {
            response.putValue("titleId", this.getTitleId(result));
        }
        if (this.writePlannerId) {
            response.putValue(PLANNER_ID, this.getPlannerId(result));
        }
        response.putValue(VALIDATION_STATUS, this.getValidationStatus(result));
    }

    protected String getTitleId(TitleIngestResult result) {
        return this.getOutputValue(result.getSavedTitle().getTitle().getId());
    }

    protected String getPlannerId(TitleIngestResult result) {
        return this.getOutputValue(result.getPlannerId());
    }

    protected String getValidationStatus(TitleIngestResult result) {
        Title title = result.getSavedTitle().getTitle();
        boolean valid = !title.getStatus().equals((Object)TitleStatus.DRAFT);
        return Boolean.toString(valid);
    }

    protected FileMapResult getMetadataFileMapping(TitleIngestResult result) {
        Map mappings = result.getMappings();
        if (mappings != null) {
            for (FileMapResult mapResult : mappings.values()) {
                if (!mapResult.isMetadata()) continue;
                return mapResult;
            }
        }
        return null;
    }

    protected Collection<FileMapResult> getMappedContentFileMappings(TitleIngestResult result) {
        return this.getContentFileMappings(result, true, false);
    }

    protected Collection<FileMapResult> getUnmappedContentFileMappings(TitleIngestResult result) {
        return this.getContentFileMappings(result, false, true);
    }

    protected Collection<FileMapResult> getAllContentFileMappings(TitleIngestResult result) {
        return this.getContentFileMappings(result, true, true);
    }

    private Collection<FileMapResult> getContentFileMappings(TitleIngestResult result, boolean includeMapped, boolean includeUnmapped) {
        ArrayList<FileMapResult> contentFileMappings = new ArrayList<FileMapResult>();
        Map mappings = result.getMappings();
        if (mappings != null) {
            for (FileMapResult mapResult : mappings.values()) {
                if (mapResult.isMetadata()) continue;
                boolean mapped = mapResult.isMapped();
                if ((!includeMapped || !mapped) && (!includeUnmapped || mapped)) continue;
                contentFileMappings.add(mapResult);
            }
        }
        return contentFileMappings;
    }

    protected String getParentAssetId(FileMapResult mapping) {
        Long assetId = mapping.getParentAsset() != null ? Long.valueOf(mapping.getParentAsset().getId()) : null;
        return this.getOutputValue(assetId);
    }

    protected String getParentAssetType(FileMapResult mapping) {
        Asset asset = mapping.getParentAsset();
        String assetType = asset != null ? asset.getType() : null;
        return this.getOutputValue(assetType);
    }

    protected String getFileAssetId(FileMapResult mapping) {
        Long fileAssetId = mapping.getFile() != null ? Long.valueOf(mapping.getFile().getId()) : null;
        return this.getOutputValue(fileAssetId);
    }

    protected String getAssetIds(Collection<FileMapResult> fileMapResults) {
        ArrayList<Long> assetIds = new ArrayList<Long>();
        for (FileMapResult fileMapResult : fileMapResults) {
            if (fileMapResult.getParentAsset() == null) continue;
            assetIds.add(fileMapResult.getParentAsset().getId());
        }
        return this.getCSVString(assetIds);
    }

    protected String getFilePaths(Collection<FileMapResult> fileMapResults) {
        ArrayList<String> filePaths = new ArrayList<String>();
        for (FileMapResult fileMapResult : fileMapResults) {
            if (fileMapResult.getPath() == null) continue;
            filePaths.add(fileMapResult.getPath());
        }
        return this.getCSVString(filePaths);
    }

    private static final /* synthetic */ WorkflowMessage generateResponse_aroundBody0(AbstractIngestMessageDispatcher this_, WorkflowMessage request) {
        this_.validateRequiredParameters(request);
        TitleIngestResult ingestResult = this_.performIngest(request);
        WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)request);
        this_.updateResponseParameters(response, request, ingestResult);
        return response;
    }

    private static final /* synthetic */ Object generateResponse_aroundBody1$advice(AbstractIngestMessageDispatcher this_, WorkflowMessage request, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return AbstractIngestMessageDispatcher.generateResponse_aroundBody0(this_, request);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            WorkflowMessage object = AbstractIngestMessageDispatcher.generateResponse_aroundBody0(this_, request);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }
}

