/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.ingest;

import com.ericsson.cms.devices.content.ingest.AbstractMetadataIngestMessageDispatcher;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestException;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestResult;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.WorkflowMessage;

public class CreateTitleForMetadataMessageDispatcher
extends AbstractMetadataIngestMessageDispatcher {
    public CreateTitleForMetadataMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
        this.writeTitleId = true;
        this.writePlannerId = false;
    }

    @Override
    protected void validateRequiredParameters(WorkflowMessage request) {
        super.validateRequiredParameters(request);
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{"providerId"});
    }

    @Override
    protected TitleIngestResult performIngest(WorkflowMessage request) {
        String metadataPath = Util.getStringValueTrimmed((WorkflowMessage)request, (String)"metadataPath");
        String providerId = Util.getStringValueTrimmed((WorkflowMessage)request, (String)"providerId");
        String contentClassName = Util.getStringValueTrimmed((WorkflowMessage)request, (String)"contentClassName");
        TitleIngestResult result = null;
        try {
            result = this.getIngestService().createTitleForMetadata(metadataPath, providerId, contentClassName, this.getActionSource(request));
        }
        catch (TitleIngestException e) {
            String msg = "Failed to create title for metadata: " + metadataPath + ", error: " + e.getLocalizedMessage();
            throw new RuntimeException(msg, e);
        }
        return result;
    }
}

