/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.ingest;

import com.ericsson.cms.devices.content.ingest.TitleIngestMessageDispatcher;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestException;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class GetContentAssetsForTitleMessageDispatcher
extends TitleIngestMessageDispatcher {
    private static final String CONTENT_ASSET_COUNT = "contentAssetCount";
    private static final String CONTENT_ASSET_ID_LIST = "contentAssetIdList";

    public GetContentAssetsForTitleMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    @Transactional
    protected WorkflowMessage generateResponse(WorkflowMessage request) {
        WorkflowMessage workflowMessage = request;
        return (WorkflowMessage)GetContentAssetsForTitleMessageDispatcher.generateResponse_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), GetContentAssetsForTitleMessageDispatcher.class.getDeclaredMethod("generateResponse", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    private static final /* synthetic */ WorkflowMessage generateResponse_aroundBody0(GetContentAssetsForTitleMessageDispatcher this_, WorkflowMessage request) {
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{"titleId"});
        Long titleId = Util.getLongValue((WorkflowMessage)request, (String)"titleId");
        List assetList = null;
        try {
            assetList = this_.getIngestService().getContentAssets(titleId);
        }
        catch (TitleIngestException e) {
            String msg = "Failed to get the content assets for title[" + titleId + "], error: " + e.getLocalizedMessage();
            throw new RuntimeException(msg, e);
        }
        ArrayList<Long> assetIds = new ArrayList<Long>();
        for (Asset asset : assetList) {
            assetIds.add(asset.getId());
        }
        WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)request);
        response.putValue(CONTENT_ASSET_ID_LIST, this_.getCSVString(assetIds));
        response.putValue(CONTENT_ASSET_COUNT, this_.getCount(assetIds));
        return response;
    }

    private static final /* synthetic */ Object generateResponse_aroundBody1$advice(GetContentAssetsForTitleMessageDispatcher this_, WorkflowMessage request, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return GetContentAssetsForTitleMessageDispatcher.generateResponse_aroundBody0(this_, request);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            WorkflowMessage object = GetContentAssetsForTitleMessageDispatcher.generateResponse_aroundBody0(this_, request);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }
}

