/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.ingest;

import com.ericsson.cms.devices.content.ingest.AbstractIngestMessageDispatcher;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestException;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestResult;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.WorkflowMessage;

@Deprecated
public class MergeTitleMessageDispatcher
extends AbstractIngestMessageDispatcher {
    private static String TITLE_ID = "titleId";
    private static String METADATA_FILE_PATH = "metadataFilePath";
    private static final String SOURCE_COMPONENT_NAME = "sourceComponentName";
    private static final String SOURCE_ENTITY_NAME = "sourceEntityName";
    private static final String SOURCEID = "sourceId";
    private static final String VALIDATION_SUCCEDED = "validationSucceeded";
    private static final String DEPRECATION_MESSAGE = "_message_";
    private static final String REPLACEMENT_UID = "01CM41";
    private static final String REPLACEMENT_MESSAGE_NAME = "Update Title for Metadata";

    public MergeTitleMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected void validateRequiredParameters(WorkflowMessage request) {
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{TITLE_ID, METADATA_FILE_PATH});
    }

    @Override
    protected TitleIngestResult performIngest(WorkflowMessage request) {
        String metadataPath = Util.getStringValueTrimmed((WorkflowMessage)request, (String)METADATA_FILE_PATH);
        Long titleId = Util.getLongValue((WorkflowMessage)request, (String)TITLE_ID);
        TitleIngestResult result = null;
        try {
            result = this.getIngestService().updateTitleForMetadata(metadataPath, titleId, this.getActionSource(request));
        }
        catch (TitleIngestException e) {
            String msg = "Failed to update title[" + titleId + "] for metadata: " + metadataPath + ", error: " + e.getLocalizedMessage();
            throw new RuntimeException(msg, e);
        }
        return result;
    }

    @Override
    protected ITitleActionSource getActionSource(WorkflowMessage message) {
        String componentName = Util.getStringValueTrimmed((WorkflowMessage)message, (String)SOURCE_COMPONENT_NAME);
        String entityName = Util.getStringValueTrimmed((WorkflowMessage)message, (String)SOURCE_ENTITY_NAME);
        String sourceId = Util.getStringValueTrimmed((WorkflowMessage)message, (String)SOURCEID);
        return new TitleActionSource(componentName, entityName, sourceId);
    }

    @Override
    protected void updateResponseParameters(WorkflowMessage response, WorkflowMessage request, TitleIngestResult result) {
        response.putValue(VALIDATION_SUCCEDED, this.getValidationStatus(result));
    }

    @Override
    protected WorkflowMessage generateResponse(WorkflowMessage request) {
        WorkflowMessage response = super.generateResponse(request);
        this.writeDeprecationMessage(response, REPLACEMENT_UID, REPLACEMENT_MESSAGE_NAME);
        return response;
    }

    @Override
    protected WorkflowMessage generateNackMessage(WorkflowMessage request, String errorMessage) {
        WorkflowMessage response = super.generateNackMessage(request, errorMessage);
        this.writeDeprecationMessage(response, REPLACEMENT_UID, REPLACEMENT_MESSAGE_NAME);
        return response;
    }

    private void writeDeprecationMessage(WorkflowMessage response, String replacementUID, String replacementMessageName) {
        String message = "This message has been deprecated, please consider using " + replacementUID + " - " + replacementMessageName;
        response.putValue(DEPRECATION_MESSAGE, message);
    }
}

