/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.titlelist;

import com.ericsson.cms.devices.content.titlelist.TitleListMessageDispatcher;
import com.tandbergtv.cms.contentmgmt.titlelist.service.AssetListExporterException;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListManager;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class ExportTitleListMessageDispatcher
extends TitleListMessageDispatcher {
    private static final String TITLELIST_ID = "titleListId";
    private static final String DIR_PATH = "dirPath";
    private static final String FILE_PATH = "filePath";

    public ExportTitleListMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    @Transactional
    protected WorkflowMessage generateResponse(WorkflowMessage request) {
        WorkflowMessage workflowMessage = request;
        return (WorkflowMessage)ExportTitleListMessageDispatcher.generateResponse_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), ExportTitleListMessageDispatcher.class.getDeclaredMethod("generateResponse", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    private static final /* synthetic */ WorkflowMessage generateResponse_aroundBody0(ExportTitleListMessageDispatcher this_, WorkflowMessage request) {
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{TITLELIST_ID, DIR_PATH});
        long titleId = Util.getLongValue((WorkflowMessage)request, (String)TITLELIST_ID);
        String dirPath = Util.getStringValueTrimmed((WorkflowMessage)request, (String)DIR_PATH);
        IAssetListManager assetListManager = this_.getAssetListManagerService();
        String filePath = "";
        try {
            filePath = assetListManager.export(Long.valueOf(titleId), dirPath);
        }
        catch (AssetListExporterException e) {
            String msg = "Failed to export the title list  because of validation errors. Error: " + e.getMessage();
            throw new RuntimeException(msg);
        }
        WorkflowMessage message = WorkflowMessageFactory.createAckMessage((WorkflowMessage)request);
        message.putValue(FILE_PATH, filePath);
        return message;
    }

    private static final /* synthetic */ Object generateResponse_aroundBody1$advice(ExportTitleListMessageDispatcher this_, WorkflowMessage request, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ExportTitleListMessageDispatcher.generateResponse_aroundBody0(this_, request);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            WorkflowMessage object = ExportTitleListMessageDispatcher.generateResponse_aroundBody0(this_, request);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }
}

