/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.contentmgmt.titlelist.plugins.vodplaylist;

import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListAssetMap;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListElementMetadata;
import com.tandbergtv.cms.contentmgmt.titlelist.service.AssetListErrorCode;
import com.tandbergtv.cms.contentmgmt.titlelist.service.AssetListExporterException;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListExporter;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VodPlaylistExporter
implements IAssetListExporter {
    private static final String PROVIDER_ID_XPATH = "/Fields/ProviderInfo/Identifier/Id";
    private static final String ASSET_ID_XPATH = "/Fields/Identifier/Id";

    public String export(AssetList assetList, String dirPath) throws AssetListExporterException {
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        Document doc = builder.newDocument();
        Element root = doc.createElement("root");
        doc.appendChild(root);
        List listAssets = assetList.getAssetsMap();
        int position = 1;
        for (AssetListAssetMap alam : listAssets) {
            AssetListElementMetadata contentRestricted;
            AssetListElementMetadata rollsRestricted;
            AssetListElementMetadata segmentName;
            AssetListElementMetadata displayRestricted;
            AssetListElementMetadata trickModeRestricted;
            AssetListElementMetadata usage;
            AssetListElementMetadata endNpt;
            long assetId = alam.getAssetId();
            Asset asset = alam.getTitle().getAsset(assetId);
            String assetType = asset.getAssetType();
            ArrayList<String> assetTypeList = new ArrayList<String>();
            assetTypeList.add(assetType);
            List providerIdList = asset.getAllFieldsForXpath(assetTypeList, PROVIDER_ID_XPATH);
            if (providerIdList == null || providerIdList.size() == 0) {
                AssetListExporterException ex = new AssetListExporterException();
                ex.add(AssetListErrorCode.MISSING_ASSET_FIELD);
                throw ex;
            }
            String providerIdValue = ((Field)providerIdList.get(0)).getValue();
            List assetIdList = asset.getAllFieldsForXpath(assetTypeList, ASSET_ID_XPATH);
            if (assetIdList == null || assetIdList.size() == 0) {
                AssetListExporterException ex = new AssetListExporterException();
                ex.add(AssetListErrorCode.MISSING_ASSET_FIELD);
                throw ex;
            }
            String assetIdValue = ((Field)assetIdList.get(0)).getValue();
            Element segment = doc.createElement("segment");
            segment.setAttribute("segmentID", alam.getId() + "");
            segment.setAttribute("providerID", providerIdValue);
            segment.setAttribute("assetID", assetIdValue);
            segment.setAttribute("position", Integer.toString(position));
            ++position;
            AssetListElementMetadata startNpt = alam.getAssetListElementMetadata("startNPT");
            if (startNpt != null && startNpt.getIntegerValue() != null) {
                segment.setAttribute("startNPT", startNpt.getIntegerValue() + "");
            }
            if ((endNpt = alam.getAssetListElementMetadata("endNPT")) != null && endNpt.getIntegerValue() != null) {
                segment.setAttribute("endNPT", endNpt.getIntegerValue() + "");
            }
            if ((usage = alam.getAssetListElementMetadata("usage")) != null && usage.getStringValue() != null && !usage.getStringValue().equals("")) {
                segment.setAttribute("usage", usage.getStringValue());
            }
            if ((trickModeRestricted = alam.getAssetListElementMetadata("trickModeRestricted")) != null && trickModeRestricted.getStringValue() != null && !trickModeRestricted.getStringValue().equals("")) {
                segment.setAttribute("trickModeRestricted", trickModeRestricted.getStringValue());
            }
            if ((displayRestricted = alam.getAssetListElementMetadata("displayRestricted")) != null && displayRestricted.getStringValue() != null && !displayRestricted.getStringValue().equals("")) {
                segment.setAttribute("displayRestricted", displayRestricted.getStringValue());
            }
            if ((segmentName = alam.getAssetListElementMetadata("segmentName")) != null && segmentName.getStringValue() != null && !segmentName.getStringValue().equals("")) {
                segment.setAttribute("segmentName", segmentName.getStringValue());
            }
            if ((rollsRestricted = alam.getAssetListElementMetadata("rollsRestricted")) != null && rollsRestricted.getStringValue() != null && !rollsRestricted.getStringValue().equals("")) {
                segment.setAttribute("rollsRestricted", rollsRestricted.getStringValue());
            }
            if ((contentRestricted = alam.getAssetListElementMetadata("contentRestricted")) != null && contentRestricted.getStringValue() != null && !contentRestricted.getStringValue().equals("")) {
                segment.setAttribute("contentRestricted", contentRestricted.getStringValue());
            }
            root.appendChild(segment);
        }
        String filePath = this.generateFilePath(assetList.getId(), dirPath, assetList);
        try {
            DOMSource source = new DOMSource(doc);
            File file = new File(filePath);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new AssetListExporterException();
        }
        catch (TransformerException e) {
            throw new AssetListExporterException();
        }
        return filePath;
    }

    private String generateFilePath(long id, String folderPath, AssetList al) {
        File file = new File(folderPath);
        if (file.isDirectory() || file.getAbsolutePath().endsWith(al.getType())) {
            String EXPORT_FILENAME_PREFIX = "TitleList";
            String EXPORT_FILENAME_DELIMITER = "_";
            String EXPORT_FILENAME_EXTEN = ".xml";
            String fileName = EXPORT_FILENAME_PREFIX + EXPORT_FILENAME_DELIMITER + id + EXPORT_FILENAME_DELIMITER + Calendar.getInstance().getTimeInMillis() + EXPORT_FILENAME_EXTEN;
            File f = new File(folderPath, fileName);
            return f.getAbsolutePath();
        }
        return file.getAbsolutePath();
    }
}

