/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.file;

import com.tandbergtv.workflow.log.file.Deserializer;
import com.tandbergtv.workflow.log.file.Directories;
import com.tandbergtv.workflow.log.file.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jbpm.logging.log.ProcessLog;

public class LogReader {
    private String root;

    public LogReader(String root) {
        this.root = root;
    }

    public List<ProcessLog> getLogs(long id, final Class<? extends ProcessLog> type) {
        return this.getLogs(id, (Collection<Class<? extends ProcessLog>>)new ArrayList<Class<? extends ProcessLog>>(){
            {
                this.add(type);
            }
        });
    }

    public List<ProcessLog> getLogs(long id, Collection<Class<? extends ProcessLog>> types) {
        List<Object> list = new ArrayList();
        try {
            list = this.zipFile(id).exists() ? ZipUtil.read(this.zipFile(id)) : this.read(id);
            this.sort(list);
            Iterator i = list.iterator();
            while (i.hasNext()) {
                ProcessLog log = (ProcessLog)i.next();
                if (types.contains(log.getClass())) continue;
                i.remove();
            }
            return list;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    private List<ProcessLog> read(long id) {
        File[] files = Directories.directoryFor(this.root, id).listFiles();
        if (files.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ProcessLog> list = new ArrayList<ProcessLog>();
        for (File file : files) {
            ProcessLog log = new Deserializer(file).deserialize();
            if (log == null) continue;
            list.add(log);
        }
        return list;
    }

    private File zipFile(long id) {
        return new File(Directories.directoryFor(this.root, id), id + ".zip");
    }

    private void sort(List<ProcessLog> list) {
        Collections.sort(list, new Comparator<ProcessLog>(){

            @Override
            public int compare(ProcessLog o1, ProcessLog o2) {
                return (int)(o1.getId() - o2.getId());
            }
        });
    }
}

