/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.ChartComponent;
import chart.ChartLabel;
import chart.ChartLegendLM;
import chart.ChartLegendTableModel;
import chart.ChartObject;
import chart.ChartPlatform;
import chart.data.ChartDataSet;
import chart.graphics.ChartIcon;
import chart.graphics.ChartTextStyle;
import chart.properties.ChartComponentProperties;
import chart.properties.ChartLabelProperties;
import chart.properties.ChartLegendProperties;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.List;

public class ChartLegend
extends ChartComponent {
    public static final int NONE = 0;
    public static final int NORTH = 1;
    public static final int EAST = 2;
    public static final int SOUTH = 3;
    public static final int WEST = 4;
    public static final int L_T = 0;
    public static final int CENTER = 1;
    public static final int R_B = 2;
    private ChartPlatform QOIV;
    private ChartLegendProperties add;
    private ChartLegendLM clone;
    private ChartLegendTableModel closePath;
    private List contains;
    private ChartLabel[] createChildrenLabels;
    private ChartLabel[] doLayout;
    private int[] get;
    public String[] hintText;
    private ChartLabel getBackground;

    public ChartLegend(ChartPlatform chartPlatform) {
        this.QOIV = chartPlatform;
        this.add = new ChartLegendProperties();
        this.closePath = new ChartLegendTableModel(this);
        this.clone = new ChartLegendLM(this);
    }

    public ChartLegend(ChartPlatform chartPlatform, ChartLegendProperties chartLegendProperties) {
        this.QOIV = chartPlatform;
        this.add = chartLegendProperties;
        this.closePath = new ChartLegendTableModel(this);
        this.clone = new ChartLegendLM(this);
    }

    public void init() {
        this.setBackground(this.add.getBackground());
        this.closePath.createChildrenLabels();
        this.contains = this.closePath.getSeriesLabels();
        this.createChildrenLabels = this.closePath.getLabels();
        this.getBackground = this.closePath.getTotalValueLabel();
        this.doLayout = new ChartLabel[this.createChildrenLabels.length];
        int n = 0;
        while (n < this.createChildrenLabels.length) {
            this.doLayout[n] = new ChartLabel(this.createChildrenLabels[n].getText());
            ++n;
        }
        if (this.add.isAutoSize() && this.add.getPlacement() == 0) {
            this.add.setPlacement(2);
        }
        this.setLabelStyle();
        this.setIconStyle();
    }

    public void createChildren(ChartComponentProperties chartComponentProperties) {
    }

    public void setIconStyle() {
        this.get = this.add.getIconStyleList();
        int n = 0;
        while (n < this.createChildrenLabels.length) {
            if (this.get != null && this.get.length != 0) {
                this.createChildrenLabels[n].setIconStyle(this.get[n % this.get.length]);
            } else {
                this.createChildrenLabels[n].setIconStyle(0);
            }
            ++n;
        }
        this.QOIV();
    }

    private void QOIV() {
        List list = this.QOIV.getDataSetModel().getChartDataSets();
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int n = list.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            ChartDataSet chartDataSet = (ChartDataSet)list.get(n3);
            int n4 = chartDataSet.getLegendSeriesLabels().size();
            int[] nArray = new int[n4];
            int n5 = 0;
            while (n5 < n4) {
                nArray[n5] = this.createChildrenLabels[n5 + n2].getIconStyle();
                ++n5;
            }
            arrayList.add(nArray);
            n2 += n4;
            ++n3;
        }
        this.QOIV.getChartRenderInfo().setLegendIconStyleList(arrayList);
    }

    public int[] getIconStyleList() {
        if (this.get == null || this.get.length < this.createChildrenLabels.length) {
            this.get = new int[this.createChildrenLabels.length];
            int n = 0;
            while (n < this.createChildrenLabels.length) {
                this.get[n] = this.createChildrenLabels[n].getIcon().getIconStyle();
                ++n;
            }
        }
        return this.get;
    }

    public void setLabelStyle() {
        ChartLabelProperties chartLabelProperties;
        int n = 0;
        while (n < this.createChildrenLabels.length) {
            chartLabelProperties = (ChartLabelProperties)this.add.getLabelStyle().clone();
            chartLabelProperties.getIcon().setColor(this.createChildrenLabels[n].getIcon().getColor());
            chartLabelProperties.setText(this.createChildrenLabels[n].getText());
            chartLabelProperties.setBackground(null);
            chartLabelProperties.setTextAlignment(1);
            this.createChildrenLabels[n].setProperties(chartLabelProperties);
            this.createChildrenLabels[n].background = null;
            ++n;
        }
        if (this.getBackground != null) {
            chartLabelProperties = (ChartLabelProperties)this.add.getLabelStyle().clone();
            chartLabelProperties.setText(this.getBackground.getText());
            chartLabelProperties.setBackground(null);
            chartLabelProperties.setTextAlignment(4);
            this.getBackground.setProperties(chartLabelProperties);
            this.getBackground.background = null;
        }
    }

    public void setLabelStyle(ChartIcon chartIcon, ChartTextStyle chartTextStyle, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < this.createChildrenLabels.length) {
            this.createChildrenLabels[n4].setIconAlignment(n);
            this.createChildrenLabels[n4].setTextAlignment(n2);
            this.createChildrenLabels[n4].setIconTextGap(n3);
            ChartIcon chartIcon2 = (ChartIcon)chartIcon.clone();
            this.createChildrenLabels[n4].getIcon().setPen(chartIcon2.getPen());
            this.createChildrenLabels[n4].getIcon().setIconWidth(chartIcon.getIconWidth());
            this.createChildrenLabels[n4].getIcon().setIconHeight(chartIcon.getIconHeight());
            this.createChildrenLabels[n4].setChartTextStyle(chartTextStyle);
            this.createChildrenLabels[n4].getIcon().setColor(chartIcon.getColor());
            ++n4;
        }
    }

    public void locate() {
        this.setLabelStyle();
        this.setIconStyle();
        this.clone.doLayout();
    }

    public void doLayout() {
    }

    public void paint(Graphics2D graphics2D) {
        if (this.QOIV.getProperties().isShowLegend()) {
            this.background = this.add.getBackground();
            super.paint(graphics2D);
            super.paintBorder(graphics2D);
        }
    }

    public static int ceil(double d) {
        if (Math.round(d) != (long)((int)d)) {
            return (int)Math.round(d);
        }
        return (int)d + 1;
    }

    public List getLegendSeriesLabels() {
        return this.contains;
    }

    public ChartLabel[] getLabels() {
        return this.createChildrenLabels;
    }

    public int getPrePlacement() {
        return this.add.getPlacement();
    }

    public int getPreferredPlacement() {
        return this.add.getPlacement();
    }

    public ChartPlatform getChartPlatform() {
        return this.QOIV;
    }

    public ChartLegendProperties getProperties() {
        return this.add;
    }

    public void setProperties(ChartLegendProperties chartLegendProperties) {
        this.add = chartLegendProperties;
    }

    public ChartObject getChartObject(int n, int n2) {
        if (this.getBounds().contains(n, n2)) {
            return this;
        }
        return null;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    public String[] getHintValue(int n, int n2) {
        if (!this.add.isShowTips()) {
            return null;
        }
        this.hintText = new String[1];
        ChartLabel[] chartLabelArray = this.getLabels();
        ChartLabel[] chartLabelArray2 = this.getOriLabels();
        int n3 = chartLabelArray2.length;
        int n4 = n - this.getBounds().x;
        int n5 = n2 - this.getBounds().y;
        int n6 = 0;
        while (n6 < n3) {
            if (chartLabelArray[n6].contains(n, n2)) {
                this.hintText[0] = chartLabelArray2[n6].getText();
                break;
            }
            ++n6;
        }
        if (this.getBackground != null && this.getBackground.contains(n, n2)) {
            this.hintText[0] = this.getBackground.getText();
        }
        if (this.hintText[0] == null) {
            this.hintText = null;
        }
        return this.hintText;
    }

    public ChartLabel[] getOriLabels() {
        return this.doLayout;
    }

    public ChartLabel getTotalValueLabel() {
        return this.getBackground;
    }

    public Shape[] getLabelsShapes() {
        int n = this.createChildrenLabels.length;
        Shape[] shapeArray = new GeneralPath[n];
        int n2 = 0;
        while (n2 < n) {
            shapeArray[n2] = new GeneralPath();
            ((Path2D)shapeArray[n2]).reset();
            float f = this.createChildrenLabels[n2].x;
            float f2 = this.createChildrenLabels[n2].y;
            float f3 = this.createChildrenLabels[n2].getWidth();
            float f4 = this.createChildrenLabels[n2].getHeight();
            ((Path2D.Float)shapeArray[n2]).moveTo(f, f2);
            ((Path2D.Float)shapeArray[n2]).lineTo(f + f3, f2);
            ((Path2D.Float)shapeArray[n2]).lineTo(f + f3, f2 + f4);
            ((Path2D.Float)shapeArray[n2]).lineTo(f, f2 + f4);
            ((Path2D.Float)shapeArray[n2]).lineTo(f, f2);
            ((Path2D)shapeArray[n2]).closePath();
            ++n2;
        }
        return shapeArray;
    }
}

