/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.custom.normalization;

import com.tandbergtv.cms.rules.custom.NameLookup;
import com.tandbergtv.cms.rules.customrules.CustomNormalizationRule;
import com.tandbergtv.cms.rules.customrules.CustomRuleParameter;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AttCopyLanguage
implements CustomNormalizationRule {
    private static final String TITLE = "TITLE";
    private static final String SRC_LANGUAGE_XPATH = "/tns:Fields/tns:CustomFields/tns:CustomField[@name=TitleLanguage]/@value";
    private static final String DEST_LANGUAGE_XPATH = "/tns:Fields/tns:Title/tns:DisplayTitle/tns:Language/@value";
    private static final int NUM_INDICES = 4;

    public RuleResults runRule(Map<String, Object> parameters, Title title) {
        RuleResults result = new RuleResults(title);
        List srcLanuages = title.getAsset().getAllFieldsForXpath(TITLE, SRC_LANGUAGE_XPATH);
        List destLanuages = title.getAsset().getAllFieldsForXpath(TITLE, DEST_LANGUAGE_XPATH);
        if (srcLanuages.size() != 1 || destLanuages.size() > 1) {
            return result;
        }
        String srcLangValue = ((Field)srcLanuages.get(0)).getValue();
        if (destLanuages.size() == 1) {
            ((Field)destLanuages.get(0)).setValue(srcLangValue);
        } else {
            Field destLangField = new Field(DEST_LANGUAGE_XPATH, srcLangValue);
            for (int i = 0; i < 4; ++i) {
                destLangField.getIndices().add(1);
            }
            List titles = title.getAsset().getAllAssetsOfType(TITLE);
            for (Asset t : titles) {
                t.addField(destLangField);
            }
        }
        result.setModified(true);
        return result;
    }

    public String getName(Locale locale) {
        return NameLookup.lookupValue("AttCopyLanguage", locale);
    }

    public List<CustomRuleParameter> getParameters(Locale locale) {
        return new ArrayList<CustomRuleParameter>();
    }
}

