/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.custom.normalization;

import com.tandbergtv.cms.rules.custom.NameLookup;
import com.tandbergtv.cms.rules.custom.normalization.Util;
import com.tandbergtv.cms.rules.customrules.CustomNormalizationRule;
import com.tandbergtv.cms.rules.customrules.CustomRuleParameter;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AttCopyProviderName
implements CustomNormalizationRule {
    private static final String PACKAGE = "PACKAGE";
    private static final String TITLE = "TITLE";
    private static final String SRC_PROVIDER_NAME_XPATH = "/tns:Fields/tns:ProviderInfo/tns:Name";
    private static final String DEST_NETWORK_XPATH = "/tns:Fields/tns:TvId/tns:Network";

    public RuleResults runRule(Map<String, Object> parameters, Title title) {
        RuleResults result = new RuleResults(title);
        List providerId = title.getAsset().getAllFieldsForXpath(PACKAGE, SRC_PROVIDER_NAME_XPATH);
        List network = title.getAsset().getAllFieldsForXpath(TITLE, DEST_NETWORK_XPATH);
        if (providerId.size() == 0) {
            return result;
        }
        String providerIdValue = ((Field)providerId.get(0)).getValue();
        if (network.size() == 1) {
            ((Field)network.get(0)).setValue(providerIdValue);
        } else {
            Field destNetworkField = new Field(DEST_NETWORK_XPATH, providerIdValue);
            Util.setFieldIndices(destNetworkField);
            List titles = title.getAsset().getAllAssetsOfType(TITLE);
            ((Asset)titles.get(0)).addField(destNetworkField);
        }
        result.setModified(true);
        return result;
    }

    public String getName(Locale locale) {
        return NameLookup.lookupValue("AttProviderNameToNetwork", locale);
    }

    public List<CustomRuleParameter> getParameters(Locale locale) {
        return new ArrayList<CustomRuleParameter>();
    }
}

