/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.titlelist.barker;

import com.ericsson.cms.titlelist.barker.BarkerUtils;
import com.ericsson.scac.cms.edgeware.utils.OriginUtils;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListAssetMap;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListElementMetadata;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListMetadata;
import com.tandbergtv.cms.contentmgmt.titlelist.service.AssetListValidationException;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListManager;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class BarkerDebug {
    private static final Logger logger = Logger.getLogger(BarkerDebug.class);

    public static void modifyAssetList(AssetList al) throws Exception {
        IAssetListManager almngr = BarkerUtils.getAssetListManager();
        List alamList = al.getAssetsMap();
        ArrayList<AssetListAssetMap> removalList = new ArrayList<AssetListAssetMap>();
        for (AssetListAssetMap alam : alamList) {
            long targetAssetId = alam.getAssetId();
            Asset cmsParentAsset = alam.getTitle().getAsset();
            Asset cmsTargetAsset = cmsParentAsset.getAsset(targetAssetId);
            Asset cmsTitleAsset = BarkerUtils.getTitleAsset(cmsParentAsset);
            logger.info((Object)("cmsParentAsset: " + cmsParentAsset.getId()));
            logger.info((Object)("cmsTargetAsset: " + cmsTargetAsset.getId()));
            logger.info((Object)("cmsTitleAsset: " + cmsTitleAsset.getId()));
            String transcode = BarkerUtils.getCMSFieldValue(cmsTargetAsset, "/tns:Fields/tns:CustomFields/tns:CustomField[@name=TRANSCODE]/@value");
            String runtime = BarkerUtils.getCMSFieldValue(cmsTargetAsset, "/tns:Fields/tns:Duration/tns:Duration");
            String providerId = BarkerUtils.getCMSFieldValue(cmsTargetAsset, "/tns:Fields/tns:ProviderInfo/tns:Identifier/tns:Id");
            String publish = BarkerUtils.getCMSFieldValue(cmsTitleAsset, "/tns:Fields/tns:Rights/tns:LicensingWindowStart");
            logger.info((Object)("transcode: " + transcode));
            logger.info((Object)("runtime: " + runtime));
            logger.info((Object)("providerId: " + providerId));
            logger.info((Object)("publish: " + publish));
            Date publishDate = OriginUtils.parseUTC((String)(publish + "Z"));
            Calendar publishCal = Calendar.getInstance();
            publishCal.setTime(publishDate);
            Calendar now = Calendar.getInstance();
            if (!now.before(publishCal)) continue;
            logger.info((Object)"adding item to removal list!");
            removalList.add(alam);
        }
        logger.info((Object)"Attempting to remove items");
        al.removeAssetsMap(removalList);
        logger.info((Object)"Updating manager");
        almngr.update(al);
    }

    public static void inspect(IAssetListManager almngr) {
        logger.info((Object)"BEGIN ASSETLIST MANAGER");
        logger.info((Object)("count: " + almngr.count()));
        List lists = almngr.getAllAssetLists();
        for (AssetList al : lists) {
            List mapList = al.getAssetsMap();
            List metaList = al.getListMetadata();
            logger.info((Object)"--BEGIN ASSETLIST");
            logger.info((Object)("--id: " + al.getId()));
            logger.info((Object)("--name: " + al.getName()));
            logger.info((Object)("--type: " + al.getType()));
            logger.info((Object)("--description: " + al.getDescription()));
            logger.info((Object)("--content-class: " + al.getContentClass()));
            for (AssetListAssetMap am : mapList) {
                Title title = am.getTitle();
                logger.info((Object)"----BEGIN ASSETMAP");
                logger.info((Object)("----id: " + am.getId()));
                logger.info((Object)("----asset-id: " + am.getAssetId()));
                logger.info((Object)("----title: " + title));
                logger.info((Object)("----title-id: " + title.getId()));
                logger.info((Object)"----END ASSETMAP\n\n");
            }
            logger.info((Object)"--END ASSETLIST\n\n\n");
        }
        logger.info((Object)"END ASSETLIST MANAGER");
    }

    public static void inspect(AssetList al) {
        logger.info((Object)"BEGIN ASSETLIST");
        List mapList = al.getAssetsMap();
        List metaList = al.getListMetadata();
        logger.info((Object)("--id: " + al.getId()));
        logger.info((Object)("--name: " + al.getName()));
        logger.info((Object)("--type: " + al.getType()));
        logger.info((Object)("--description: " + al.getDescription()));
        logger.info((Object)("--content-class: " + al.getContentClass()));
        for (AssetListAssetMap am : mapList) {
            logger.info((Object)"--BEGIN ASSETMAP");
            Title title = am.getTitle();
            AssetList foo = am.getAssetList();
            List alemList = am.getListElementMetadata();
            for (AssetListElementMetadata alem : alemList) {
                logger.info((Object)"---BEGIN AssetListElementMetadata");
                logger.info((Object)("---name: " + alem.getName()));
                logger.info((Object)("---string-value: " + alem.getStringValue()));
                logger.info((Object)"---END AssetListElementMetadata");
            }
            long assetId = am.getAssetId();
            logger.info((Object)("----id: " + am.getId()));
            logger.info((Object)("----asset-id: " + assetId));
            logger.info((Object)("----title: " + title));
            logger.info((Object)("----title-id: " + title.getId()));
            Collection allAssetsCol = title.getAllAssets(true);
            ArrayList allAssetsList = new ArrayList(allAssetsCol);
            for (Asset as : allAssetsList) {
                Field field2;
                logger.info((Object)"----BEGIN ASSET");
                logger.info((Object)("------id: " + as.getId()));
                logger.info((Object)("------type: " + as.getAssetType()));
                logger.info((Object)("------display-id: " + as.getDisplayId()));
                logger.info((Object)("------TTVId: " + as.getTTVId()));
                Field field = as.getField("/tns:Fields/tns:Identifier/tns:Id");
                if (field != null) {
                    logger.info((Object)("------field: " + field.getValue()));
                }
                if ((field2 = as.getFirstField("/tns:Fields/tns:Identifier/tns:Id")) != null) {
                    logger.info((Object)("------first-field: " + field2.getValue()));
                }
                List descFileList = as.getAllDescendantFiles();
                for (com.tandbergtv.metadatamanager.model.File f : descFileList) {
                    logger.info((Object)"----BEGIN DESCENDANT FILE");
                    logger.info((Object)("------id: " + f.getId()));
                    logger.info((Object)("------TTVId: " + f.getTTVId()));
                    logger.info((Object)("------display-id: " + f.getDisplayId()));
                    logger.info((Object)("------name: " + f.getName()));
                    logger.info((Object)("------content-name: " + f.getContentFileName()));
                    logger.info((Object)("------uri: " + f.getContentURI()));
                    logger.info((Object)("------url: " + f.getURL()));
                    logger.info((Object)"----END DESCENDANT FILE\n");
                }
                logger.info((Object)"----END ASSET\n");
            }
            logger.info((Object)"--END ASSETMAP\n\n");
        }
        if (metaList != null) {
            for (AssetListMetadata alm : metaList) {
                logger.info((Object)"--BEGIN ASSETLISTMETADATA");
                logger.info((Object)("----class: " + alm.getClass()));
                logger.info((Object)("----name: " + alm.getName()));
                logger.info((Object)("----data-type: " + alm.getDataType()));
                logger.info((Object)("----string-val: " + alm.getStringValue()));
                logger.info((Object)("----typed-val: " + alm.getTypedValue()));
                logger.info((Object)("----date-val: " + alm.getDateValue()));
                logger.info((Object)("----time-val: " + alm.getTimeValue()));
                logger.info((Object)("----float-val: " + alm.getFloatValue()));
                logger.info((Object)("----int-val: " + alm.getIntegerValue()));
                logger.info((Object)("----bool-val: " + alm.getBooleanValue()));
                logger.info((Object)"--END ASSETLISTMETADATA\n\n");
            }
        } else {
            logger.info((Object)"AssetListMetadata is NULL!");
        }
        logger.info((Object)"END ASSETLIST\n\n\n");
    }

    public static void writeDebugExportData(String testFilPath, AssetList cmsAssetList) {
        String testFilePath = null;
        PrintWriter out = null;
        FileWriter testOutFile = null;
        testOutFile = BarkerUtils.getFileWriter(testFilePath);
        out = new PrintWriter(testOutFile);
        out.println("Titlelist Id : " + cmsAssetList.getId());
        out.println("Titlelist Name : " + cmsAssetList.getName());
        out.println("Titlelist Description : " + cmsAssetList.getDescription());
        out.println("Content Class : " + cmsAssetList.getContentClass());
        for (AssetListMetadata assetListMetadata : cmsAssetList.getListMetadata()) {
            out.println("name" + assetListMetadata.getName());
            if (assetListMetadata.getDateValue() != null) {
                out.println("date value" + assetListMetadata.getDateValue());
            }
            if (assetListMetadata.getStringValue() != null) {
                out.println("string value" + assetListMetadata.getStringValue());
            }
            if (assetListMetadata.getTimeValue() == null) continue;
            out.println("time value" + assetListMetadata.getTimeValue());
        }
        String packageAssetId = BarkerUtils.getPackageAssetId(cmsAssetList);
        out.println("packageAssetId:" + packageAssetId);
        out.println("Assets : ");
        for (AssetListAssetMap cmsAssetMap : cmsAssetList.getAssetsMap()) {
            long previewAssetId = cmsAssetMap.getAssetId();
            out.println(" Asset Id: " + previewAssetId);
            out.println(" Title Id: " + cmsAssetMap.getTitle().getId());
            out.println("***************");
            out.println("tltle metadata content:" + cmsAssetMap.getTitle().getMetadataContent());
            Asset topAsset = cmsAssetMap.getTitle().getAsset();
            out.println("assetMap.getTitle().getAsset().getTTVId().getId();" + cmsAssetMap.getTitle().getAsset().getTTVId().getId());
            out.println("begin top asset***************");
            for (Field cmsAssetField : topAsset.getFields()) {
                out.println("assetField.getValue():" + cmsAssetField.getValue());
                out.println("assetField.getTtvXPath():" + cmsAssetField.getTtvXPath());
            }
            out.println("end top asset***************");
            out.println("begin title asset***************");
            List titleAssetList = topAsset.getAllAssetsOfType("TITLE");
            if (titleAssetList != null && titleAssetList.size() > 0) {
                out.println("should be one title:" + titleAssetList.size());
                Asset titleAsset = (Asset)titleAssetList.get(0);
                for (Field cmsAssetField : titleAsset.getFields()) {
                    out.println("assetField.getValue():" + cmsAssetField.getValue());
                    out.println("assetField.getTtvXPath():" + cmsAssetField.getTtvXPath());
                }
            }
            out.println("end title asset***************");
            Asset previewAsset = topAsset.getAsset(previewAssetId);
            if (previewAsset != null) {
                out.println("begin preview?? asset***************");
                for (Field cmsAssetField : previewAsset.getFields()) {
                    out.println("assetField.getValue():" + cmsAssetField.getValue());
                    out.println("assetField.getTtvXPath():" + cmsAssetField.getTtvXPath());
                }
                out.println("end preview?? asset***************");
            } else {
                out.println("no preview asset found");
            }
            for (Asset cmsAsset : cmsAssetMap.getTitle().getAsset().getAllDescendantAssets()) {
                out.println("asset.getTTVId()" + cmsAsset.getTTVId());
                for (Field cmsAssetField : cmsAsset.getFields()) {
                    out.println("assetField.getValue():" + cmsAssetField.getValue());
                    out.println("assetField.getTtvXPath():" + cmsAssetField.getTtvXPath());
                }
            }
            out.println("***************");
            for (Asset cmsPreviewAsset : cmsAssetMap.getTitle().getAsset().getAllAssetsOfType("PREVIEW")) {
                out.println("found preview asset");
                out.println("previewAsset.getTTVId():" + cmsPreviewAsset.getTTVId());
                for (Field cmsAssetField : cmsPreviewAsset.getFields()) {
                    out.println("assetField.getValue():" + cmsAssetField.getValue());
                    out.println("assetField.getTtvXPath():" + cmsAssetField.getTtvXPath());
                }
                for (com.tandbergtv.metadatamanager.model.File cmsFile : cmsPreviewAsset.getAllDescendantFiles()) {
                    if (!cmsFile.isOriginal()) continue;
                    out.println("uri" + cmsFile.getURL());
                }
            }
        }
        out.close();
    }

    private static String getOriginalFilePath2(Asset groupAsset, long assetId) {
        Asset targetAsset = null;
        for (Asset asset : groupAsset.getAllAssets(false)) {
            if (asset.getId() != assetId) continue;
            targetAsset = asset;
            break;
        }
        com.tandbergtv.metadatamanager.model.File originalFile = null;
        List files = targetAsset.getChildrenOfType(com.tandbergtv.metadatamanager.model.File.class);
        if (files != null) {
            for (com.tandbergtv.metadatamanager.model.File file : files) {
                if (!file.isOriginal()) continue;
                originalFile = file;
                break;
            }
        }
        String retFileUri = null;
        if (originalFile != null) {
            String fileUri = originalFile.getURL() != null ? originalFile.getURL() : "";
            retFileUri = BarkerDebug.replace(fileUri, File.separator, "-");
            logger.info((Object)("fileName" + fileUri));
        }
        return retFileUri;
    }

    private static String replace(String text, String searchString, String replacement) {
        return BarkerDebug.replace(text, searchString, replacement, -1);
    }

    private static String replace(String text, String searchString, String replacement, int max) {
        if (BarkerDebug.isEmpty(text) || BarkerDebug.isEmpty(searchString) || replacement == null || max == 0) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuffer buf = new StringBuffer(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = text.indexOf(searchString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private static String generateFilePath(long id, String folderPath) {
        String fileName = "barkerplaylist_" + id + "_" + Calendar.getInstance().getTimeInMillis() + "." + "json";
        File f = new File(folderPath, fileName);
        return f.getAbsolutePath();
    }

    private static long addMilliTime(Calendar calendar) {
        long addMilliTime = 0L;
        calendar.add(14, 180);
        addMilliTime = calendar.getTimeInMillis();
        return addMilliTime;
    }

    public static String TEST_setBarkerTimeValue(String name, AssetList cmsAssetList, IAssetListManager almngr) {
        String timeValue = null;
        for (AssetListMetadata alm : cmsAssetList.getListMetadata()) {
            if (!name.equalsIgnoreCase(alm.getName())) continue;
            timeValue = alm.getTimeValue();
            logger.info((Object)"ATTEMPTING TO SET CUSTOM FIELD");
            alm.setTimeValue("23:59:59");
            try {
                almngr.update(cmsAssetList);
            }
            catch (AssetListValidationException e) {
                logger.error((Object)e);
            }
            break;
        }
        return timeValue;
    }
}

