/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.titlelist.barker;

import com.ericsson.cms.titlelist.barker.BarkerUtils;
import com.ericsson.scac.cms.edgeware.model.Asset;
import com.ericsson.scac.cms.edgeware.model.AssetAuxFile;
import com.ericsson.scac.cms.edgeware.model.AssetAuxInfo;
import com.ericsson.scac.cms.edgeware.model.AssetAuxInfoList;
import com.ericsson.scac.cms.edgeware.model.AssetList;
import com.ericsson.scac.cms.edgeware.model.BarkerExport;
import com.ericsson.scac.cms.edgeware.model.Playlist;
import com.ericsson.scac.cms.edgeware.model.PlaylistClip;
import com.ericsson.scac.cms.edgeware.model.PlaylistClipList;
import com.ericsson.scac.cms.edgeware.model.Playout;
import com.ericsson.scac.cms.edgeware.model.PlayoutEvent;
import com.ericsson.scac.cms.edgeware.model.PlayoutEventList;
import com.ericsson.scac.cms.edgeware.model.Schedule;
import com.ericsson.scac.cms.edgeware.model.TitleList;
import com.ericsson.scac.cms.edgeware.utils.JSON;
import com.ericsson.scac.cms.edgeware.utils.OriginUtils;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListAssetMap;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListElementMetadata;
import com.tandbergtv.cms.contentmgmt.titlelist.service.AssetListExporterException;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListExporter;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalTime;

public class BarkerExporter
implements IAssetListExporter {
    private static final Logger logger = Logger.getLogger(BarkerExporter.class);
    private static final String STAMP_FORMAT = "yyyy-MM-dd'_'HHmmss.SSS";

    public String export(com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList al, String dirPath) throws AssetListExporterException {
        logger.info((Object)("called for: " + al.getId() + ", " + al.getName() + "; dirPath: " + dirPath));
        TitleList tl = BarkerUtils.getTitleList(al);
        String overlayFilePath = this.generateBarkerOverlayFilePath(al.getId(), dirPath);
        String exportFilePath = this.generateBarkerExportFilePath(al.getId(), dirPath);
        tl.setOverlayFilePath(overlayFilePath);
        BarkerExport be = this.buildBarkerExport(al, tl);
        this.writeBarkerExport(exportFilePath, be);
        this.writeBarkerOverlay(overlayFilePath, al);
        logger.debug((Object)("ExportPath: " + exportFilePath));
        logger.debug((Object)("OverlayPath: " + overlayFilePath));
        return exportFilePath;
    }

    private String generateBarkerOverlayFilePath(long id, String folderPath) {
        SimpleDateFormat stampDF = new SimpleDateFormat(STAMP_FORMAT);
        String stamp = stampDF.format(new Date());
        Properties properties = BarkerUtils.getProperties();
        String overlayExt = properties.getProperty("overlay.image.format");
        String fileName = "barkerplaylist_" + id + "_" + stamp + "." + overlayExt;
        File f = new File(folderPath, fileName);
        return f.getAbsolutePath();
    }

    private String generateBarkerExportFilePath(long id, String folderPath) {
        SimpleDateFormat stampDF = new SimpleDateFormat(STAMP_FORMAT);
        String stamp = stampDF.format(new Date());
        String fileName = "barkerplaylist_" + id + "_" + stamp + "." + "json";
        File f = new File(folderPath, fileName);
        return f.getAbsolutePath();
    }

    private void writeBarkerExport(String exportFilePath, BarkerExport be) {
        FileWriter exportFW = BarkerUtils.getFileWriter(exportFilePath);
        PrintWriter exportPW = new PrintWriter(exportFW);
        exportPW.println(JSON.marshall((Object)be));
        exportPW.close();
    }

    private void writeBarkerOverlay(String overlayFilePath, com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList al) {
        Properties properties = BarkerUtils.getProperties();
        String overlayExt = properties.getProperty("overlay.image.format");
        FileWriter overlayFW = BarkerUtils.getFileWriter(overlayFilePath);
        PrintWriter overlayPW = new PrintWriter(overlayFW);
        byte[] overlayValue = BarkerUtils.getBarkerOverlayValue("OverlayImage", al);
        if (overlayValue != null) {
            BufferedImage imag = null;
            try {
                imag = ImageIO.read(new ByteArrayInputStream(overlayValue));
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            try {
                if (imag != null) {
                    ImageIO.write((RenderedImage)imag, overlayExt, new File(overlayFilePath));
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        } else {
            logger.debug((Object)"****NO BARKER OVERLAY IMAGE FOUND****");
        }
        overlayPW.close();
    }

    private BarkerExport buildBarkerExport(com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList al, TitleList tl) {
        List alamList = al.getAssetsMap();
        Playlist po = this.buildOriginPlaylist(al, tl);
        Playout pl = this.buildOriginPlayout(al, tl);
        Schedule sc = this.buildOriginSchedule(tl);
        PlayoutEvent poe = this.buildOriginPlayoutEvent(tl);
        PlayoutEventList poeList = this.buildOriginPlayoutEventList(pl, al);
        AssetList originAssetList = this.buildOriginAssetList(alamList);
        AssetAuxInfoList aaiList = this.buildAssetAuxInfoList(alamList);
        BarkerExport be = this.buildBarkerExport(originAssetList, po, pl, sc, poe, poeList, tl, aaiList);
        return be;
    }

    private BarkerExport buildBarkerExport(AssetList originAL, Playlist pl, Playout po, Schedule sc, PlayoutEvent poe, PlayoutEventList poelist, TitleList tl, AssetAuxInfoList aaiList) {
        BarkerExport be = new BarkerExport();
        be.setAssetList(originAL);
        be.setPlaylist(pl);
        be.setPlayout(po);
        be.setSchedule(sc);
        be.setPlayoutEvent(poe);
        be.setPlayoutEventList(poelist);
        be.setTitleList(tl);
        be.setAssetAuxInfoList(aaiList);
        return be;
    }

    private AssetList buildOriginAssetList(List<AssetListAssetMap> alamList) {
        AssetList originAssetList = new AssetList();
        for (AssetListAssetMap alam : alamList) {
            long targetAssetId = alam.getAssetId();
            Title title = alam.getTitle();
            logger.debug((Object)("title: " + title.getId()));
            com.tandbergtv.metadatamanager.model.Asset cmsParentAsset = alam.getTitle().getAsset();
            com.tandbergtv.metadatamanager.model.Asset cmsTargetAsset = cmsParentAsset.getAsset(targetAssetId);
            com.tandbergtv.metadatamanager.model.Asset cmsTitleAsset = BarkerUtils.getTitleAsset(cmsParentAsset);
            String targetCMSAssetId = BarkerUtils.getAssetId(cmsTargetAsset);
            logger.debug((Object)("AssetID: " + targetCMSAssetId));
            String targetFileName = this.getOriginalFileName(cmsParentAsset, targetAssetId);
            String originAssetName = targetCMSAssetId;
            Asset originAsset = this.buildOriginAsset(cmsTargetAsset, cmsTitleAsset, originAssetName);
            originAssetList.addAsset(originAsset);
        }
        return originAssetList;
    }

    private AssetAuxInfoList buildAssetAuxInfoList(List<AssetListAssetMap> alamList) {
        AssetAuxInfoList aaiList = new AssetAuxInfoList();
        for (AssetListAssetMap alam : alamList) {
            String targetCMSAssetId;
            long targetAssetId = alam.getAssetId();
            Title title = alam.getTitle();
            com.tandbergtv.metadatamanager.model.Asset cmsParentAsset = title.getAsset();
            com.tandbergtv.metadatamanager.model.Asset cmsTargetAsset = cmsParentAsset.getAsset(targetAssetId);
            com.tandbergtv.metadatamanager.model.Asset cmsTitleAsset = BarkerUtils.getTitleAsset(cmsParentAsset);
            String originAssetName = targetCMSAssetId = BarkerUtils.getAssetId(cmsTargetAsset);
            AssetAuxInfo aai = this.buildAssetAux(cmsTargetAsset, cmsTitleAsset, title, originAssetName);
            this.buildAssetAuxFile(cmsParentAsset, targetAssetId, aai);
            aaiList.addAuxAsset(aai);
        }
        return aaiList;
    }

    private AssetAuxInfo buildAssetAux(com.tandbergtv.metadatamanager.model.Asset cmsTargetAsset, com.tandbergtv.metadatamanager.model.Asset cmsTitleAsset, Title title, String assetFileName) {
        AssetAuxInfo aai = new AssetAuxInfo();
        String transcode = BarkerUtils.getCMSFieldValue(cmsTargetAsset, "/tns:Fields/tns:CustomFields/tns:CustomField[@name=TRANSCODE]/@value");
        String runtime = BarkerUtils.getCMSFieldValue(cmsTargetAsset, "/tns:Fields/tns:Duration/tns:Duration");
        String providerId = BarkerUtils.getCMSFieldValue(cmsTargetAsset, "/tns:Fields/tns:ProviderInfo/tns:Identifier/tns:Id");
        String targetCMSAssetId = BarkerUtils.getAssetId(cmsTargetAsset);
        String assetType = cmsTargetAsset.getAssetType();
        String packageAssetId = BarkerUtils.getPackageAssetId(title);
        aai.setAsset_id(targetCMSAssetId);
        aai.setTtv_asset_id(cmsTargetAsset.getId());
        aai.setOrigin_name(targetCMSAssetId);
        aai.setRuntime(runtime);
        aai.setTranscode_required(transcode);
        aai.setProvider_id(providerId);
        aai.setAsset_type(assetType);
        aai.setPaid(providerId + "::" + packageAssetId);
        return aai;
    }

    private void buildAssetAuxFile(com.tandbergtv.metadatamanager.model.Asset groupAsset, long assetId, AssetAuxInfo aai) {
        List fileList;
        com.tandbergtv.metadatamanager.model.Asset targetAsset = null;
        for (com.tandbergtv.metadatamanager.model.Asset asset : groupAsset.getAllAssets(false)) {
            if (asset.getId() != assetId) continue;
            targetAsset = asset;
            break;
        }
        if ((fileList = targetAsset.getDirectDescendantFiles()) != null) {
            for (com.tandbergtv.metadatamanager.model.File f : fileList) {
                Field lkField = f.getFirstField("/tns:Fields/tns:CustomFields/tns:CustomField[@name=LookupKey]/@value");
                Object obj = null;
                if (lkField == null) {
                    logger.error((Object)"lkField is NULL");
                    continue;
                }
                obj = lkField.getTypedValue();
                if (obj == null) {
                    logger.error((Object)"lkField value is NULL");
                    continue;
                }
                String lkValue = (String)obj;
                String fileUri = null;
                if (f == null) continue;
                fileUri = f.getURL() != null ? f.getURL() : "";
                AssetAuxFile aaf = new AssetAuxFile();
                aaf.setFilepath(fileUri);
                aaf.setLookup_key(lkValue);
                aaf.setTtv_file_id(f.getId());
                aai.addAssetFile(aaf);
            }
        }
    }

    private Asset buildOriginAsset(com.tandbergtv.metadatamanager.model.Asset cmsTargetAsset, com.tandbergtv.metadatamanager.model.Asset cmsTitleAsset, String assetFileName) {
        Asset originAsset = new Asset();
        String providerName = BarkerUtils.getCMSFieldValue(cmsTargetAsset, "/tns:Fields/tns:ProviderInfo/tns:Name");
        String publish = BarkerUtils.getCMSFieldValue(cmsTitleAsset, "/tns:Fields/tns:Rights/tns:LicensingWindowStart");
        if (publish != null) {
            publish = publish + "Z";
        }
        String unpublish = BarkerUtils.getCMSFieldValue(cmsTitleAsset, "/tns:Fields/tns:Rights/tns:LicensingWindowEnd");
        logger.debug((Object)("unpublish: " + unpublish));
        if (unpublish != null) {
            unpublish = unpublish + "Z";
        }
        originAsset.setName(assetFileName);
        originAsset.setDescription("");
        originAsset.setProvider(providerName);
        originAsset.setPublish(publish);
        originAsset.setUnpublish(unpublish);
        return originAsset;
    }

    private Playlist buildOriginPlaylist(com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList al, TitleList tl) {
        Playlist pl = new Playlist();
        List alamList = al.getAssetsMap();
        String tlType = tl.getBarkerType();
        String plName = "dflt".equals(tlType) ? OriginUtils.getPlaylistNamePrefixForDefault((TitleList)tl) : OriginUtils.getPlaylistNamePrefix((TitleList)tl);
        pl.setName(plName);
        pl.setDescription(this.buildDescriptionFromTitlelist(tl));
        PlaylistClipList plcl = this.buildOriginPlaylistClipList(alamList);
        String startTime = BarkerUtils.getBarkerTimeValue("Playout Start Time", al);
        String stopTime = BarkerUtils.getBarkerTimeValue("Playout Stop Time", al);
        if (this.isNullOrEmpty(startTime)) {
            startTime = "00:00:00";
        }
        if (this.isNullOrEmpty(stopTime)) {
            stopTime = "23:59:59";
        }
        if ("cont".equals(tlType) || "dflt".equals(tlType)) {
            startTime = "00:00:00";
            stopTime = "23:59:59";
        }
        Calendar startCal = Calendar.getInstance();
        OriginUtils.setTime((Calendar)startCal, (String)startTime);
        Calendar stopCal = Calendar.getInstance();
        OriginUtils.setTime((Calendar)stopCal, (String)stopTime);
        stopCal.add(5, 365);
        pl.setPublish(OriginUtils.formatUTC((Date)startCal.getTime()));
        pl.setUnpublish(OriginUtils.formatUTC((Date)stopCal.getTime()));
        pl.setClips(plcl.getPlaylistClips());
        return pl;
    }

    private boolean isNullOrEmpty(String s) {
        boolean b = false;
        if (s == null || "".equals(s)) {
            b = true;
        }
        return b;
    }

    private PlaylistClipList buildOriginPlaylistClipList(List<AssetListAssetMap> alamList) {
        PlaylistClipList plcList = new PlaylistClipList();
        for (AssetListAssetMap alam : alamList) {
            String packageAssetId = BarkerUtils.getPackageAssetId(BarkerUtils.getCMSTitle(alam));
            AssetListElementMetadata alem = alam.getAssetListElementMetadata("Action");
            PlaylistClip plc = new PlaylistClip();
            plc.setOffset(Float.valueOf(0.0f));
            plc.setLength(Float.valueOf(0.0f));
            plc.setTag(packageAssetId);
            if (alem.getStringValue().equalsIgnoreCase("N")) {
                plc.setTag("NO_ACTION");
            }
            plcList.addPlaylistClip(plc);
        }
        return plcList;
    }

    private Playout buildOriginPlayout(com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList al, TitleList tl) {
        Playout po = new Playout();
        po.setName(OriginUtils.getPlayoutNamePrefix((TitleList)tl));
        po.setDescription(BarkerUtils.getBarkerStringValue(al, "Channel Id"));
        DateTime dt = new DateTime();
        String publishTime = dt.toDateTime(DateTimeZone.UTC).toString();
        String unpublishTime = dt.plusDays(1095).toDateTime(DateTimeZone.UTC).toString();
        po.setPublish(publishTime);
        po.setUnpublish(unpublishTime);
        return po;
    }

    private Schedule buildOriginSchedule(TitleList tl) {
        Schedule sc = new Schedule();
        sc.setName(OriginUtils.getScheduleNamePrefix((TitleList)tl));
        sc.setDescription("Schedule-" + tl.getDescription());
        return sc;
    }

    private PlayoutEventList buildOriginPlayoutEventList(Playout playout, com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList al) {
        PlayoutEventList poeList = new PlayoutEventList();
        String dayStartTime = BarkerUtils.getBarkerTimeValue("Playout Start Time", al);
        String eveningStartTime = BarkerUtils.getBarkerTimeValue("Playout Stop Time", al);
        String startDate = playout.getPublish();
        DateTime dayStartDT = new DateTime((Object)startDate);
        DateTime eveningStartDT = new DateTime((Object)startDate);
        DateTime eveningStopDT = null;
        LocalTime dayStartLT = new LocalTime((Object)dayStartTime);
        LocalTime eveningStartLT = new LocalTime((Object)eveningStartTime);
        dayStartDT = dayStartDT.withTime(dayStartLT.getHourOfDay(), dayStartLT.getMinuteOfHour(), dayStartLT.getSecondOfMinute(), 0);
        eveningStartDT = eveningStartDT.withTime(eveningStartLT.getHourOfDay(), eveningStartLT.getMinuteOfHour(), eveningStartLT.getSecondOfMinute(), 0);
        eveningStopDT = dayStartDT.plusDays(1).toDateTime();
        PlayoutEvent dayPOE = new PlayoutEvent();
        dayPOE.setStart(dayStartDT.toString());
        poeList.addPlayoutEvent(dayPOE);
        PlayoutEvent eveningPOE = new PlayoutEvent();
        eveningPOE.setStart(eveningStartDT.toString());
        eveningPOE.setStop(eveningStopDT.toString());
        poeList.addPlayoutEvent(eveningPOE);
        return poeList;
    }

    private PlayoutEvent buildOriginPlayoutEvent(TitleList tl) {
        PlayoutEvent poe = new PlayoutEvent();
        String barkerType = tl.getBarkerType();
        String alternateType = tl.getAlternatingType();
        String startTime = tl.getStartTime();
        String stopTime = tl.getStopTime();
        if (this.isNullOrEmpty(startTime)) {
            startTime = "00:00:00";
        }
        if (this.isNullOrEmpty(stopTime)) {
            stopTime = "23:59:59";
        }
        if ("cont".equals(barkerType) || "dflt".equals(barkerType)) {
            startTime = "00:00:00";
            stopTime = "23:59:59";
        }
        Calendar startCal = Calendar.getInstance();
        OriginUtils.setTime((Calendar)startCal, (String)startTime);
        Calendar stopCal = Calendar.getInstance();
        if ("evening".equals(alternateType)) {
            stopCal.add(5, 1);
        }
        OriginUtils.setTime((Calendar)stopCal, (String)stopTime);
        String startUTC = OriginUtils.formatUTC((Date)startCal.getTime());
        poe.setStart(startUTC);
        String stopUTC = OriginUtils.formatUTC((Date)stopCal.getTime());
        poe.setStop(stopUTC);
        return poe;
    }

    private String getOriginalFileName(com.tandbergtv.metadatamanager.model.Asset groupAsset, long assetId) {
        logger.debug((Object)("assetId: " + assetId));
        com.tandbergtv.metadatamanager.model.Asset targetAsset = null;
        for (com.tandbergtv.metadatamanager.model.Asset asset : groupAsset.getAllAssets(false)) {
            if (asset.getId() != assetId) continue;
            targetAsset = asset;
            logger.debug((Object)"Found target asset");
            break;
        }
        com.tandbergtv.metadatamanager.model.File targetFile = null;
        List fileList = targetAsset.getDirectDescendantFiles();
        Properties props = BarkerUtils.getProperties();
        String LOOKUP_KEY = props.getProperty("asset.file.lookupkey");
        logger.debug((Object)("Searching for lookup key: " + LOOKUP_KEY));
        if (fileList != null) {
            for (com.tandbergtv.metadatamanager.model.File f : fileList) {
                Field lkField;
                if (f == null || (lkField = f.getFirstField("/tns:Fields/tns:CustomFields/tns:CustomField[@name=LookupKey]/@value")) == null) continue;
                Object lkValue = lkField.getTypedValue();
                if (lkField == null || !lkValue.equals(LOOKUP_KEY)) continue;
                targetFile = f;
                break;
            }
        }
        String fileUri = null;
        String fileName = null;
        if (targetFile != null) {
            String string = fileUri = targetFile.getURL() != null ? targetFile.getURL() : "";
            if (fileUri != null) {
                fileName = this.getFilename(fileUri);
                String fileExtension = this.getExtension(fileUri);
                fileName = fileName + "." + fileExtension;
            }
        } else {
            logger.error((Object)("COULD NOT FIND ELIGIBLE FILE FOR ASSET-ID: " + assetId));
        }
        return fileName;
    }

    private String getFilename(String aFilePath) {
        int extensionIndex = aFilePath.contains(".") ? aFilePath.lastIndexOf(".") : aFilePath.length();
        int filenameIndex = aFilePath.contains(File.separator) ? aFilePath.lastIndexOf(File.separator) : -1;
        return aFilePath.substring(filenameIndex + 1, extensionIndex);
    }

    private String getExtension(String aFilePath) {
        int extensionIndex = aFilePath.lastIndexOf(".");
        String fileName = "";
        if (extensionIndex != -1) {
            fileName = aFilePath.substring(extensionIndex + 1);
        }
        return fileName;
    }

    private String buildDescriptionFromTitlelist(TitleList tl) {
        StringBuilder sb = new StringBuilder();
        String id = tl.getTitleListId();
        String name = tl.getName();
        String channelId = tl.getChannelId();
        String desc = tl.getDescription();
        String barkerType = tl.getBarkerType();
        sb.append("tl-id: ").append(id).append(";");
        sb.append(" tl-type: ").append(barkerType).append(";");
        return sb.toString();
    }

    public static String sanitizeName(String dirty) {
        String clean = dirty;
        clean = clean.replaceAll("\\(", "");
        clean = clean.replaceAll("\\)", "");
        clean = clean.replaceAll(" ", "_");
        return clean;
    }
}

