/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.titlelist.barker;

import com.ericsson.scac.cms.edgeware.model.TitleList;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListAssetMap;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListMetadata;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListManager;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class BarkerUtils {
    private static final Logger logger = Logger.getLogger(BarkerUtils.class);

    public static byte[] getBarkerOverlayValue(String name, AssetList cmsAssetList) {
        byte[] overlayValue = null;
        for (AssetListMetadata alm : cmsAssetList.getListMetadata()) {
            if (!name.equalsIgnoreCase(alm.getName()) || alm.getImageValue() == null) continue;
            overlayValue = alm.getImageValue();
            break;
        }
        return overlayValue;
    }

    public static String getBarkerStringValue(AssetList cmsAssetList, String attribute) {
        String stringValue = null;
        for (AssetListMetadata alm : cmsAssetList.getListMetadata()) {
            String almName = alm.getName();
            if (!attribute.equalsIgnoreCase(almName)) continue;
            if (alm.getStringValue() != null) {
                stringValue = alm.getStringValue();
                break;
            }
            logger.info((Object)(attribute + "-value: is NULL!"));
        }
        return stringValue;
    }

    public static String getBarkerTimeValue(String name, AssetList cmsAssetList) {
        String timeValue = null;
        for (AssetListMetadata alm : cmsAssetList.getListMetadata()) {
            if (!name.equalsIgnoreCase(alm.getName()) || alm.getTimeValue() == null) continue;
            timeValue = alm.getTimeValue();
            break;
        }
        return timeValue;
    }

    public static List<AssetList> getListOfBarkerAssetsList(List<AssetList> list) {
        return BarkerUtils.getListOfBarkerAssetsList(list, null);
    }

    public static List<AssetList> getListOfBarkerAssetsList(List<AssetList> list, Map<String, String> attributes) {
        ArrayList<AssetList> barkerAssetList = null;
        for (AssetList assetList : list) {
            if (!"Barker".equals(assetList.getType())) continue;
            boolean addToAssetList = true;
            for (String attrib : attributes.keySet()) {
                String actualValue = BarkerUtils.getBarkerStringValue(assetList, attrib);
                String expectValue = attributes.get(attrib);
                if (expectValue.equals(actualValue)) continue;
                addToAssetList = false;
            }
            if (!addToAssetList) continue;
            if (barkerAssetList == null) {
                barkerAssetList = new ArrayList<AssetList>();
            }
            barkerAssetList.add(assetList);
        }
        return barkerAssetList;
    }

    public static String getCMSFieldValue(Asset cmsAsset, String xpath) {
        Field cmsField = null;
        String assetValue = null;
        if (cmsAsset != null) {
            cmsField = cmsAsset.getFirstField(xpath);
        }
        if (cmsField != null) {
            assetValue = cmsField.getValue();
        }
        return assetValue;
    }

    public static FileWriter getFileWriter(String filePath) {
        FileWriter outFile = null;
        try {
            outFile = new FileWriter(filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outFile;
    }

    public static IAssetListManager getAssetListManager() throws NamingException {
        return (IAssetListManager)new InitialContext().lookup("cms/AssetListManager/local");
    }

    public static String getPackageAssetId(AssetList cmsTitleList) {
        String packageAssetId = null;
        AssetListAssetMap cmsAssetMap = (AssetListAssetMap)cmsTitleList.getAssetsMap().get(0);
        Asset topLevelAsset = cmsAssetMap.getTitle().getAsset();
        packageAssetId = BarkerUtils.getCMSFieldValue(topLevelAsset, "/tns:Fields/tns:Identifier/tns:Id");
        return packageAssetId;
    }

    public static String getPackageAssetId(Title title) {
        String packageAssetId = null;
        Asset topLevelAsset = title.getAsset();
        packageAssetId = BarkerUtils.getCMSFieldValue(topLevelAsset, "/tns:Fields/tns:Identifier/tns:Id");
        return packageAssetId;
    }

    public static Title getCMSTitle(AssetListAssetMap cmsTitleAssetMap) {
        Title title = cmsTitleAssetMap.getTitle();
        return title;
    }

    public static Asset getTitleAsset(Asset topLevelAsset) {
        Asset titleAsset = null;
        List titleAssetList = topLevelAsset.getAllAssetsOfType("TITLE");
        if (titleAssetList != null && titleAssetList.size() > 0) {
            titleAsset = (Asset)titleAssetList.get(0);
        }
        return titleAsset;
    }

    public static TitleList getTitleList(AssetList al) {
        TitleList tl = new TitleList();
        tl.setName(al.getName());
        tl.setDescription(al.getDescription());
        tl.setTitleListId(String.valueOf(al.getId()));
        tl.setStartTime(BarkerUtils.getBarkerTimeValue("Playout Start Time", al));
        tl.setStopTime(BarkerUtils.getBarkerTimeValue("Playout Stop Time", al));
        tl.setBarkerType(BarkerUtils.getBarkerStringValue(al, "Barker Type"));
        tl.setAlternatingType(BarkerUtils.getBarkerStringValue(al, "Alternating Type"));
        tl.setChannelId(BarkerUtils.getBarkerStringValue(al, "Channel Id"));
        tl.setActive(BarkerUtils.getBarkerStringValue(al, "Active"));
        List alamList = al.getAssetsMap();
        for (AssetListAssetMap alam : alamList) {
            com.ericsson.scac.cms.edgeware.model.Title title = new com.ericsson.scac.cms.edgeware.model.Title();
            Long titleId = alam.getTitle().getId();
            Long assetId = alam.getAssetId();
            if (titleId != null) {
                title.setTitleId(String.valueOf(titleId));
            }
            if (assetId != null) {
                title.setAssetId(String.valueOf(assetId));
            }
            tl.addTitle(title);
        }
        return tl;
    }

    public static Properties getProperties() {
        FileInputStream stream;
        Properties properties = new Properties();
        try {
            stream = new FileInputStream(new File("/opt/tandbergtv/cms/conf/scac-ta-plugin-barker/barker.properties"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot load config file: /opt/tandbergtv/cms/conf/scac-ta-plugin-barker/barker.properties");
        }
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static String getAssetId(Asset as) {
        Field field = as.getField("/tns:Fields/tns:Identifier/tns:Id");
        String assetId = null;
        if (field != null) {
            assetId = field.getValue();
        }
        return assetId;
    }

    public static void setTimeToEndOfDay(Calendar cal) {
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
    }

    public static String formatDateTime(Date date) {
        String formatted = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        formatted = df.format(date);
        return formatted;
    }

    public static Date parseDateTime(String s) throws ParseException {
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        date = df.parse(s);
        return date;
    }
}

