/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.titlelist.barker;

import com.ericsson.cms.titlelist.barker.BarkerUtils;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListAssetMap;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListElementMetadata;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListMetadata;
import com.tandbergtv.cms.contentmgmt.titlelist.service.AssetListErrorCode;
import com.tandbergtv.cms.contentmgmt.titlelist.service.AssetListValidationException;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListValidator;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class BarkerValidator
implements IAssetListValidator {
    private static final Logger logger = Logger.getLogger(BarkerValidator.class);

    public void validateAssetList(AssetList al) throws AssetListValidationException {
        logger.info((Object)("called for AssetList: " + al.getId() + ", " + al.getName()));
        AssetListValidationException descriptionException = new AssetListValidationException();
        this.validateBarkerAssetList(descriptionException, al);
        this.checkDescriptionSize(descriptionException, al);
        for (AssetListAssetMap assetMap : al.getAssetsMap()) {
            List alemList = assetMap.getListElementMetadata();
            for (AssetListElementMetadata alem : alemList) {
                String value = alem.getStringValue().trim();
                if (!alem.getName().equalsIgnoreCase("Action") || value.equalsIgnoreCase("Y") || value.equalsIgnoreCase("N")) continue;
                AssetListValidationException exception = new AssetListValidationException();
                logger.info((Object)"NOT A VALID ACTION");
                exception.add(AssetListErrorCode.INVALID_ASSET_TYPE);
                if (exception.getCodes().size() <= 0) continue;
                throw exception;
            }
            this.checkAsset(assetMap.getTitle(), assetMap.getAssetId(), al);
        }
    }

    public void validateAssetToAdd(Title title, long assetId, AssetList al) throws AssetListValidationException {
        logger.info((Object)("called for Title: " + title.getId() + ", AssetId: " + assetId + ", AssetList: " + al.getId() + ", " + al.getName()));
        AssetListValidationException exception = new AssetListValidationException();
        this.checkAssetType(exception, title, assetId);
        Properties props = BarkerUtils.getProperties();
        Boolean checkForExpired = Boolean.parseBoolean(props.getProperty("validator.prohibit.expired.assets"));
        if (checkForExpired.booleanValue()) {
            this.checkLicensingDate(exception, title, al);
        }
        this.checkContentClass(exception, title, al);
        this.checkUserAccesToTitle(exception, title);
        if (exception.getCodes().size() > 0) {
            throw exception;
        }
    }

    private void checkAsset(Title title, long assetId, AssetList al) throws AssetListValidationException {
        logger.debug((Object)"called");
        AssetListValidationException exception = new AssetListValidationException();
        this.checkAssetType(exception, title, assetId);
        Properties props = BarkerUtils.getProperties();
        Boolean checkForExpired = Boolean.parseBoolean(props.getProperty("validator.prohibit.expired.assets"));
        if (checkForExpired.booleanValue()) {
            this.checkLicensingDate(exception, title, al);
        }
        this.checkContentClass(exception, title, al);
        if (exception.getCodes().size() > 0) {
            throw exception;
        }
    }

    private void validateBarkerAssetList(AssetListValidationException exception, AssetList al) throws AssetListValidationException {
        logger.debug((Object)"called");
        if (al == null) {
            return;
        }
        long barkerIdAsset = al.getId();
        String barkerChannelIdAsset = this.getAssetString(al, "Channel Id", exception);
        String barkerTypeAsset = this.getAssetString(al, "Barker Type", exception);
        String barkerAltTypeAsset = this.getAssetString(al, "Alternating Type", exception);
        String barkerActiveAsset = this.getAssetString(al, "Active", exception);
        if ("dflt".equals(barkerTypeAsset)) {
            if (!"na".equals(barkerAltTypeAsset)) {
                throw new AssetListValidationException("The Alternating Type field value 'NA' is expected for this type of barker playlist.");
            }
            if (!"T".equals(barkerAltTypeAsset)) {
                this.setAssetString(al, "Active", "T", exception);
            }
        }
        if ("cont".equals(barkerTypeAsset) && !"na".equals(barkerAltTypeAsset)) {
            throw new AssetListValidationException("The Alternating Type field value 'NA' is expected for this type of barker playlist.");
        }
        if ("altr".equals(barkerTypeAsset) && !"day".equals(barkerAltTypeAsset) && !"evening".equals(barkerAltTypeAsset)) {
            throw new AssetListValidationException("The Alternating Type field value 'DAY' or 'EVENING' is expected for this type of barker playlist.");
        }
        List listOfAssetsList = null;
        try {
            listOfAssetsList = BarkerUtils.getAssetListManager().getAllAssetLists();
        }
        catch (NamingException e) {
            logger.error((Object)e);
        }
        if (listOfAssetsList != null && !listOfAssetsList.isEmpty()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Channel Id", barkerChannelIdAsset);
            List<AssetList> listOfBkrAssetsListForChannel = BarkerUtils.getListOfBarkerAssetsList(listOfAssetsList, map);
            if (listOfBkrAssetsListForChannel != null && !listOfBkrAssetsListForChannel.isEmpty()) {
                String stopTime;
                String startTime;
                AssetList lContinuousAssetList = null;
                AssetList lAlternateDayAssetList = null;
                AssetList lAlternateEveningAssetList = null;
                AssetList lActiveAssetList = null;
                for (AssetList assetsList : listOfBkrAssetsListForChannel) {
                    long lIdAsset = assetsList.getId();
                    String lTypeAsset = this.getAssetString(assetsList, "Barker Type", exception);
                    String lAltTypeAsset = this.getAssetString(assetsList, "Alternating Type", exception);
                    String lActiveAsset = this.getAssetString(assetsList, "Active", exception);
                    if (barkerIdAsset != lIdAsset) {
                        if (barkerTypeAsset.equals(lTypeAsset) && barkerAltTypeAsset.equals(lAltTypeAsset)) {
                            exception.add(AssetListErrorCode.DUPLICATE_TITLE_TYPE);
                            throw exception;
                        }
                        if ("altr".equals(lTypeAsset)) {
                            if ("day".equals(lAltTypeAsset)) {
                                lAlternateDayAssetList = assetsList;
                            }
                            if ("evening".equals(lAltTypeAsset)) {
                                lAlternateEveningAssetList = assetsList;
                            }
                        }
                        if ("cont".equals(lTypeAsset)) {
                            lContinuousAssetList = assetsList;
                        }
                    }
                    if (!"T".equals(lActiveAsset)) continue;
                    lActiveAssetList = assetsList;
                }
                if ("altr".equals(barkerTypeAsset)) {
                    if ("day".equals(barkerAltTypeAsset)) {
                        if (lAlternateDayAssetList == null) {
                            lAlternateDayAssetList = al;
                        } else {
                            exception.add(AssetListErrorCode.INVALID_ASSET_TYPE);
                            throw exception;
                        }
                    }
                    if ("evening".equals(barkerAltTypeAsset)) {
                        if (lAlternateEveningAssetList == null) {
                            lAlternateEveningAssetList = al;
                        } else {
                            exception.add(AssetListErrorCode.INVALID_ASSET_TYPE);
                            throw exception;
                        }
                    }
                }
                if ("altr".equals(barkerTypeAsset)) {
                    if (lAlternateDayAssetList != null && lAlternateEveningAssetList != null) {
                        if (lContinuousAssetList != null) {
                            if ("T".equals(barkerActiveAsset)) {
                                this.setAssetString(lContinuousAssetList, "Active", "F", exception);
                            } else if ("F".equals(this.getAssetString(lContinuousAssetList, "Active", exception))) {
                                throw new AssetListValidationException("This playlist must be active.");
                            }
                        }
                        if ("T".equals(barkerActiveAsset)) {
                            lActiveAssetList = al;
                        }
                        if ("F".equals(barkerActiveAsset) && "altr".equals(this.getAssetString(lActiveAssetList, "Barker Type", exception))) {
                            throw new AssetListValidationException("This playlist must be active.");
                        }
                        this.setAssetString(lAlternateDayAssetList, "Active", barkerActiveAsset, exception);
                        this.setAssetString(lAlternateEveningAssetList, "Active", barkerActiveAsset, exception);
                    } else if ("T".equals(barkerActiveAsset)) {
                        if (lAlternateDayAssetList == null) {
                            throw new AssetListValidationException("The Alternating Day barker does not exist. This playlist cannot be activated.  Please set the Active field to No and save this list.  Then create a corresponding (that is, having the same Channel ID) Day list with Active set to Yes.  Upon successful creation of an Day list, this Evening list will automatically become active.");
                        }
                        if (lAlternateEveningAssetList == null) {
                            throw new AssetListValidationException("The Alternating Evening barker does not exist. This playlist cannot be activated.  Please set the Active field to No and save this list.  Then create a corresponding (that is, having the same Channel ID) Evening list with Active set to Yes.  Upon successful creation of an Evening list, this Day list will automatically become active.");
                        }
                        throw exception;
                    }
                }
                if ("cont".equals(barkerTypeAsset)) {
                    if ("T".equals(barkerActiveAsset)) {
                        lActiveAssetList = al;
                        if (lAlternateDayAssetList != null) {
                            this.setAssetString(lAlternateDayAssetList, "Active", "F", exception);
                        }
                        if (lAlternateEveningAssetList != null) {
                            this.setAssetString(lAlternateEveningAssetList, "Active", "F", exception);
                        }
                    } else if (al.equals((Object)lActiveAssetList) || lAlternateDayAssetList != null && lAlternateEveningAssetList != null && "F".equals(this.getAssetString(lAlternateDayAssetList, "Active", exception))) {
                        throw new AssetListValidationException("This playlist must be active.");
                    }
                }
                if (lAlternateEveningAssetList != null && "altr".equals(barkerTypeAsset) && "day".equals(barkerAltTypeAsset)) {
                    startTime = this.getAssetTimeString(al, "Playout Start Time", exception);
                    stopTime = this.getAssetTimeString(al, "Playout Stop Time", exception);
                    this.setAssetTimeString(lAlternateEveningAssetList, "Playout Start Time", stopTime, exception);
                    this.setAssetTimeString(lAlternateEveningAssetList, "Playout Stop Time", startTime, exception);
                }
                if (lAlternateDayAssetList != null && "altr".equals(barkerTypeAsset) && "evening".equals(barkerAltTypeAsset)) {
                    startTime = this.getAssetTimeString(lAlternateDayAssetList, "Playout Start Time", exception);
                    stopTime = this.getAssetTimeString(lAlternateDayAssetList, "Playout Stop Time", exception);
                    this.setAssetTimeString(al, "Playout Start Time", stopTime, exception);
                    this.setAssetTimeString(al, "Playout Stop Time", startTime, exception);
                }
            }
        }
    }

    private void setAssetTimeString(AssetList al, String name, String value, AssetListValidationException exception) {
        AssetListMetadata metadata = this.getAssetListMetadata(al, name, exception);
        if (metadata != null) {
            metadata.setTimeValue(value);
        }
    }

    private String getAssetTimeString(AssetList al, String name, AssetListValidationException exception) {
        String value = null;
        AssetListMetadata metadata = this.getAssetListMetadata(al, name, exception);
        if (metadata != null) {
            value = metadata.getTimeValue();
        }
        return value;
    }

    private void setAssetString(AssetList al, String name, String value, AssetListValidationException exception) {
        AssetListMetadata metadata = this.getAssetListMetadata(al, name, exception);
        if (metadata != null) {
            metadata.setStringValue(value);
        }
    }

    private String getAssetString(AssetList al, String name, AssetListValidationException exception) {
        String value = null;
        AssetListMetadata metadata = this.getAssetListMetadata(al, name, exception);
        if (metadata != null) {
            value = metadata.getStringValue();
        }
        return value;
    }

    private AssetListMetadata getAssetListMetadata(AssetList al, String name, AssetListValidationException exception) {
        AssetListMetadata metadata = null;
        if (al != null && name != null && (metadata = al.getAssetListMetadata(name)) == null) {
            exception.add(AssetListErrorCode.MISSING_ASSETLIST_FIELD);
        }
        return metadata;
    }

    private void checkDescriptionSize(AssetListValidationException exception, AssetList al) throws AssetListValidationException {
        logger.debug((Object)"called");
        if (al.getDescription() != null && al.getDescription().length() > 100) {
            exception.add(AssetListErrorCode.MAX_DESCRIPTION_LENGTH_EXCEEDED);
            throw exception;
        }
    }

    private void checkUserAccesToTitle(AssetListValidationException exception, Title title) {
        logger.info((Object)"called");
        IPartnerUserManager partnerUserManager = (IPartnerUserManager)InjectionUtil.injectInstance((String)"PartnerServices/PartnerUserManager", IPartnerUserManager.class);
        if (!partnerUserManager.isSelfPartnerUser()) {
            boolean hasAccess = false;
            for (Partner partner : partnerUserManager.getPartnersByCurrentUser()) {
                if (partner.getId() != title.getPartnerId().longValue()) continue;
                hasAccess = true;
                break;
            }
            if (!hasAccess) {
                exception.add(AssetListErrorCode.ACCESS_TITLE_DENIED);
            }
        }
    }

    private void checkContentClass(AssetListValidationException exception, Title title, AssetList al) {
        if (al.getContentClass() != null && !title.getContentClassId().equals(al.getContentClass())) {
            exception.add(AssetListErrorCode.INVALID_CONTENT_CLASS);
        }
    }

    private Field getAssetField(String fieldName, Asset asset, AssetListValidationException exception) {
        Field field = null;
        field = asset.getFirstField(fieldName);
        if (field == null) {
            exception.add(AssetListErrorCode.MISSING_ASSET_FIELD);
        }
        return field;
    }

    private void checkLicensingDate(AssetListValidationException exception, Title title, AssetList al) {
        logger.debug((Object)"called");
        List titleAssets = title.getAsset().getAllAssetsOfType("TITLE");
        if (titleAssets.size() > 1) {
            exception.add(AssetListErrorCode.DUPLICATE_TITLE_TYPE);
        }
        if (titleAssets.size() == 0) {
            exception.add(AssetListErrorCode.MISSING_TITLE_TYPE);
        }
        if (titleAssets.size() == 1) {
            Asset asset = (Asset)titleAssets.get(0);
            Field startField = this.getAssetField("/tns:Fields/tns:Rights/tns:LicensingWindowStart", asset, exception);
            Field stopField = this.getAssetField("/tns:Fields/tns:Rights/tns:LicensingWindowEnd", asset, exception);
            Date startDate = null;
            if (startField != null) {
                startDate = (Date)startField.getTypedValue();
            }
            Date stopDate = null;
            if (stopField != null) {
                stopDate = (Date)stopField.getTypedValue();
                stopDate = this.checkTime(stopDate);
            }
            logger.debug((Object)("Adding title with Licensing Start at " + startDate + " and Licensing End at " + stopDate));
            if (startDate != null & stopDate != null & stopDate.compareTo(Calendar.getInstance().getTime()) < 0) {
                logger.error((Object)("Title " + title.getId() + " licensing window end is expired."));
                exception.add(AssetListErrorCode.INVALID_LICENSE_WINDOW);
                return;
            }
            logger.debug((Object)("Title validated: " + title.getId()));
        }
    }

    private Date checkTime(Date date) {
        Calendar newDate = Calendar.getInstance();
        newDate.setTime(date);
        int hour = newDate.get(10);
        int minute = newDate.get(12);
        int second = newDate.get(13);
        if (hour == 0 && minute == 0 && second == 0) {
            newDate.set(10, 23);
            newDate.set(12, 59);
            newDate.set(13, 59);
        }
        return newDate.getTime();
    }

    private Date setTimeInfo(Date date, String time) {
        String[] splitedTime = time.split(":");
        int hour = Integer.parseInt(splitedTime[0]);
        int minute = Integer.parseInt(splitedTime[1]);
        int second = Integer.parseInt(splitedTime[2]);
        Calendar newDate = Calendar.getInstance();
        newDate.setTime(date);
        newDate.set(10, hour);
        newDate.set(12, minute);
        newDate.set(13, second);
        return newDate.getTime();
    }

    private void checkAssetType(AssetListValidationException exception, Title title, long assetId) {
        logger.debug((Object)("called for Title: " + title.getId() + ", Asset: " + assetId));
        Asset asset = this.getAssetById(title, assetId);
        String assetType = asset.getAssetType();
        if (!assetType.equals("PREVIEW") && !assetType.equals("MOVIE")) {
            logger.error((Object)"Operator tried to add an invalid Asset type ");
            exception.add(AssetListErrorCode.INVALID_ASSET_TYPE);
        } else {
            logger.debug((Object)("Adding title asset type: " + asset.getAssetType()));
        }
    }

    private Asset getAssetById(Title title, long assetId) {
        Asset assetResult = null;
        for (Asset asset : title.getAllAssets(false)) {
            if (asset.getId() != assetId) continue;
            assetResult = asset;
            break;
        }
        return assetResult;
    }
}

