/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.config;

import com.tandbergtv.workflow.adaptor.config.MessageConfig;
import com.tandbergtv.workflow.adaptor.config.ParamConfig;
import com.tandbergtv.workflow.adaptor.config.ParamType;
import com.tandbergtv.workflow.adaptor.config.ProgressbarConfig;
import com.tandbergtv.workflow.adaptor.config.ProgressbarType;
import com.tandbergtv.workflow.adaptor.config.ProgressbarValueConfig;
import com.tandbergtv.workflow.adaptor.config.ResponseConfig;
import com.tandbergtv.workflow.adaptor.config.SimulatorConfig;
import com.tandbergtv.workflow.message.util.MarshalException;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Unmarshaller {
    private static final String MESSAGE_NODE = "message";
    private static final String MESSAGE_UID = "uid";
    private static final String MESSAGE_ASYNC = "async";
    private static final String MESSAGE_ASYNC_SLEEP_INTERVAL = "asyncsleep";
    private static final String MESSAGE_TOKEN = "token";
    private static final String RESPONSE_NODE = "response";
    private static final String PROGRESSBAR_NODE = "progressbar";
    private static final String PARAM_NODE = "param";
    private static final String PGBAR_NODE = "pgbar";
    private static final String ATTRIB_NAME = "name";
    private static final String ATTRIB_TYPE = "type";
    private static final String ATTRIB_REQUIRED = "required";
    private static final String ATTRIB_VALUE = "value";
    private static final String ATTRIB_SEQUENCE = "sequence";
    private static final String ATTRIB_SLEEP_INTERVAL = "sleep";
    private static Logger logger = Logger.getLogger(Unmarshaller.class.getName());

    public static SimulatorConfig unmarshal(Document document) throws MarshalException {
        SimulatorConfig sConfig = new SimulatorConfig();
        try {
            document.getDocumentElement().normalize();
            NodeList messages = document.getElementsByTagName(MESSAGE_NODE);
            for (int i = 0; i < messages.getLength(); ++i) {
                Node messageNode = messages.item(i);
                MessageConfig mc = Unmarshaller.unmarshalMessageNode(messageNode);
                if (mc == null) continue;
                sConfig.addMessageConfig(mc);
            }
        }
        catch (Exception e) {
            throw new MarshalException("Failed to unmarshal the document", (Throwable)e);
        }
        return sConfig;
    }

    private static MessageConfig unmarshalMessageNode(Node messageNode) {
        int j;
        Element mElm = (Element)messageNode;
        String uid = mElm.getAttribute(MESSAGE_UID);
        if (uid == null || uid.trim().length() == 0) {
            logger.warning("Invalid message uid " + uid);
            return null;
        }
        MessageConfig mc = new MessageConfig(uid);
        mc.setAsync(Boolean.valueOf(mElm.getAttribute(MESSAGE_ASYNC)));
        mc.setToken(mElm.getAttribute(MESSAGE_TOKEN));
        try {
            mc.setSleep(Integer.parseInt(mElm.getAttribute(ATTRIB_SLEEP_INTERVAL)));
        }
        catch (NumberFormatException nfe) {
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            mc.setAsyncsleep(Integer.parseInt(mElm.getAttribute(MESSAGE_ASYNC_SLEEP_INTERVAL)));
        }
        catch (NumberFormatException nfe) {
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        NodeList msgCfgs = mElm.getElementsByTagName(RESPONSE_NODE);
        for (j = 0; j < msgCfgs.getLength(); ++j) {
            Unmarshaller.readResponseConfig(mc, msgCfgs.item(j));
        }
        msgCfgs = mElm.getElementsByTagName(PROGRESSBAR_NODE);
        for (j = 0; j < msgCfgs.getLength(); ++j) {
            Unmarshaller.readProgressbarConfig(mc, msgCfgs.item(j));
        }
        return mc;
    }

    private static ParamConfig readParameter(Node paramNode) {
        Element elm = (Element)paramNode;
        ParamConfig retVal = new ParamConfig(elm.getAttribute(ATTRIB_NAME));
        retVal.setRequired(Boolean.getBoolean(elm.getAttribute(ATTRIB_REQUIRED)));
        retVal.setType(ParamType.valueOf(elm.getAttribute(ATTRIB_TYPE).toUpperCase()));
        retVal.setValue(elm.getAttribute(ATTRIB_VALUE));
        return retVal;
    }

    private static void readResponseConfig(MessageConfig mc, Node node) {
        ResponseConfig respConfig = new ResponseConfig();
        Element elm = (Element)node;
        NodeList paramNodeList = elm.getElementsByTagName(PARAM_NODE);
        for (int i = 0; i < paramNodeList.getLength(); ++i) {
            respConfig.addParameter(Unmarshaller.readParameter(paramNodeList.item(i)));
        }
        mc.setResponseConfig(respConfig);
    }

    private static void readProgressbarConfig(MessageConfig mc, Node node) {
        Element elm = (Element)node;
        ProgressbarConfig pgbConfig = new ProgressbarConfig(elm.getAttribute(ATTRIB_NAME));
        String type = elm.getAttribute(ATTRIB_TYPE);
        if (type != null && type.trim().length() > 0) {
            pgbConfig.setType(ProgressbarType.valueOf(type.toUpperCase()));
        }
        NodeList pgBarConfigs = elm.getElementsByTagName(PGBAR_NODE);
        for (int i = 0; i < pgBarConfigs.getLength(); ++i) {
            pgbConfig.addProgressbarValue(Unmarshaller.readProgressbarValueConfig(pgBarConfigs.item(i)));
        }
        mc.addProgressbars(pgbConfig);
    }

    private static ProgressbarValueConfig readProgressbarValueConfig(Node pgbValueNode) {
        Element elm = (Element)pgbValueNode;
        ProgressbarValueConfig retVal = new ProgressbarValueConfig(elm.getAttribute(ATTRIB_VALUE), Integer.parseInt(elm.getAttribute(ATTRIB_SEQUENCE)));
        String sleep = elm.getAttribute(ATTRIB_SLEEP_INTERVAL);
        if (sleep != null && sleep.trim().length() > 0) {
            try {
                retVal.setSleep(Integer.parseInt(sleep));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return retVal;
    }
}

