/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.contentmgmt.titlelist.plugins.basic;

import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListAssetMap;
import com.tandbergtv.cms.contentmgmt.titlelist.plugins.basic.AssetListBasicMarshaller;
import com.tandbergtv.cms.contentmgmt.titlelist.plugins.basic.AssetListConverterRecord;
import com.tandbergtv.cms.contentmgmt.titlelist.service.AssetListExporterException;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListExporter;
import com.tandbergtv.metadatamanager.util.Binder;
import com.tandbergtv.watchpoint.pmm.util.XMLDocumentUtility;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BasicExporter
implements IAssetListExporter {
    public String export(AssetList assetList, String dirPath) throws AssetListExporterException {
        Binder binder = new Binder();
        ArrayList<String> assetsTtvRepresentation = new ArrayList<String>();
        for (AssetListAssetMap assetMap : assetList.getAssetsMap()) {
            Node n;
            int i;
            Document doc = binder.bind(assetMap.getTitle().getAsset());
            NodeList itemNl = doc.getElementsByTagName("tns:Item");
            NodeList groupNl = doc.getElementsByTagName("tns:Group");
            Node theOne = null;
            boolean skip = false;
            for (i = 0; i < itemNl.getLength(); ++i) {
                n = itemNl.item(i);
                if (!this.isThisTheAsset(assetMap.getAssetId(), n)) continue;
                theOne = n;
                skip = true;
                break;
            }
            if (!skip) {
                for (i = 0; i < groupNl.getLength(); ++i) {
                    n = groupNl.item(i);
                    if (!this.isThisTheAsset(assetMap.getAssetId(), n)) continue;
                    theOne = n;
                    break;
                }
            }
            String stringTtvRepresentation = null;
            try {
                stringTtvRepresentation = XMLDocumentUtility.convertToString(theOne);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            assetsTtvRepresentation.add(stringTtvRepresentation);
        }
        AssetListConverterRecord converterRecord = new AssetListConverterRecord(assetList, assetsTtvRepresentation);
        AssetListBasicMarshaller<AssetListConverterRecord> marshaller = new AssetListBasicMarshaller<AssetListConverterRecord>();
        Document result = (Document)marshaller.marshal(converterRecord);
        NodeList nodes = result.getElementsByTagName("asset");
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        int assetsCounter = nodes.getLength();
        for (int i = 0; i < assetsCounter; ++i) {
            String content = (String)assetsTtvRepresentation.get(i);
            ByteArrayInputStream inputAssetTtvRepresentation = new ByteArrayInputStream(content.getBytes());
            try {
                Document asset = builder.parse(inputAssetTtvRepresentation);
                Node assetNode = result.adoptNode(asset.getFirstChild());
                Node assetsNode = result.getElementsByTagName("assets").item(0);
                assetsNode.getChildNodes().item(i).setTextContent("");
                assetsNode.getChildNodes().item(i).appendChild(assetNode);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String filePath = this.generateFilePath(assetList.getId(), dirPath);
        try {
            XMLDocumentUtility.save((Document)result, (String)filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filePath;
    }

    private boolean isThisTheAsset(long assetId, Node n) {
        try {
            Node ttvidNode;
            Node fieldsNode = n.getChildNodes().item(0);
            NodeList children = fieldsNode.getChildNodes();
            for (int i = 0; i < children.getLength() && (ttvidNode = children.item(i)) != null; ++i) {
                if (ttvidNode.getNodeName() != "tns:TTVId") continue;
                String id = ttvidNode.getFirstChild().getTextContent().trim();
                return assetId == Long.parseLong(id);
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private String generateFilePath(long id, String folderPath) {
        String EXPORT_FILENAME_PREFIX = "TitleList";
        String EXPORT_FILENAME_DELIMITER = "_";
        String EXPORT_FILENAME_EXTEN = ".xml";
        String fileName = EXPORT_FILENAME_PREFIX + EXPORT_FILENAME_DELIMITER + id + EXPORT_FILENAME_DELIMITER + Calendar.getInstance().getTimeInMillis() + EXPORT_FILENAME_EXTEN;
        File f = new File(folderPath, fileName);
        return f.getAbsolutePath();
    }
}

