/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring.common;

import com.ericsson.cms.sites.monitoring.common.IExecutableTask;
import java.util.Date;

public class SingleTaskTimer<T extends IExecutableTask>
extends Thread {
    private T task;
    private long interval;
    private boolean stopThread = false;

    public SingleTaskTimer(long interval, T task) {
        this.task = task;
        this.interval = interval;
    }

    public T getTask() {
        return this.task;
    }

    public void cancel() {
        this.stopThread = true;
    }

    @Override
    public void run() {
        while (!this.stopThread && this.task != null) {
            long startTime = new Date().getTime();
            long nextTime = startTime + this.interval;
            this.task.execute();
            long currentTime = new Date().getTime();
            long diff = nextTime - currentTime;
            if (diff <= 0L) continue;
            try {
                SingleTaskTimer.sleep(diff);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

