/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring.config;

import com.ericsson.cms.sites.monitoring.config.ConfigurationException;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.axis.utils.StringUtils;

public class ConfigUtils {
    public static final String VALID_POSITIVE_NUMBER_FORMAT = "^(0)|([1-9]\\d*)$";
    public static final Pattern VALID_POSITIVE_NUMBER_PATTERN = Pattern.compile("^(0)|([1-9]\\d*)$");

    public static long parseLong(String value) throws ConfigurationException {
        if (!VALID_POSITIVE_NUMBER_PATTERN.matcher(value).matches()) {
            String msg = String.format("The value '%s' is is not a valid Long", value);
            throw new ConfigurationException(msg);
        }
        return StringUtils.isEmpty((String)value) ? 0L : Long.parseLong(value);
    }

    public static int parseInt(String value) throws ConfigurationException {
        if (!VALID_POSITIVE_NUMBER_PATTERN.matcher(value).matches()) {
            String msg = String.format("The value '%s' is is not a valid Integer", value);
            throw new ConfigurationException(msg);
        }
        return StringUtils.isEmpty((String)value) ? 0 : Integer.parseInt(value);
    }

    public static void validatePropertyNotEmpty(Properties properties, String key) throws ConfigurationException {
        String value = properties.getProperty(key);
        if (StringUtils.isEmpty((String)value)) {
            String msg = String.format("Property: %s is empty", key);
            throw new ConfigurationException(msg);
        }
    }
}

