/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring.deployment;

import com.ericsson.cms.sites.core.entities.TrackingStatus;
import com.ericsson.cms.sites.monitoring.common.IAssetStatusBean;
import com.ericsson.cms.sites.monitoring.common.IStatusListener;
import com.ericsson.cms.sites.monitoring.common.IStatusQueryThread;
import com.ericsson.cms.sites.monitoring.common.SingleTaskTimer;
import com.ericsson.cms.sites.monitoring.config.ConfigurationException;
import com.ericsson.cms.sites.monitoring.config.ConfigurationManager;
import com.ericsson.cms.sites.monitoring.config.IPluginConfigurationParser;
import com.ericsson.cms.sites.monitoring.config.IStatusPluginConfiguration;
import com.ericsson.cms.sites.monitoring.deployment.DeploymentAssetStatusBean;
import com.ericsson.cms.sites.monitoring.plugins.StatusPluginBase;
import com.ericsson.cms.sites.monitoring.plugins.StatusPluginType;
import com.ericsson.cms.sites.monitoring.plugins.deplstatusplugin.IDeploymentStatusPlugin;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;
import org.java.plugin.registry.PluginDescriptor;

public abstract class DeploymentStatusPluginBase
extends StatusPluginBase
implements IStatusListener,
IDeploymentStatusPlugin {
    private static final Logger logger = Logger.getLogger((String)DeploymentStatusPluginBase.class.getName());
    private static final String TITLE_STATUS_QUEUE = "queue/TitleStatusQueue";
    private static final int MAX_ITEMS_PER_MESSAGE = 10;
    public ConfigurationManager<IStatusPluginConfiguration> configurationManager = null;
    protected IPluginConfigurationParser<IStatusPluginConfiguration> configParser = null;
    protected Map<String, Map<String, String>> multiConfiguration = new HashMap<String, Map<String, String>>();
    protected Map<String, IStatusPluginConfiguration> configMap;
    protected Map<String, SingleTaskTimer<IStatusQueryThread>> timerMap = new HashMap<String, SingleTaskTimer<IStatusQueryThread>>();
    protected File configDirectory = null;
    protected StatusPluginType pluginType = StatusPluginType.DEPLOYMENT_STATUS;
    protected String name;
    protected File tempDirectory;
    private Date lastAppStartTime;
    protected boolean started = false;
    protected boolean loaded;

    public TrackingStatus mapStatus(String scomStatus) {
        String status = scomStatus.toUpperCase();
        return TrackingStatus.valueOf((String)status);
    }

    protected static Map<String, Map<String, String>> translateConfig(Map<String, IStatusPluginConfiguration> sourceMap) {
        HashMap<String, Map<String, String>> translatedMap = new HashMap<String, Map<String, String>>();
        for (String key : sourceMap.keySet()) {
            IStatusPluginConfiguration config = sourceMap.get(key);
            HashMap<String, String> configProperties = new HashMap<String, String>();
            configProperties.put("Display Name", config.getConfigurationDisplayName());
            configProperties.put("Configuration ID", config.getConfigurationId());
            configProperties.put("Asset Status Data Path", config.getEndpointUrl());
            configProperties.put("Polling Interval", Long.toString(config.getPollInterval()));
            translatedMap.put(config.getConfigurationId(), configProperties);
        }
        return translatedMap;
    }

    public Map<String, Map<String, String>> getMultiConfiguration() {
        try {
            Map<String, IStatusPluginConfiguration> newConfigurationsMap = this.configurationManager.configure(this.configDirectory, this.configParser);
            if (newConfigurationsMap.size() > 0) {
                logger.info((Object)"New Configurations Added");
            }
            this.multiConfiguration.putAll(DeploymentStatusPluginBase.translateConfig(newConfigurationsMap));
            this.startTimers(newConfigurationsMap);
        }
        catch (ConfigurationException e) {
            logger.error((Object)"Exception while reading the configuration file", (Throwable)e);
        }
        return this.multiConfiguration;
    }

    protected void locateHomeDirectories(ClassLoader loader, PluginDescriptor desc) throws URISyntaxException {
        if (desc != null && desc.getLocation() != null) {
            URL pluginRootDirUrl = desc.getLocation();
            File pluginXml = new File(pluginRootDirUrl.toURI());
            File pluginRootDir = pluginXml.getParentFile();
            logger.info((Object)String.format("Plugin Root directory set to: %s", pluginRootDir.getPath()));
            this.configDirectory = new File(pluginRootDir, "config");
            logger.info((Object)String.format("Plugin Config directory set to: %s", this.configDirectory.getPath()));
            this.tempDirectory = new File(pluginRootDir, "temp");
            this.setId(desc.getId());
            this.name = desc.getAttribute("name").getValue();
        } else {
            URL pluginRootDirUrl = loader.getResource("com/ericsson/cms/sites/monitoring/deployment/scom");
            URL configDirUrl = loader.getResource("com/ericsson/cms/sites/monitoring/deployment/scom/config");
            File pluginRootDir = new File(pluginRootDirUrl.toURI());
            logger.info((Object)String.format("Plugin Root directory set to: %s", pluginRootDir.getPath()));
            this.configDirectory = new File(configDirUrl.toURI());
            logger.info((Object)String.format("Plugin Config directory set to: %s", this.configDirectory.getPath()));
            this.tempDirectory = new File(pluginRootDir, "temp");
        }
    }

    protected synchronized void stopAllTimers() {
        for (Map.Entry<String, SingleTaskTimer<IStatusQueryThread>> e : this.timerMap.entrySet()) {
            String id = e.getKey();
            SingleTaskTimer<IStatusQueryThread> timer = e.getValue();
            timer.cancel();
            try {
                timer.join();
            }
            catch (InterruptedException ie) {
                logger.error((Object)"in _stop()", (Throwable)ie);
            }
        }
        logger.info((Object)"All timer threads stopped");
    }

    protected abstract void startTimers(Map<String, IStatusPluginConfiguration> var1);

    public void setMultiConfiguration(Map<String, Map<String, String>> multiConfiguration) {
        this.multiConfiguration = multiConfiguration;
    }

    public StatusPluginType getPluginType() {
        return this.pluginType;
    }

    public void start() {
        this._start();
    }

    public void stop() {
        this._stop();
    }

    protected synchronized void _stop() {
        if (!this.started) {
            logger.warn((Object)"In ScomStatusPlugin Already stopped");
            return;
        }
        this.stopAllTimers();
        this.started = false;
    }

    public void startMonitoring(String configId, Collection<String> externalIds) {
        SingleTaskTimer<IStatusQueryThread> timer = this.timerMap.get(configId);
        if (timer != null) {
            timer.getTask().getExternalIds().addAll(externalIds);
        } else {
            logger.warn((Object)("Could not start monitoring configId: " + configId));
        }
    }

    public void stopMonitoring(String configId, Collection<String> externalIds, boolean dissociatedFlag) {
        SingleTaskTimer<IStatusQueryThread> timer = this.timerMap.get(configId);
        if (timer != null && dissociatedFlag) {
            timer.getTask().getExternalIds().removeAll(externalIds);
        }
    }

    public void synchronize(String configId, Collection<String> externalIds) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statusChanged(IStatusQueryThread thread, List<? extends IAssetStatusBean> originalStatusChangesList) {
        Set<String> extIds = thread.getExternalIds();
        List<? extends IAssetStatusBean> statusChangesList = this.getMonitoredList(originalStatusChangesList, extIds);
        if (statusChangesList.size() == 0) {
            return;
        }
        QueueConnection connection = null;
        QueueSession session = null;
        QueueSender sender = null;
        try {
            logger.debug((Object)"sending title status to JMS queue");
            InitialContext context = new InitialContext();
            QueueConnectionFactory queueFactory = (QueueConnectionFactory)context.lookup("ConnectionFactory");
            connection = queueFactory.createQueueConnection();
            session = connection.createQueueSession(false, 1);
            Queue queue = (Queue)context.lookup(TITLE_STATUS_QUEUE);
            sender = session.createSender(queue);
            for (int fromIndex = 0; fromIndex < statusChangesList.size(); fromIndex += 10) {
                int toIndex = fromIndex + 10 > statusChangesList.size() ? statusChangesList.size() : fromIndex + 10;
                ObjectMessage message = session.createObjectMessage();
                this.perpareJmsMessage(statusChangesList.subList(fromIndex, toIndex), (Message)message);
                sender.send(queue, (Message)message);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"In sendToQueue()", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception e1) {
                logger.warn((Object)"Problems cleaning up after sending message", (Throwable)e1);
            }
        }
    }

    private List<? extends IAssetStatusBean> getMonitoredList(List<? extends IAssetStatusBean> originalStatusChangesList, Set<String> extIds) {
        ArrayList<DeploymentAssetStatusBean> monitoredStatusChangesList = new ArrayList<DeploymentAssetStatusBean>();
        for (int i = 0; i < originalStatusChangesList.size(); ++i) {
            DeploymentAssetStatusBean info = (DeploymentAssetStatusBean)originalStatusChangesList.get(i);
            String siteId = info.getExtSiteid();
            if (!extIds.contains(siteId)) continue;
            monitoredStatusChangesList.add(info);
        }
        return monitoredStatusChangesList;
    }

    private void display(Set<String> extIds, List<? extends IAssetStatusBean> statusChangesList) {
        for (String string : extIds) {
            System.out.printf("ExtId: %s%n", string);
        }
        for (IAssetStatusBean iAssetStatusBean : statusChangesList) {
            System.out.printf("statuBean: %s%n", iAssetStatusBean);
        }
    }

    private void perpareJmsMessage(List<? extends IAssetStatusBean> statusChangesList, Message message) throws Exception {
        message.setStringProperty("status_plugin_type", StatusPluginType.DEPLOYMENT_STATUS.name());
        message.setIntProperty("results_count", statusChangesList.size());
        for (int i = 0; i < statusChangesList.size(); ++i) {
            DeploymentAssetStatusBean info = (DeploymentAssetStatusBean)statusChangesList.get(i);
            message.setStringProperty("ext_id_" + Integer.toString(i), info.getExtSiteid());
            message.setStringProperty("asset_id_" + Integer.toString(i), info.getAssetID());
            message.setStringProperty("provider_id_" + Integer.toString(i), info.getProviderID());
            message.setStringProperty("status_" + Integer.toString(i), this.mapStatus(info.getStatus().toString()).toString());
        }
    }

    @Override
    public void callCompleted(IStatusQueryThread thread) {
        String threadId = thread.getId();
    }

    @Override
    public void callStarted(IStatusQueryThread thread) {
        logger.debug((Object)("Thread: " + thread.getId() + " was called by the timer."));
    }

    protected final void doStart() throws Exception {
        this._start();
    }

    protected final void doStop() throws Exception {
        this._stop();
    }

    public void setAppStartTime(Date value) {
        this.lastAppStartTime = value;
        for (String key : this.timerMap.keySet()) {
            SingleTaskTimer<IStatusQueryThread> timer = this.timerMap.get(key);
            IStatusQueryThread thread = timer.getTask();
        }
    }

    public String getName() {
        return this.name;
    }

    public Date getAppStartTime() {
        return this.lastAppStartTime;
    }

    protected abstract void _start();
}

