/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring.deployment.testplugin;

import com.ericsson.cms.sites.monitoring.common.SingleTaskTimer;
import com.ericsson.cms.sites.monitoring.config.ConfigurationManager;
import com.ericsson.cms.sites.monitoring.config.IStatusPluginConfiguration;
import com.ericsson.cms.sites.monitoring.deployment.DeploymentStatusPluginBase;
import com.ericsson.cms.sites.monitoring.deployment.testplugin.FileBasedQueryServiceFacade;
import com.ericsson.cms.sites.monitoring.deployment.testplugin.FileBasedStatusThread;
import com.ericsson.cms.sites.monitoring.deployment.testplugin.TestPluginConfigurationParser;
import java.io.File;
import java.util.Map;
import org.apache.log4j.Logger;
import org.java.plugin.registry.PluginDescriptor;

public class TestDeploymentStatusPlugin
extends DeploymentStatusPluginBase {
    private static final Logger logger = Logger.getLogger((String)TestDeploymentStatusPlugin.class.getName());

    @Override
    protected synchronized void _start() {
        try {
            logger.info((Object)"In TestDeploymentStatusPlugin._start()...");
            if (this.started) {
                logger.warn((Object)"TestDeploymentStatusPlugin Already started");
                return;
            }
            this.multiConfiguration.clear();
            this.timerMap.clear();
            ClassLoader loader = this.getClass().getClassLoader();
            PluginDescriptor desc = this.getDescriptor();
            this.locateHomeDirectories(loader, desc);
            if (!this.tempDirectory.exists()) {
                this.tempDirectory.mkdir();
            }
            this.configurationManager = new ConfigurationManager();
            this.configParser = new TestPluginConfigurationParser();
            this.configMap = this.configurationManager.configure(this.configDirectory, this.configParser);
            this.multiConfiguration = TestDeploymentStatusPlugin.translateConfig(this.configMap);
            this.startTimers(this.configMap);
        }
        catch (Exception ex) {
            logger.error((Object)"Error Starting new configuration threads", (Throwable)ex);
            this.stopAllTimers();
            this.started = false;
            return;
        }
        this.started = true;
    }

    @Override
    protected synchronized void startTimers(Map<String, IStatusPluginConfiguration> selectedConfigMap) {
        for (String key : selectedConfigMap.keySet()) {
            IStatusPluginConfiguration config = selectedConfigMap.get(key);
            FileBasedStatusThread thread = new FileBasedStatusThread();
            thread.setId(key);
            File csvDataFile = new File(this.configDirectory, config.getEndpointUrl());
            FileBasedQueryServiceFacade queryService = new FileBasedQueryServiceFacade(csvDataFile);
            thread.setListener(this);
            thread.setQueryService(queryService);
            SingleTaskTimer<FileBasedStatusThread> timer = new SingleTaskTimer<FileBasedStatusThread>(config.getPollInterval(), thread);
            timer.start();
            this.timerMap.put(key, timer);
            logger.info((Object)String.format("Started Thread: %s for configuration ID: %s%n", thread.getId(), key));
        }
    }
}

