/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor;

import com.tandbergtv.workflow.adaptor.AdaptorException;
import com.tandbergtv.workflow.adaptor.AdaptorResponseImpl;
import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.IAdaptorResponse;
import com.tandbergtv.workflow.adaptor.SimulationTask;
import com.tandbergtv.workflow.adaptor.conf.IAdaptorConfiguration;
import com.tandbergtv.workflow.adaptor.config.MessageConfig;
import com.tandbergtv.workflow.adaptor.config.SimulatorConfig;
import com.tandbergtv.workflow.adaptor.config.Unmarshaller;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.adaptor.util.XMLDocumentUtility;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.Marshaller;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AdaptorSimulator
implements IAdaptor {
    private static final String SYSID = "sysId";
    private static final String CONFIGFILE = "configFile";
    private String resourceId;
    private boolean inService = false;
    private SimulatorConfig simulatorConfig;
    private Map<String, SimulationTask> tasks = new HashMap<String, SimulationTask>();

    public AdaptorSimulator() {
        System.out.println("Creating " + AdaptorSimulator.class.getName());
    }

    public void init(IAdaptorConfiguration conf) throws AdaptorException {
        String configFilePath;
        this.resourceId = (String)conf.getParameterValue(SYSID);
        if (this.resourceId == null) {
            throw new AdaptorException("Invalid sysId, can not initialize.");
        }
        this.resourceId = this.resourceId.trim();
        if (this.resourceId.length() > 0) {
            this.inService = true;
            System.out.println(AdaptorSimulator.class.getName() + " initialized. resourceId: " + this.resourceId);
        }
        if ((configFilePath = (String)conf.getParameterValue(CONFIGFILE)) != null && configFilePath.trim().length() > 0) {
            this.readSimulatorConfig(configFilePath);
        }
    }

    public void destroy() {
        this.inService = false;
        if (this.tasks != null) {
            Iterator<String> itr = this.tasks.keySet().iterator();
            while (itr.hasNext()) {
                SimulationTask task = this.tasks.get(itr.next());
                task.destroy();
            }
        }
        System.out.println(AdaptorSimulator.class.getName() + " destroyed. resourceId: " + this.resourceId);
    }

    private void readSimulatorConfig(String configFilePath) throws AdaptorException {
        try {
            Document document = XMLDocumentUtility.loadFile((ClassLoader)this.getClass().getClassLoader(), (String)configFilePath);
            this.simulatorConfig = Unmarshaller.unmarshal(document);
        }
        catch (Exception e) {
            throw new AdaptorException((Throwable)e);
        }
    }

    private WorkflowMessage getRequestMessage(IAdaptorRequest request) throws DispatcherException {
        WorkflowMessage rm = null;
        try {
            IMessage reqMsg = request.getMessage();
            Document doc = XMLDocumentUtility.loadXml((String)reqMsg.getPayload().getContent());
            rm = com.tandbergtv.workflow.message.util.Unmarshaller.unmarshal((Document)doc);
        }
        catch (Exception e) {
            throw new DispatcherException("Workflow message parsing failed. " + e.getMessage(), (Throwable)e);
        }
        return rm;
    }

    private IMessage createResponse(WorkflowMessage result) throws DispatcherException {
        try {
            Document doc = Marshaller.newMarshaller().marshal(result);
            String responseValue = XMLDocumentUtility.convertToString((Node)doc);
            HTTPPayload httpPayload = new HTTPPayload(responseValue);
            HTTPMessage responseMsg = new HTTPMessage(httpPayload);
            return responseMsg;
        }
        catch (Exception e) {
            throw new DispatcherException("Workflow message conversion failed. " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAdaptorResponse transmit(IAdaptorRequest request) throws AdaptorException {
        Map<String, SimulationTask> map;
        if (!this.inService) {
            throw new AdaptorException("Adaptor not in service. Either init is not called or destruction is in progress.");
        }
        WorkflowMessage requestMessage = this.getRequestMessage(request);
        String messageUId = requestMessage.getMessageUID().getUID();
        SimulationTask task = new SimulationTask();
        SimulationTask jobReference = null;
        MessageConfig mConfig = this.simulatorConfig.getMessageConfig(messageUId);
        if (mConfig.getToken() != null && mConfig.getToken().length() > 0) {
            jobReference = this.tasks.get(requestMessage.getParameterValue(mConfig.getToken()));
        }
        WorkflowMessage result = task.execute(requestMessage, mConfig, jobReference);
        IMessage resMsg = this.createResponse(result);
        if (task.isAsync()) {
            map = this.tasks;
            synchronized (map) {
                String taskKey = null;
                if (result.getParameterValue(task.getToken()) != null) {
                    taskKey = result.getParameterValue(task.getToken()).toString();
                }
                if ((taskKey == null || taskKey.trim().length() == 0) && requestMessage.getParameterValue(task.getToken()) != null) {
                    taskKey = requestMessage.getParameterValue(task.getToken()).toString();
                }
                if (taskKey != null && taskKey.trim().length() > 0) {
                    this.tasks.put(taskKey, task);
                }
            }
        }
        if (jobReference != null && jobReference.isTaskComplete()) {
            map = this.tasks;
            synchronized (map) {
                this.tasks.remove(requestMessage.getParameterValue(mConfig.getToken()));
            }
        }
        return new AdaptorResponseImpl(resMsg);
    }

    public boolean canDeliver(IAdaptorRequest request) {
        if (this.inService) {
            // empty if block
        }
        return this.inService;
    }
}

