/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.log.Finder;
import com.tandbergtv.workflow.log.LogSyncState;
import com.tandbergtv.workflow.log.file.Directories;
import com.tandbergtv.workflow.log.file.TimestampFile;
import com.tandbergtv.workflow.log.file.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;

public class LogZipService
implements Service {
    private static final String zippedTimeFile = "zipServiceTime_";
    private static final Logger logger = Logger.getLogger(LogZipService.class);
    private static final int POOL_SIZE = 10;
    private Finder finder;
    private ISchedulerService<Void> scheduler;
    private ISchedulerService<Long> zipScheduler;
    private String dir;
    private long period;

    public LogZipService(SessionFactory factory, String dir, long period) {
        this.finder = new Finder(factory);
        this.scheduler = new Scheduler("log-zip", 1, 1);
        this.zipScheduler = new Scheduler("log-zip-pool", 10, 10);
        this.dir = dir;
        this.period = period;
    }

    public void start() {
        this.zipScheduler.start();
        this.scheduler.start();
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                LogZipService.this.compress();
            }
        }, 0L, this.period * 1000L);
    }

    public void stop() {
        this.zipScheduler.stop();
        this.scheduler.stop();
    }

    public String getServiceName() {
        return "log-zip";
    }

    private void compress() {
        long windowStart = TimestampFile.getMostRecentTimestamp(new File(this.dir), zippedTimeFile);
        if (windowStart == 0L) {
            logger.info((Object)"Initializing zip time because no existing state info (This should only happen once!)");
            this.setZipComplete(System.currentTimeMillis());
            return;
        }
        LogSyncState logSyncState = new LogSyncState(this.dir);
        long windowEnd = logSyncState.getLastSuccessfulRunTime();
        if (windowEnd == 0L || windowEnd <= windowStart) {
            return;
        }
        List<Long> list = this.finder.findCompletedOrCancelledBetween(new Date(windowStart), new Date(windowEnd));
        if (!list.isEmpty()) {
            HashSet<Future> futures = new HashSet<Future>();
            for (LogZipCallable callable : this.partition(list)) {
                futures.add(this.zipScheduler.schedule((Callable)callable));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    logger.error((Object)"Exception waiting for zip callable ", (Throwable)e);
                }
            }
        }
        this.setZipComplete(windowEnd);
    }

    private void setZipComplete(long time) {
        TimestampFile.setMostRecentTimestamp(new File(this.dir), zippedTimeFile, time);
    }

    private Collection<LogZipCallable> partition(List<Long> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ArrayList<LogZipCallable> callables = new ArrayList<LogZipCallable>();
        int size = list.size();
        if (size <= 10) {
            return Collections.singleton(this.createCallable(list));
        }
        int count = size / 10;
        int remainder = size % 10;
        int start = 0;
        for (int i = 0; i < 10; ++i) {
            int end = start + count + (i < remainder ? 1 : 0);
            logger.debug((Object)("Thread " + i + " start " + start + ", end " + end));
            callables.add(this.createCallable(list.subList(start, end)));
            start = end;
        }
        return callables;
    }

    private LogZipCallable createCallable(List<Long> list) {
        return new LogZipCallable(Collections.unmodifiableSet(new HashSet<Long>(list)));
    }

    private class LogZipCallable
    implements Callable<Long> {
        private Set<Long> ids;

        public LogZipCallable(Set<Long> ids) {
            this.ids = ids;
        }

        @Override
        public Long call() throws Exception {
            for (Long id : this.ids) {
                this.compress(id);
            }
            return Collections.max(this.ids);
        }

        private void compress(long id) {
            File nextDir = new File(Directories.pathFor(LogZipService.this.dir, id));
            if (!nextDir.exists() || !nextDir.isDirectory() || new File(ZipUtil.getZipFileName(nextDir)).exists()) {
                return;
            }
            try {
                ZipUtil.compress(nextDir);
                for (File file : nextDir.listFiles()) {
                    if (file.getName().endsWith(".zip")) continue;
                    file.delete();
                }
            }
            catch (IOException e) {
                logger.error((Object)("Unable to compress " + nextDir + ".  " + e.getMessage()));
            }
        }
    }
}

