/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor;

import bsh.EvalError;
import bsh.Interpreter;
import com.tandbergtv.workflow.adaptor.config.MessageConfig;
import com.tandbergtv.workflow.adaptor.config.ParamConfig;
import com.tandbergtv.workflow.adaptor.config.ParamType;
import com.tandbergtv.workflow.adaptor.config.ProgressbarConfig;
import com.tandbergtv.workflow.adaptor.config.ProgressbarType;
import com.tandbergtv.workflow.adaptor.config.ProgressbarValueConfig;
import com.tandbergtv.workflow.adaptor.config.ResponseConfig;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SimulationTask {
    private boolean async = false;
    private String token;
    private Map<String, Integer> currentStates = new HashMap<String, Integer>();
    private Date startTime = null;
    private Date endTime = null;
    private boolean taskComplete = false;

    public WorkflowMessage execute(WorkflowMessage requestMessage, MessageConfig messageConfig, SimulationTask jobReference) {
        this.loadAsyncStates(messageConfig);
        if (messageConfig.getSleep() > 0) {
            try {
                Thread.sleep(messageConfig.getSleep() * 1000);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        WorkflowMessage result = null;
        try {
            result = this.buildResponse(requestMessage, messageConfig, jobReference);
        }
        catch (Exception e) {
            result = this.buildFailureResponse(requestMessage, "Error: " + e.getMessage() + ", Cause: " + e.getCause());
        }
        return result;
    }

    private WorkflowMessage buildFailureResponse(WorkflowMessage requestMessage, String errMsg) {
        WorkflowMessage response = new WorkflowMessage(requestMessage.getMessageUID(), requestMessage.getKey(), WorkflowMessage.MessageType.nack);
        response.putValue("error-message", errMsg);
        return response;
    }

    private WorkflowMessage buildResponse(WorkflowMessage requestMessage, MessageConfig messageConfig, SimulationTask jobReference) {
        WorkflowMessage response = new WorkflowMessage(requestMessage.getMessageUID(), requestMessage.getKey(), WorkflowMessage.MessageType.ack);
        ResponseConfig respConfig = messageConfig.getResponseConfig();
        List<ParamConfig> respParams = respConfig.getParameters();
        for (ParamConfig respParam : respParams) {
            if (ParamType.CONSTANT.equals((Object)respParam.getType())) {
                response.putValue(respParam.getName(), respParam.getValue());
                continue;
            }
            if (ParamType.EXPRESSION.equals((Object)respParam.getType())) {
                response.putValue(respParam.getName(), this.evaluateExp(respParam.getValue(), requestMessage, messageConfig));
                continue;
            }
            if (!ParamType.PROGRESSBAR.equals((Object)respParam.getType())) continue;
            Object prog = this.calculateProgress(respParam.getName(), requestMessage, messageConfig, jobReference);
            response.putValue(respParam.getName(), prog);
            WPCLCommand cmd = new WPCLCommand("task-update");
            ProgressbarConfig pgConfig = messageConfig.getProgressbars().get(respParam.getName());
            if (ProgressbarType.INTEGER.equals((Object)pgConfig.getType())) {
                cmd.addParameter("percent", prog == null ? "0" : prog.toString());
            }
            response.setCommand(cmd);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object calculateProgress(String paramName, WorkflowMessage requestMessage, MessageConfig messageConfig, SimulationTask jobReference) {
        int orgIndex;
        if (jobReference != null && !jobReference.isAsync()) {
            return null;
        }
        ProgressbarConfig pgConfig = messageConfig.getProgressbars().get(paramName);
        List<ProgressbarValueConfig> values = pgConfig.getValues();
        if (jobReference == null) {
            return values.get(values.size() - 1).getValue();
        }
        if (jobReference.currentStates.size() == 0) {
            Map<String, ProgressbarConfig> pbConfig = messageConfig.getProgressbars();
            Iterator<String> itr = pbConfig.keySet().iterator();
            SimulationTask simulationTask = jobReference;
            synchronized (simulationTask) {
                while (itr.hasNext()) {
                    String pName = itr.next();
                    jobReference.currentStates.put(pName, 0);
                }
            }
        }
        int index = orgIndex = jobReference.currentStates.get(paramName).intValue();
        ProgressbarValueConfig currentValue = values.get(index);
        Date now = Calendar.getInstance().getTime();
        if (currentValue.getSequence() < 99) {
            currentValue = values.get(++index);
        } else if (currentValue.getSequence() == 99 && jobReference.endTime.before(now)) {
            currentValue = values.get(++index);
        }
        if (orgIndex != index) {
            SimulationTask simulationTask = jobReference;
            synchronized (simulationTask) {
                jobReference.currentStates.put(paramName, index);
            }
        }
        if (currentValue.getSleep() > 0) {
            try {
                Thread.sleep(currentValue.getSleep() * 1000);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (ProgressbarType.INTEGER.equals((Object)pgConfig.getType()) && currentValue.getSequence() == 99) {
            long fullLength = jobReference.endTime.getTime() - jobReference.startTime.getTime();
            long currentLength = jobReference.endTime.getTime() - now.getTime();
            long progress = 100L - (long)((int)(currentLength * 100L)) / fullLength;
            if (progress >= 100L) {
                progress = 100L;
                jobReference.taskComplete = true;
            }
            return progress;
        }
        if (currentValue.getSequence() == 100) {
            jobReference.taskComplete = true;
        }
        return currentValue.getValue();
    }

    private Object evaluateExp(String expression, WorkflowMessage requestMessage, MessageConfig messageConfig) {
        Interpreter interpreter = new Interpreter();
        Map reqParams = requestMessage.getParameters();
        try {
            for (String pName : reqParams.keySet()) {
                interpreter.set(pName, requestMessage.getParameterValue(pName));
            }
            Object value = interpreter.eval(expression);
            return value;
        }
        catch (EvalError e) {
            return null;
        }
    }

    private void loadAsyncStates(MessageConfig config) {
        if (!config.isAsync()) {
            return;
        }
        this.async = true;
        Calendar cal = Calendar.getInstance();
        this.startTime = cal.getTime();
        cal.add(13, config.getAsyncsleep());
        this.endTime = cal.getTime();
        this.token = config.getToken();
    }

    public boolean isAsync() {
        return this.async;
    }

    public String getToken() {
        return this.token;
    }

    public void destroy() {
    }

    public boolean isTaskComplete() {
        return this.taskComplete;
    }
}

