<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns fn">

	<!-- 
		####################################################################### 
		##### Common fields for MOVIE, PREVIEW and ENCRYPTED assets. 
		####################################################################### 
	-->

	<!-- 
		Template 'movie_preview_encrypted_common': Translates metadata for 
		the selected movie / preview / encrypted asset that is common for all 3 assets. 
	-->
	<xsl:template name="movie_preview_encrypted_common">
		<xsl:param name="app_name" />
		<xsl:param name="asset" />

		<!-- Alternate Bit Rate Resolution -->
		<xsl:for-each
			select="$asset/tns:Fields/tns:Video/tns:AlternateBitRateResolution">
			<App_Data>
				<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
				<xsl:attribute name="Name">Alternate_Bit_Rate_Resolution</xsl:attribute>
				<xsl:attribute name="Value"><xsl:value-of select="." /></xsl:attribute>
			</App_Data>
		</xsl:for-each>

		<!-- AVContainer -->
		<xsl:if test="$asset/tns:Fields/tns:Video/tns:AVContainer">
			<App_Data>
				<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
				<xsl:attribute name="Name">AVContainer</xsl:attribute>
				<xsl:attribute name="Value"><xsl:value-of select="$asset/tns:Fields/tns:Video/tns:AVContainer" /></xsl:attribute>
			</App_Data>
		</xsl:if>

		<!-- Audio Codec -->
		<xsl:for-each
			select="$asset/tns:Fields/tns:Video/tns:AudioInfos/tns:AudioInfo/tns:Codec">
			<App_Data>
				<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
				<xsl:attribute name="Name">Audio_Codec</xsl:attribute>
				<xsl:attribute name="Value"><xsl:value-of select="." /></xsl:attribute>
			</App_Data>
		</xsl:for-each>

		<!-- Equip Capability Profile -->
		<xsl:for-each select="$asset/tns:Fields/tns:EquipCapabilityProfile">
			<App_Data>
				<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
				<xsl:attribute name="Name">Equip_Capability_Profile</xsl:attribute>
				<xsl:attribute name="Value"><xsl:value-of select="." /></xsl:attribute>
			</App_Data>
		</xsl:for-each>

		<!-- Resolution -->
		<xsl:if test="$asset/tns:Fields/tns:Content/tns:Resolution">
			<App_Data>
				<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
				<xsl:attribute name="Name">Resolution</xsl:attribute>
				<xsl:attribute name="Value"><xsl:value-of select="$asset/tns:Fields/tns:Content/tns:Resolution" /></xsl:attribute>
			</App_Data>
		</xsl:if>

		<!-- Frame Rate -->
		<xsl:if test="$asset/tns:Fields/tns:Content/tns:FrameRate">
			<App_Data>
				<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
				<xsl:attribute name="Name">Frame_Rate</xsl:attribute>
				<xsl:attribute name="Value"><xsl:value-of select="$asset/tns:Fields/tns:Content/tns:FrameRate" /></xsl:attribute>
			</App_Data>
		</xsl:if>

		<!-- Codec -->
		<xsl:if test="$asset/tns:Fields/tns:Content/tns:Codec">
			<App_Data>
				<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
				<xsl:attribute name="Name">Codec</xsl:attribute>
				<xsl:attribute name="Value"><xsl:value-of select="$asset/tns:Fields/tns:Content/tns:Codec" /></xsl:attribute>
			</App_Data>
		</xsl:if>

		<!-- Bit Rate -->
		<xsl:if test="$asset/tns:Fields/tns:Video/tns:BitRate">
			<App_Data>
				<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
				<xsl:attribute name="Name">Bit_Rate</xsl:attribute>
				<xsl:attribute name="Value"><xsl:value-of select="$asset/tns:Fields/tns:Video/tns:BitRate/@value" /></xsl:attribute>
			</App_Data>
		</xsl:if>

		<!-- File Size -->
		<xsl:if test="$asset/tns:Fields/tns:Content/tns:Size/tns:length">
			<App_Data>
				<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
				<xsl:attribute name="Name">Content_FileSize</xsl:attribute>
				<xsl:attribute name="Value"><xsl:value-of select="$asset/tns:Fields/tns:Content/tns:Size/tns:length" /></xsl:attribute>
			</App_Data>
		</xsl:if>

		<!-- Checksum -->
		<xsl:if test="$asset/tns:Fields/tns:Content/tns:Checksum">
			<App_Data>
				<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
				<xsl:attribute name="Name">Content_CheckSum</xsl:attribute>
				<xsl:attribute name="Value"><xsl:value-of select="$asset/tns:Fields/tns:Content/tns:Checksum" /></xsl:attribute>
			</App_Data>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
