package com.tandbergtv.cms.rules.custom.normalization;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
//import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
//import com.tandbergtv.cms.rules.custom.NameLookup;
import com.tandbergtv.cms.rules.customrules.CustomNormalizationRule;
import com.tandbergtv.cms.rules.customrules.CustomRuleParameter;
import com.tandbergtv.marvin.udt.RuleResults;
//import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.Title;

/**
 * Custom Rule will clear value of the field - test from 1.x to 2.0
 * 
 * 
 * @author Samuel
 * 
 */
public class CustomRuleClearField implements CustomNormalizationRule{
	
	//private String filename = "test.txt";
	private static final Logger logger = Logger.getLogger(CustomRuleClearField.class);
	public RuleResults runRule(Map<String, Object> parameters, Title title) {

		RuleResults result = new RuleResults(title);
		BufferedReader br =null;
		FileReader freader =null;
		File f;
		try{
			String xPath ="";
			f = new File("/opt/tandbergtv/cms/conf/ChangedXpath.txt");
			freader = new FileReader(f);
			br = new BufferedReader(freader);	
			while((xPath = br.readLine()) != null)
			{
				if(!xPath.isEmpty())
				{
					Pattern p = Pattern.compile("^#.*");
					Matcher m = p.matcher(xPath);
					if(!m.matches()){
						String[] st = xPath.split(",");
						if(st.length!=0){
							xPath = st[0];
							String datatype = new FindDataTypeOfXpath().returnDataTypeOfXpath(xPath);
							if(!datatype.isEmpty())
							{
								//System.out.println ("DataType ="+datatype);
								clearFieldValue(xPath, datatype, title);
							}	
						}
					}
				}	 
			}	
			
		}catch(Exception e)
		{
			e.printStackTrace();
			logger.warn("Something went wrong while reading the file for xpath "+e.getMessage());
			
		}
		finally{
			try{
				if(br !=null)	br.close();
				if(freader !=null) freader.close();
			}catch(Exception e)
			{
				logger.warn("Failed to closed the file: "+e.getMessage());
			}
		}
		
		result.setModified(true);
		
		return result;
	}

	
	@Override
	public String getName(Locale locale) {
		return "CustomRuleClearField";
	}

	@Override
	public List<CustomRuleParameter> getParameters(Locale locale) {
		return new ArrayList<CustomRuleParameter>();
	}
	
	public void clearFieldValue(String xPath, String datatype, Title title)
	{
	//	#If the value is set for the fields and the length is more than 5 chars this rule will clear the values
	
		List<String> titleAsset= new ArrayList<String>();
		titleAsset.add("PACKAGE");
		titleAsset.add("TITLE");
	//	titleAsset.add("MOVIE");
	//	titleAsset.add("PREVIEW");
		
		List<Field> availFields = title.getAsset().getAllFieldsForXpath(titleAsset, xPath);
	
		logger.info("XPath ="+xPath +", Size ="+availFields.size() );
	
			
		if(availFields.size()>0 && availFields.get(0).getParsable() )
		{
			String strValue = availFields.get(0).getValue();
			logger.info("Value ="+strValue);
				
					if(datatype.equalsIgnoreCase("integer"))
					{
				
							availFields.get(0).setTypedValue(new Integer(0));
				
					}
					if(datatype.equalsIgnoreCase("boolean"))
					{
						availFields.get(0).setTypedValue(new Boolean(false)); //confirm with dev about the default value for boolean
					}	
					else{
			
							availFields.get(0).setValue("");
				
					}	
		}
	}
	
}
