package com.tandbergtv.cms.rules.custom.normalization;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.log4j.Logger;

import com.tandbergtv.cms.rules.customrules.CustomNormalizationRule;
import com.tandbergtv.cms.rules.customrules.CustomRuleParameter;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.Title;

public class CustomRuleCopyValueOfTheFieldToAnotherField implements CustomNormalizationRule{
	
	private static final Logger logger = Logger.getLogger(CustomRuleCopyValueOfTheFieldToAnotherField.class);
	
	public RuleResults runRule(Map<String, Object> parameters, Title title) {
		
		RuleResults result = new RuleResults(title);
		BufferedReader br =null;
		FileReader freader = null;
		File f;
		try{
			String xPath ="";
			f = new File("/opt/tandbergtv/cms/conf/ChangedPackageXpath.txt");
			freader = new FileReader(f);
			br = new BufferedReader(freader);	
			while((xPath = br.readLine()) != null)
			{
				if(!xPath.isEmpty())
				{
					if(!IsSubStrFound(xPath,"^#.*")) //If xPath starts with '#' then ignore that line (the line is a comment)
					{
						String[] st = xPath.split(",");
						if(st.length!=0){
							xPath = st[0];
							String datatype = new FindDataTypeOfXpath().returnDataTypeOfXpath(xPath);
							if(!datatype.isEmpty())
							{
								addFieldWithDefaultValue(xPath, datatype, title);
							}
							else{
								if(xPath.indexOf("TimeCode")>0)
								{
									addFieldWithDefaultValue(xPath, "TimeCode", title);
								}
								else
									addFieldWithDefaultValue(xPath, "string", title);
							}
						}
					}
				}	 
			}	
			
		}catch(Exception e)
		{
			e.printStackTrace();
			logger.warn("Something went wrong while reading the file for xpath "+e.getMessage());
			
		}
		finally{
			try{
				
				if (br !=null) br.close();
				if (freader !=null) freader.close();
				
			}catch(Exception e)
			{
				logger.warn("Failed to closed the file: "+e.getMessage());
			}
		}
		
		result.setModified(true);
		
		return result;
	}

	
	@Override
	public String getName(Locale locale) {
		return "CustomRulesForMovieFields";
	}

	@Override
	public List<CustomRuleParameter> getParameters(Locale locale) {
		return new ArrayList<CustomRuleParameter>();
	}
	
	public void addFieldWithDefaultValue(String xPath, String datatype, Title title)
	{
		List<String> titleAsset= new ArrayList<String>();
		titleAsset.add("PACKAGE");
		
	
	//	List<Asset> titleAssetObj = title.getAsset().getAllAssetsOfType("TITLE");
		List<Asset> titleAssetObj = title.getAsset().getAllAssetsWithLineage(titleAsset);
		List<Field> availFields = title.getAsset().getAllFieldsForXpath(titleAsset, xPath);
	
		logger.info("XPath ="+xPath +", Size ="+availFields.size() );
		
			
		if(availFields.size()==0)
		{
			Field field = new Field();
			field.setTtvXPath(xPath);
			if(datatype.equalsIgnoreCase("integer"))
			{
				field.setTypedValue(new Integer(100));
			}
			if(datatype.equalsIgnoreCase("boolean"))
			{
				field.setTypedValue(new Boolean(true));
			}
			if(datatype.equalsIgnoreCase("TimeCode"))
			{
				field.setValue("00:00:01:10");
			}
			else
			{
				field.setTypedValue("Default");
			}
			field.setIndices(FindDataTypeOfXpath.getNewIndices(xPath));
			titleAssetObj.get(0).addField(field);
		}
		
		availFields = title.getAsset().getAllFieldsForXpath(titleAsset, xPath);
		
		logger.info("XPath ="+xPath +", Size ="+availFields.size() );
		
			
		if(availFields.size()>0 && availFields.get(0).getParsable() )
		{
			String strValue = availFields.get(0).getValue();
			String xPathStrValueConcat = xPath +"="+strValue+"/";
			logger.info("Value ="+xPathStrValueConcat);
		}	
					
		
	}
	public boolean IsSubStrFound(String str, String subStr)
	{
		boolean b = false;
		Pattern p = Pattern.compile(subStr);
		Matcher m = p.matcher(str);
		if (m.matches())
			b= true;
				
		return b;
	}
		
}
