package com.tandbergtv.cms.rules.custom.normalization;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
//import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
//import com.tandbergtv.cms.rules.custom.NameLookup;
import com.tandbergtv.cms.rules.customrules.CustomNormalizationRule;
import com.tandbergtv.cms.rules.customrules.CustomRuleParameter;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.Title;

/**
 * Custom Rule will copy value of the field to another field(Medium Summary) - test from 1.x to 2.0
 * 
 * 
 * @author Samuel
 * 
 */
public class CustomRulePackageAddFields implements CustomNormalizationRule{
	
	private static final Logger logger = Logger.getLogger(CustomRulePackageAddFields.class);
	private final String MEDIUM_SUMMARY_XPATH ="/tns:Fields/tns:Summary/tns:MediumSummary/tns:Value"; 
	private final String SHORT_SUMMARY_XPATH ="/tns:Fields/tns:Summary/tns:ShortSummary/tns:Value"; 
	private StringBuffer strBuffer,defaultBuffer;
	public RuleResults runRule(Map<String, Object> parameters, Title title) {
		
		defaultBuffer = new StringBuffer("");
		strBuffer = new StringBuffer("");
		RuleResults result = new RuleResults(title);
		BufferedReader br =null;
		FileReader freader =null;
		File f;
		try{
			String xPath ="";
			f = new File("/opt/tandbergtv/cms/conf/ChangedXpath.txt");
			freader = new FileReader(f);
			br = new BufferedReader(freader);	
			while((xPath = br.readLine()) != null)
			{
				if(!xPath.isEmpty())
				{
					Pattern p = Pattern.compile("^#.*");
					Matcher m = p.matcher(xPath);
					if(!m.matches()){
						String[] st = xPath.split(",");
						if(st.length!=0){
							xPath = st[0];
							String datatype = new FindDataTypeOfXpath().returnDataTypeOfXpath(xPath);
							if(!datatype.isEmpty())
							{
								//System.out.println ("DataType ="+datatype);
								copyFieldValueToAnotherField(xPath, datatype, title);
							}	
						}
					}
				}	 
			}	
		
		}catch(Exception e)
		{
			e.printStackTrace();
			logger.warn("Something went wrong while reading the file for xpath "+e.getMessage());
			
		}
		finally{
			try{
				if(br != null) br.close();
				if (freader !=null) freader.close();
				
			}catch(Exception e)
			{
				logger.warn("Failed to closed the file: "+e.getMessage());
			}
				
		}
		
		result.setModified(true);
		
		return result;
	}

	
	@Override
	public String getName(Locale locale) {
		return "CustomRuleCopyValueOfTheFieldToAnotherField";
	}

	@Override
	public List<CustomRuleParameter> getParameters(Locale locale) {
		return new ArrayList<CustomRuleParameter>();
	}
	
	public void copyFieldValueToAnotherField(String xPath, String datatype, Title title)
	{
		List<String> titleAsset= new ArrayList<String>();
		titleAsset.add("PACKAGE");
		titleAsset.add("TITLE");
	
	//	List<Asset> titleAssetObj = title.getAsset().getAllAssetsOfType("title");
		List<Asset> titleAssetObj = title.getAsset().getAllAssetsWithLineage(titleAsset);
		List<Field> availFields = title.getAsset().getAllFieldsForXpath(titleAsset, xPath);
	
		logger.info("XPath ="+xPath +", Size ="+availFields.size() );
		
			
		if(availFields.size()>0 && availFields.get(0).getParsable() )
		{
			String strValue = availFields.get(0).getValue();
			String xPathStrValueConcat = xPath +"="+strValue+"/";
			logger.info("Value ="+xPathStrValueConcat);
			
			if(datatype.equalsIgnoreCase("integer"))
			{
		
				List<Field> shortSummary = title.getAsset().getAllFieldsForXpath(titleAsset, SHORT_SUMMARY_XPATH);
				if(shortSummary.size()==0){
					Field field = new Field();
					field.setTtvXPath(SHORT_SUMMARY_XPATH);
					field.setTypedValue(xPathStrValueConcat);
					field.setIndices(FindDataTypeOfXpath.getNewIndices(SHORT_SUMMARY_XPATH));

				}
				else{
					defaultBuffer.append(xPathStrValueConcat);
					shortSummary.get(0).setValue(defaultBuffer.toString());
					
				}
			}
			if(datatype.equalsIgnoreCase("boolean"))
			{

				List<Field> shortSummary = title.getAsset().getAllFieldsForXpath(titleAsset, SHORT_SUMMARY_XPATH);
				if(shortSummary.size()==0){
					Field field = new Field();
					field.setTtvXPath(SHORT_SUMMARY_XPATH);
					field.setTypedValue(xPathStrValueConcat);
					field.setIndices(FindDataTypeOfXpath.getNewIndices(SHORT_SUMMARY_XPATH));
					titleAssetObj.get(0).addField(field);
				}
				else{
					defaultBuffer.append(xPathStrValueConcat);
					shortSummary.get(0).setValue(defaultBuffer.toString());
					
				}
			}	
			else{
	
				List<Field> mediumSummary = title.getAsset().getAllFieldsForXpath(titleAsset, MEDIUM_SUMMARY_XPATH);
				if(mediumSummary.size()==0){
					Field field = new Field();
					field.setTtvXPath(MEDIUM_SUMMARY_XPATH);
					field.setTypedValue(xPathStrValueConcat);
					field.setIndices(FindDataTypeOfXpath.getNewIndices(MEDIUM_SUMMARY_XPATH));
					titleAssetObj.get(0).addField(field);
					

				}
				else{
					strBuffer.append( xPathStrValueConcat);
					mediumSummary.get(0).setValue(strBuffer.toString());
		
			
				}
			}
					
		}
	}
		
}
