#
# bindkey.tcsh		Bind keys on escape sequences of xterm
#			and linux console
#
# Copyright: 1993-2002 Werner Fink, 1996-2002 SuSE Linux AG, Germany
#
# Author:  Werner Fink <feedback@suse.de>

#
# Default values
#
if ( ! ${?TERM} ) setenv TERM linux
if ( ! ${?CSHEDIT} ) setenv CSHEDIT emacs

#
# VI line editing
#
if ( "$CSHEDIT" == "vi" ) then
	bindkey    -v
else
	bindkey    "^[ "	magic-space
	bindkey    "^[!"	expand-history
endif
#
# Common standard keypad and cursor
#
bindkey    "^[[2~"		yank
bindkey    "^[[3~"		delete-char
bindkey    "^[[5~"		history-search-backward
bindkey    "^[[6~"		history-search-forward
if ( "$TERM" == "xterm" ) then
	bindkey    "\e[2;2~"	yank
	bindkey    "\e[3;2~"	delete-char
	bindkey    "\e[5;2~"	history-search-backward
	bindkey    "\e[6;2~"	history-search-forward
	bindkey    "\e[2;5~"	yank
	bindkey    "\e[3;5~"	delete-char
	bindkey    "\e[5;5~"	history-search-backward
	bindkey    "\e[6;5~"	history-search-forward
endif
bindkey    "^[[C"		forward-char
bindkey    "^[[D"		backward-char
bindkey    "^[[A"		up-history
bindkey    "^[[B"		down-history
if ( "$TERM" == "xterm" ) then
	bindkey -c "^[[E"	"source /etc/csh.cshrc"
	bindkey    "^[[2C"	forward-word
	bindkey    "^[[2D"	backward-word
	bindkey    "^[[2A"	history-search-backward
	bindkey    "^[[2B"	history-search-forward
	bindkey    "^[[5C"	forward-word
	bindkey    "^[[5D"	backward-word
	bindkey    "^[[5A"	history-search-backward
	bindkey    "^[[5B"	history-search-forward
else
	bindkey -c "^[[G"	"source /etc/csh.cshrc"
endif
#
# Avoid network problems
#   ... \177 (ASCII-DEL) and \010 (ASCII-BS)
#       do `backward-delete-char'
# Note: `delete-char' is maped to \033[3~
#       Therefore xterm's responce on pressing
#       key Delete or KP-Delete should be
#       \033[3~ ... NOT \177
#
bindkey    "^?"		backward-delete-char
bindkey    "^H"		backward-delete-char
#
# Home and End
#
if ( "$TERM" == "xterm" ) then
	#
	# Normal keypad and cursor of xterm
	#
	bindkey    "^[[1~"	history-search-backward
	bindkey    "^[[4~"	set-mark-command
	bindkey    "^[[H"	beginning-of-line
	bindkey    "^[[F"	end-of-line
	bindkey    "^[[2H"	beginning-of-line
	bindkey    "^[[2F"	end-of-line
	bindkey    "^[[5H"	beginning-of-line
	bindkey    "^[[5F"	end-of-line
	# Home and End of application keypad and cursor of xterm
	bindkey    "^[OH"	beginning-of-line
	bindkey    "^[OF"	end-of-line
	bindkey    "^[O2H"	beginning-of-line
	bindkey    "^[O2F"	end-of-line
	bindkey    "^[O5H"	beginning-of-line
	bindkey    "^[O5F"	end-of-line
else
if ( "$TERM" == "kvt" ) then
	bindkey    "^[[1~"	history-search-backward
	bindkey    "^[[4~"	set-mark-command
	bindkey    "^[OH"	beginning-of-line
	bindkey    "^[OF"	end-of-line
endif
	#
	# TERM=linux or console
	#
	bindkey    "^[[1~"	beginning-of-line
	bindkey    "^[[4~"	end-of-line
endif
#
# Application keypad and cursor of xterm
#
if ( "$TERM" == "xterm" ) then
	bindkey    "^[OD"	backward-char
	bindkey    "^[OC"	forward-char
	bindkey    "^[OA"	up-history
	bindkey    "^[OB"	down-history
	bindkey    "^[O2D"	backward-word
	bindkey    "^[O2C"	forward-word
	bindkey    "^[O2A"	history-search-backward
	bindkey    "^[O2B"	history-search-forward
	bindkey    "^[O5D"	backward-word
	bindkey    "^[O5C"	forward-word
	bindkey    "^[O5A"	history-search-backward
	bindkey    "^[O5B"	history-search-forward
	bindkey -c "^[OE"	"source /etc/csh.cshrc"
	# DEC keyboard KP_F1 - KP_F4 or
	# XTerm of XFree86 in VT220 mode F1 - F4
	bindkey -s "^[OP"	"^["
	bindkey    "^[OQ"	vi-undo
	bindkey    "^[OR"	undefined-key
	bindkey    "^[OS"	kill-line
endif
if ( "$TERM" == "gnome" ) then
	# or gnome terminal F1 - F4
	bindkey -s "^[OP"	"^["
	bindkey    "^[OQ"	vi-undo
	bindkey    "^[OR"	undefined-key
	bindkey    "^[OS"	kill-line
endif
#
# Function keys F1 - F12
#
if ( "$TERM" == "linux" ) then
	#
	# On console the first five function keys
	#
	bindkey -s "^[[[A"	"^["
	bindkey    "^[[[B"	vi-undo
	bindkey    "^[[[C"	undefined-key
	bindkey    "^[[[D"	kill-line
	bindkey    "^[[[E"	undefined-key
else
	#
	# The first five standard function keys
	#
	bindkey -s "^[[11~"	"^["
	bindkey    "^[[12~"	vi-undo
	bindkey    "^[[13~"	undefined-key
	bindkey    "^[[14~"	kill-line
	bindkey    "^[[15~"	undefined-key
endif
bindkey    "^[[17~"		undefined-key
bindkey    "^[[18~"		undefined-key
bindkey    "^[[19~"		undefined-key
bindkey    "^[[20~"		undefined-key
bindkey    "^[[21~"		undefined-key
# Note: F11, F12 are identical with Shift_F1 and Shift_F2
bindkey    "^[[23~"		undefined-key
bindkey    "^[[24~"		undefined-key
#
# Shift Function keys F1  - F12
#      identical with F11 - F22
#
# bindkey   "^[[23~"	undefined-key
# bindkey   "^[[24~"	undefined-key
bindkey    "^[[25~"		undefined-key
bindkey    "^[[26~"		undefined-key
# DEC keyboard: F15=^[[28~ is Help
bindkey    "^[[28~"		undefined-key
# DEC keyboard: F16=^[[29~ is Menu
bindkey    "^[[29~"		undefined-key
bindkey    "^[[31~"		undefined-key
bindkey    "^[[32~"		undefined-key
bindkey    "^[[33~"		undefined-key
bindkey    "^[[34~"		undefined-key
if ( "$TERM" == "xterm" ) then
	# Not common
	bindkey    "^[[35~"	undefined-key
	bindkey    "^[[36~"	undefined-key
endif
#
if ( "$TERM" == "xterm" ) then
	#
	# Application keypad and cursor of xterm
	# with NumLock ON
	#
	# Operators
	bindkey -s "^[Oo"	"/"
	bindkey -s "^[Oj"	"*"
	bindkey -s "^[Om"	"-"
	bindkey -s "^[Ok"	"+"
	bindkey -s "^[Ol"	","
	bindkey    "^[OM"	newline
	bindkey -s "^[On"	"."
	# Numbers
	bindkey -s "^[Op"	"0"
	bindkey -s "^[Oq"	"1"
	bindkey -s "^[Or"	"2"
	bindkey -s "^[Os"	"3"
	bindkey -s "^[Ot"	"4"
	bindkey -s "^[Ou"	"5"
	bindkey -s "^[Ov"	"6"
	bindkey -s "^[Ow"	"7"
	bindkey -s "^[Ox"	"8"
	bindkey -s "^[Oy"	"9"
endif
#
#  EMACS line editing
#
if ( "$CSHEDIT" == "emacs" ) then 
	#
	# ... xterm application cursor
	#
    	if ( "$TERM" == "xterm" ) then
	     bindkey    "^[^[OD"	backward-word
	     bindkey    "^[^[OC"	forward-word
	     bindkey    "^[^[OA"	up-history
	     bindkey    "^[^[OB"	down-history
	     bindkey    "^^[OD"		backward-char
	     bindkey    "^^[OC"		forward-char
	     bindkey    "^^[OA"		up-history
	     bindkey    "^^[OB"		down-history
    	endif
	#
	# Standard cursor
	#
	bindkey    "^[^[[D"	backward-word
	bindkey    "^[^[[C"	forward-word
	bindkey    "^[^[[A"	up-history
	bindkey    "^[^[[B"	down-history
	bindkey    "^^[[D"	backward-char
	bindkey    "^^[[C"	forward-char
	bindkey    "^^[[A"	up-history
	bindkey    "^^[[B"	down-history
endif
#
# end bindkey.tcsh
#
