<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:xs="http://www.w3.org/2001/XMLSchema"
xmlns:fn="http://www.w3.org/2005/xpath-functions"
xmlns:tns="http://www.tandbergtv.com/TTVSchema"
exclude-result-prefixes="tns fn xs">
<xsl:import href="from/customFields.xsl"/>

<xsl:attribute-set name="AmsAttributeSet">
	<xsl:attribute name="Provider">
    	<xsl:value-of select="tns:Fields/tns:ProviderInfo/tns:Name" />
	</xsl:attribute>
	<xsl:attribute name="Product">
		<xsl:value-of select="tns:Fields/tns:ProductInfo/tns:Name" />
	</xsl:attribute>
	<xsl:attribute name="Asset_Name">
		<xsl:value-of select="tns:Fields/tns:AssetName" />
	</xsl:attribute>
	<xsl:attribute name="Version_Major">
		<xsl:value-of select="tns:Fields/tns:Version/tns:Major" />
	</xsl:attribute>
	<xsl:attribute name="Version_Minor">
		<xsl:value-of select="tns:Fields/tns:Version/tns:Minor" />
	</xsl:attribute>
	<xsl:attribute name="Description">
		<xsl:value-of select="tns:Fields/tns:Description/tns:Text" />
	</xsl:attribute>
	<xsl:attribute name="Creation_Date">
		<xsl:value-of select="fn:substring(tns:Fields/tns:CreationInfo/tns:CreateDate, 1, 10)" />
	</xsl:attribute>
	<xsl:attribute name="Provider_ID">
		<xsl:value-of select="tns:Fields/tns:ProviderInfo/tns:Identifier/tns:Id" />
	</xsl:attribute>
	<xsl:attribute name="Asset_ID">
		<xsl:value-of select="tns:Fields/tns:Identifier/tns:Id" />
	</xsl:attribute>
	<xsl:attribute name="Verb">
		<xsl:if test="fn:lower-case(tns:Fields/tns:Verb) = 'delete'">DELETE</xsl:if>
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="ApplicationAttributeSet">
	<xsl:attribute name="App">
		<xsl:value-of select="tns:Fields/tns:ApplicationInfo/tns:Name" />
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="ContentAttributeSet">
	<xsl:attribute name="Value">
		<xsl:analyze-string select="fn:translate(tns:Fields/tns:Content/tns:Locator/tns:Uri, '/', '\')" regex=".*\\([^\\]+$)">
		  <xsl:matching-substring>
		    <xsl:value-of select="regex-group(1)"/>
		  </xsl:matching-substring>
		  <xsl:non-matching-substring>
		    <xsl:value-of select="."/>
		  </xsl:non-matching-substring>
		</xsl:analyze-string>
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="TitleAttribute">
	<xsl:attribute name="Name">Title</xsl:attribute>
	<xsl:attribute name="Value">
    	<xsl:value-of select="tns:Fields/tns:Title/tns:DisplayTitle/tns:Value" />
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="ShortSummaryAttribute">
	<xsl:attribute name="Name">Summary_Short</xsl:attribute>
	<xsl:attribute name="Value">
    	<xsl:value-of select="tns:Fields/tns:Summary/tns:ShortSummary/tns:Value" />
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="CaptionAttribute">
	<xsl:attribute name="Name">Closed_Captioning</xsl:attribute>
	<xsl:attribute name="Value">
		<xsl:choose>
			<xsl:when test="fn:lower-case(tns:Fields/tns:Caption/tns:Value) = 'true'">Y</xsl:when>
			<xsl:when test="fn:lower-case(tns:Fields/tns:Caption/tns:Value) = 'false'">N</xsl:when>
			<xsl:otherwise><xsl:value-of select="tns:Fields/tns:Caption/tns:Value" /></xsl:otherwise>
		</xsl:choose>
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="RunTimeAttribute">
	<xsl:attribute name="Name">Run_Time</xsl:attribute>
	<xsl:attribute name="Value">
    	<xsl:value-of select="tns:Fields/tns:Duration/tns:Duration" />
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="DisplayRunTimeAttribute">
	<xsl:attribute name="Name">Display_Run_Time</xsl:attribute>
	<xsl:attribute name="Value">
    	<xsl:value-of select="tns:Fields/tns:Duration/tns:DisplayDuration" />
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="YearAttribute">
	<xsl:attribute name="Name">Year</xsl:attribute>
	<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:CreationInfo/tns:PublicationDate" />
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="StudioAttribute">
	<xsl:attribute name="Name">Studio</xsl:attribute>
	<xsl:attribute name="Value">
    	<xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Studio/tns:DisplayName" />
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="LicensingWindowStartAttribute">
	<xsl:attribute name="Name">Licensing_Window_Start</xsl:attribute>
	<xsl:attribute name="Value">
	    <xsl:value-of select="tns:Fields/tns:Rights/tns:LicensingWindowStart" />
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="LicensingWindowEndAttribute">
	<xsl:attribute name="Name">Licensing_Window_End</xsl:attribute>
	<xsl:attribute name="Value">
	    <xsl:value-of select="fn:replace(tns:Fields/tns:Rights/tns:LicensingWindowEnd, 'T00:00:00', '')" />
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="ProfileAttribute">
	<xsl:attribute name="Name">Profile</xsl:attribute>
		<xsl:attribute name="Value">
			<xsl:value-of select="tns:Fields/tns:Profile" />
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="ScreenFormatAttribute">
	<xsl:attribute name="Name">Screen_Format</xsl:attribute>
	<xsl:attribute name="Value">
	    <xsl:value-of select="tns:Fields/tns:Video/tns:ScreenFormat" />
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="HDContentAttribute">
	<xsl:attribute name="Name">HDContent</xsl:attribute>
	<xsl:attribute name="Value">
		<xsl:choose>
			<xsl:when test="fn:lower-case(tns:Fields/tns:Video/tns:HDContent) = 'true'">Y</xsl:when>
			<xsl:when test="fn:lower-case(tns:Fields/tns:Video/tns:HDContent) = 'false'">N</xsl:when>
			<xsl:otherwise><xsl:value-of select="tns:Fields/tns:Video/tns:HDContent" /></xsl:otherwise>
		</xsl:choose>
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="BitRateAttribute">
	<xsl:attribute name="Name">Bit_Rate</xsl:attribute>
	<xsl:attribute name="Value">
	    <xsl:value-of select="tns:Fields/tns:Video/tns:BitRate/@value" />
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="ContentFileSizeAttribute">
	<xsl:attribute name="Name">Content_FileSize</xsl:attribute>
	<xsl:attribute name="Value">
	    <xsl:value-of select="tns:Fields/tns:Content/tns:Size/tns:length" />
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="ContentChecksumAttribute">
	<xsl:attribute name="Name">Content_CheckSum</xsl:attribute>
	<xsl:attribute name="Value">
	    <xsl:value-of select="tns:Fields/tns:Content/tns:Checksum" />
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="ContentResolution">
	<xsl:attribute name="Name">Resolution</xsl:attribute>
	<xsl:attribute name="Value">
	    <xsl:value-of select="tns:Fields/tns:Content/tns:Resolution" />
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="ContentFrameRate">
	<xsl:attribute name="Name">Frame_Rate</xsl:attribute>
	<xsl:attribute name="Value">
	    <xsl:value-of select="tns:Fields/tns:Content/tns:FrameRate" />
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="ContentCodec">
	<xsl:attribute name="Name">Codec</xsl:attribute>
	<xsl:attribute name="Value">
	    <xsl:value-of select="tns:Fields/tns:Content/tns:Codec" />
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="ImageAspectRatioAttribute">
	<xsl:attribute name="Name">Image_Aspect_Ratio</xsl:attribute>
	<xsl:attribute name="Value">
	    <xsl:value-of select="tns:Fields/tns:Image/tns:AspectRatio" />
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="VendorNameAttribute">
	<xsl:attribute name="Name">Vendor_Name</xsl:attribute>
	<xsl:attribute name="Value">
	    <xsl:value-of select="tns:Fields/tns:Vendor/tns:Name" />
	</xsl:attribute>
</xsl:attribute-set>

</xsl:stylesheet>
