<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:xs="http://www.w3.org/2001/XMLSchema"
xmlns:fn="http://www.w3.org/2005/xpath-functions"
xmlns:tns="http://www.tandbergtv.com/TTVSchema"
exclude-result-prefixes="tns fn xs">
<xsl:import href="from/common.xsl"/>

<xsl:template match="tns:TTVSpec/tns:Item[@type = 'ENCRYPTED']">
	<Asset>
		<Metadata>
			<AMS xsl:use-attribute-sets="AmsAttributeSet" >
				<xsl:attribute name="Asset_Class">
					<xsl:choose>
						<xsl:when test="fn:normalize-space(tns:Fields/tns:AssetClass) = ''">encrypted</xsl:when>
						<xsl:otherwise><xsl:value-of select="tns:Fields/tns:AssetClass" /></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</AMS>
			<xsl:if test="tns:Fields/tns:Video/tns:BitRate">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet BitRateAttribute" />
			</xsl:if>
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentFileSizeAttribute" />
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentChecksumAttribute" />
			<xsl:if test="tns:Fields/tns:Vendor/tns:Name">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet VendorNameAttribute" />
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Encryption/tns:Asset/tns:Identifier/tns:Id">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Asset_Encrypted</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Encryption/tns:Asset/tns:Identifier/tns:Id" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
				<xsl:attribute name="Name">Receiver_Type</xsl:attribute>
				<xsl:attribute name="Value">
				    <xsl:value-of select="tns:Fields/tns:Receiver/tns:Type" />
				</xsl:attribute>
			</App_Data>
			<xsl:if test="tns:Fields/tns:Receiver/tns:Version/tns:Value">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Receiver_Version</xsl:attribute>
					<xsl:attribute name="Value">
						<xsl:choose>
							<xsl:when test="tns:Fields/tns:Receiver/tns:Version/tns:Value castable as xs:float">
					    		<xsl:value-of select="fn:floor(tns:Fields/tns:Receiver/tns:Version/tns:Value)" />
				    		</xsl:when>
				    		<xsl:otherwise>
					    		<xsl:value-of select="tns:Fields/tns:Receiver/tns:Version/tns:Value" />
				    		</xsl:otherwise>
			    		</xsl:choose>
					</xsl:attribute>
				</App_Data>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Encryption/tns:Type">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Encryption_Type</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Encryption/tns:Type" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Encryption/tns:Algorithm">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Encryption_Algorithm</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Encryption/tns:Algorithm" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Encryption/tns:Date">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Encryption_Date</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Encryption/tns:Date" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Encryption/tns:Time">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Encryption_Time</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Encryption/tns:Time" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Encryption/tns:SystemInfo">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Encrypting_System_Info</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Encryption/tns:SystemInfo" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Encryption/tns:KeyBlock">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Encryption_Key_Block</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Encryption/tns:KeyBlock" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>
			
			<xsl:if test="tns:Fields/tns:Content/tns:Resolution" >
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentResolution" />
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Content/tns:FrameRate" >
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentFrameRate" />
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Content/tns:Codec" >
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentCodec" />
			</xsl:if>
			
			<!--  Custom Field -->
			<xsl:apply-templates select="tns:Fields/tns:CustomFields"/>
			<xsl:apply-templates select="tns:Fields/tns:CustomFields-CL1_1"/>
		</Metadata>
		<Content xsl:use-attribute-sets="ContentAttributeSet" />
	</Asset>
</xsl:template>


</xsl:stylesheet>